/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.jbpm.process.core.timer.BusinessCalendarImpl;
import org.jbpm.test.JbpmTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;

public class HumanTaskReassignmentTest
extends JbpmTestCase {
    private static final String PROCESS_FILE = "org/jbpm/test/functional/task/TaskReassignmentTimeout.bpmn2";
    private static final String PROCESS_ID = "com.bpms.functional.bpmn2.task.TaskReassignmentTimeout";
    private static final String JOHN = "john";
    private static final String MARY = "mary";
    private KieSession ksession;
    private TaskService taskService;
    private RuntimeManager runtimeManager;
    private RuntimeEngine engine;

    public HumanTaskReassignmentTest() {
        super(true, true);
    }

    @Before
    public void init() {
        this.runtimeManager = this.createRuntimeManager(new String[]{PROCESS_FILE});
        this.engine = this.getRuntimeEngine();
        this.ksession = this.engine.getKieSession();
        this.taskService = this.engine.getTaskService();
    }

    @After
    public void cleanup() {
        this.runtimeManager.disposeRuntimeEngine(this.engine);
        this.runtimeManager.close();
    }

    private void testTimeout(boolean businessHour) throws InterruptedException {
        long pid = this.ksession.startProcess(PROCESS_ID).getId();
        long taskId = (Long)this.taskService.getTasksByProcessInstanceId(pid).get(0);
        String potOwner = this.getTaskPotentialOwner(taskId);
        HumanTaskReassignmentTest.assertEquals((Object)JOHN, (Object)potOwner);
        Thread.sleep(2000L);
        potOwner = this.getTaskPotentialOwner(taskId);
        HumanTaskReassignmentTest.assertEquals((Object)(businessHour ? MARY : JOHN), (Object)potOwner);
        this.ksession.abortProcessInstance(pid);
    }

    @Test
    public void testTimeout() throws InterruptedException {
        this.testTimeout(true);
    }

    @Test
    public void testTimeoutBusinessHour() throws InterruptedException {
        this.configureBusinessCalendar(true);
        this.testTimeout(true);
    }

    @Test
    public void testTimeoutNonBusinessHour() throws InterruptedException {
        this.configureBusinessCalendar(false);
        this.testTimeout(false);
    }

    private String getTaskPotentialOwner(long taskId) {
        Task task = this.taskService.getTaskById(taskId);
        HumanTaskReassignmentTest.assertNotNull((Object)task);
        List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        HumanTaskReassignmentTest.assertFalse((boolean)potentialOwners.isEmpty());
        return ((OrganizationalEntity)potentialOwners.get(0)).getId();
    }

    private void configureBusinessCalendar(boolean businessHour) {
        Properties configuration = new Properties();
        if (businessHour) {
            Calendar c = Calendar.getInstance();
            c.add(5, -1);
            int dayOfWeek = c.get(7);
            configuration.setProperty("business.start.hour", "0");
            configuration.setProperty("business.end.hour", "24");
            configuration.setProperty("business.hours.per.day", "24");
            configuration.setProperty("business.hours.per.week", "7");
            configuration.setProperty("business.weekend.days", Integer.toString(dayOfWeek));
        } else {
            Date today = new Date();
            Calendar c = Calendar.getInstance();
            c.add(5, 1);
            Date tomorrow = c.getTime();
            String dateFormat = "yyyy-MM-dd";
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            configuration.setProperty("business.holidays", sdf.format(today) + "," + sdf.format(tomorrow));
            configuration.setProperty("business.holiday.date.format", dateFormat);
        }
        BusinessCalendarImpl businessCalendar = new BusinessCalendarImpl(configuration);
        this.ksession.getEnvironment().set("jbpm.business.calendar", (Object)businessCalendar);
    }
}

