/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.event;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

@RunWith(value=Parameterized.class)
public class SignalEventTest
extends JbpmTestCase {
    private static final String END_THROW_DEFAULT = "org/jbpm/test/functional/event/Signal-endThrow-default.bpmn2";
    private static final String END_THROW_DEFAULT_ID = "org.jbpm.test.functional.event.Signal-endThrow-default";
    private static final String END_THROW_INSTANCE = "org/jbpm/test/functional/event/Signal-endThrow-instance.bpmn2";
    private static final String END_THROW_INSTANCE_ID = "org.jbpm.test.functional.event.Signal-endThrow-instance";
    private static final String END_THROW_PROJECT = "org/jbpm/test/functional/event/Signal-endThrow-project.bpmn2";
    private static final String END_THROW_PROJECT_ID = "org.jbpm.test.functional.event.Signal-endThrow-project";
    private static final String INTERMEDIATE_CATCH = "org/jbpm/test/functional/event/Signal-intermediateCatch.bpmn2";
    private static final String INTERMEDIATE_CATCH_ID = "org.jbpm.test.functional.event.Signal-intermediateCatch";
    private static final String INTERMEDIATE_THROW_DEFAULT = "org/jbpm/test/functional/event/Signal-intermediateThrow-default.bpmn2";
    private static final String INTERMEDIATE_THROW_DEFAULT_ID = "org.jbpm.test.functional.event.Signal-intermediateThrow-default";
    private static final String INTERMEDIATE_THROW_INSTANCE = "org/jbpm/test/functional/event/Signal-intermediateThrow-instance.bpmn2";
    private static final String INTERMEDIATE_THROW_INSTANCE_ID = "org.jbpm.test.functional.event.Signal-intermediateThrow-instance";
    private static final String INTERMEDIATE_THROW_PROJECT = "org/jbpm/test/functional/event/Signal-intermediateThrow-project.bpmn2";
    private static final String INTERMEDIATE_THROW_PROJECT_ID = "org.jbpm.test.functional.event.Signal-intermediateThrow-project";
    private static final String START_CATCH = "org/jbpm/test/functional/event/Signal-startCatch.bpmn2";
    private static final String START_CATCH_ID = "org.jbpm.test.functional.event.Signal-startCatch";
    private static final String SUBPROCESS_CATCH = "org/jbpm/test/functional/event/Signal-subprocessCatch.bpmn2";
    private static final String SUBPROCESS_CATCH_ID = "org.jbpm.test.functional.event.Signal-subprocessCatch";
    private final JbpmJUnitBaseTestCase.Strategy strategy;
    private final Scope scope;

    public SignalEventTest(JbpmJUnitBaseTestCase.Strategy strategy, Scope scope) {
        this.strategy = strategy;
        this.scope = scope;
    }

    @Parameterized.Parameters(name="{0} strategy, {1} scope")
    public static Collection<Object[]> parameters() {
        Object[][] combinations = new Object[][]{{JbpmJUnitBaseTestCase.Strategy.SINGLETON, Scope.DEFAULT}, {JbpmJUnitBaseTestCase.Strategy.SINGLETON, Scope.PROJECT}, {JbpmJUnitBaseTestCase.Strategy.SINGLETON, Scope.PROCESS_INSTANCE}, {JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE, Scope.DEFAULT}, {JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE, Scope.PROJECT}, {JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE, Scope.PROCESS_INSTANCE}};
        return Arrays.asList(combinations);
    }

    private KieSession getKieSession() {
        ProcessInstanceIdContext context = this.strategy == JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE ? ProcessInstanceIdContext.get() : EmptyContext.get();
        return this.getRuntimeEngine((Context)context).getKieSession();
    }

    @Test
    public void testSignalManually() {
        this.createRuntimeManager(this.strategy, null, new String[]{INTERMEDIATE_CATCH});
        KieSession ksession = this.getKieSession();
        ProcessInstance pi1 = ksession.startProcess(INTERMEDIATE_CATCH_ID);
        this.getKieSession().startProcess(INTERMEDIATE_CATCH_ID);
        switch (this.scope) {
            case DEFAULT: {
                ksession.signalEvent("commonSignal", null);
                break;
            }
            case PROCESS_INSTANCE: {
                ksession.signalEvent("commonSignal", null, pi1.getId());
                break;
            }
            case PROJECT: {
                this.manager.signalEvent("commonSignal", null);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown scope");
            }
        }
        List instances = this.getRuntimeEngine().getAuditService().findProcessInstances();
        Assertions.assertThat((List)instances).hasSize(2);
        Assertions.assertThat((String)((ProcessInstanceLog)instances.get(0)).getProcessId()).isEqualTo((Object)INTERMEDIATE_CATCH_ID);
        Assertions.assertThat((Integer)((ProcessInstanceLog)instances.get(0)).getStatus()).isEqualTo(2);
        Assertions.assertThat((String)((ProcessInstanceLog)instances.get(1)).getProcessId()).isEqualTo((Object)INTERMEDIATE_CATCH_ID);
        if (this.strategy == JbpmJUnitBaseTestCase.Strategy.SINGLETON) {
            Assertions.assertThat((Integer)((ProcessInstanceLog)instances.get(1)).getStatus()).isEqualTo(this.scope == Scope.PROCESS_INSTANCE ? 1 : 2);
        } else if (this.strategy == JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE) {
            Assertions.assertThat((Integer)((ProcessInstanceLog)instances.get(1)).getStatus()).isEqualTo(this.scope == Scope.PROJECT ? 2 : 1);
        }
    }

    @Test
    public void testSignalEndThrowIntermediateCatch() {
        String throwingProcessId;
        String throwingProcessFile;
        switch (this.scope) {
            case DEFAULT: {
                throwingProcessFile = END_THROW_DEFAULT;
                throwingProcessId = END_THROW_DEFAULT_ID;
                break;
            }
            case PROJECT: {
                throwingProcessFile = END_THROW_PROJECT;
                throwingProcessId = END_THROW_PROJECT_ID;
                break;
            }
            case PROCESS_INSTANCE: {
                throwingProcessFile = END_THROW_INSTANCE;
                throwingProcessId = END_THROW_INSTANCE_ID;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown scope");
            }
        }
        this.createRuntimeManager(this.strategy, null, new String[]{throwingProcessFile, INTERMEDIATE_CATCH});
        this.getKieSession().startProcess(INTERMEDIATE_CATCH_ID);
        this.getKieSession().startProcess(throwingProcessId);
        List instances = this.getRuntimeEngine().getAuditService().findProcessInstances();
        Assertions.assertThat((List)instances).hasSize(2);
        Assertions.assertThat((String)((ProcessInstanceLog)instances.get(0)).getProcessId()).isEqualTo((Object)INTERMEDIATE_CATCH_ID);
        Assertions.assertThat((String)((ProcessInstanceLog)instances.get(1)).getProcessId()).isEqualTo((Object)throwingProcessId);
        if (this.strategy == JbpmJUnitBaseTestCase.Strategy.SINGLETON) {
            Assertions.assertThat((Integer)((ProcessInstanceLog)instances.get(0)).getStatus()).isEqualTo(this.scope == Scope.PROCESS_INSTANCE ? 1 : 2);
            Assertions.assertThat((Integer)((ProcessInstanceLog)instances.get(1)).getStatus()).isEqualTo(2);
        } else if (this.strategy == JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE) {
            Assertions.assertThat((Integer)((ProcessInstanceLog)instances.get(0)).getStatus()).isEqualTo(this.scope == Scope.PROJECT ? 2 : 1);
            Assertions.assertThat((Integer)((ProcessInstanceLog)instances.get(1)).getStatus()).isEqualTo(2);
        }
    }

    @Test
    public void testSignalIntermediateThrowStartCatch() {
        String throwingProcessId;
        String throwingProcessFile;
        switch (this.scope) {
            case DEFAULT: {
                throwingProcessFile = INTERMEDIATE_THROW_DEFAULT;
                throwingProcessId = INTERMEDIATE_THROW_DEFAULT_ID;
                break;
            }
            case PROJECT: {
                throwingProcessFile = INTERMEDIATE_THROW_PROJECT;
                throwingProcessId = INTERMEDIATE_THROW_PROJECT_ID;
                break;
            }
            case PROCESS_INSTANCE: {
                throwingProcessFile = INTERMEDIATE_THROW_INSTANCE;
                throwingProcessId = INTERMEDIATE_THROW_INSTANCE_ID;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown scope");
            }
        }
        this.createRuntimeManager(this.strategy, null, new String[]{throwingProcessFile, START_CATCH});
        this.getKieSession().startProcess(throwingProcessId);
        boolean run = this.strategy == JbpmJUnitBaseTestCase.Strategy.SINGLETON && this.scope != Scope.PROCESS_INSTANCE || this.strategy == JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE && this.scope == Scope.PROJECT || this.strategy == JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE && this.scope == Scope.DEFAULT;
        List instances = this.getRuntimeEngine().getAuditService().findProcessInstances();
        Assertions.assertThat((List)instances).hasSize(run ? 2 : 1);
        Assertions.assertThat((String)((ProcessInstanceLog)instances.get(0)).getProcessId()).isEqualTo((Object)throwingProcessId);
        Assertions.assertThat((Integer)((ProcessInstanceLog)instances.get(0)).getStatus()).isEqualTo(2);
        if (run) {
            Assertions.assertThat((String)((ProcessInstanceLog)instances.get(1)).getProcessId()).isEqualTo((Object)START_CATCH_ID);
            Assertions.assertThat((Integer)((ProcessInstanceLog)instances.get(1)).getStatus()).isEqualTo(2);
        }
    }

    @Test
    public void testSignalSubProcess() {
        String throwingProcessId;
        String throwingProcessFile;
        switch (this.scope) {
            case DEFAULT: {
                throwingProcessFile = INTERMEDIATE_THROW_DEFAULT;
                throwingProcessId = INTERMEDIATE_THROW_DEFAULT_ID;
                break;
            }
            case PROJECT: {
                throwingProcessFile = INTERMEDIATE_THROW_PROJECT;
                throwingProcessId = INTERMEDIATE_THROW_PROJECT_ID;
                break;
            }
            case PROCESS_INSTANCE: {
                throwingProcessFile = INTERMEDIATE_THROW_INSTANCE;
                throwingProcessId = INTERMEDIATE_THROW_INSTANCE_ID;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown scope");
            }
        }
        this.createRuntimeManager(this.strategy, null, new String[]{SUBPROCESS_CATCH, throwingProcessFile, INTERMEDIATE_CATCH});
        this.getKieSession().startProcess(INTERMEDIATE_CATCH_ID);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("subprocess", throwingProcessId);
        this.getKieSession().startProcess(SUBPROCESS_CATCH_ID, parameters);
        List instances = this.getRuntimeEngine().getAuditService().findProcessInstances();
        Assertions.assertThat((List)instances).hasSize(3);
        Assertions.assertThat((String)((ProcessInstanceLog)instances.get(0)).getProcessId()).isEqualTo((Object)INTERMEDIATE_CATCH_ID);
        Assertions.assertThat((String)((ProcessInstanceLog)instances.get(1)).getProcessId()).isEqualTo((Object)SUBPROCESS_CATCH_ID);
        Assertions.assertThat((String)((ProcessInstanceLog)instances.get(2)).getProcessId()).isEqualTo((Object)throwingProcessId);
        if (this.strategy == JbpmJUnitBaseTestCase.Strategy.SINGLETON) {
            Assertions.assertThat((Integer)((ProcessInstanceLog)instances.get(0)).getStatus()).isEqualTo(this.scope == Scope.PROCESS_INSTANCE ? 1 : 2);
            Assertions.assertThat((Integer)((ProcessInstanceLog)instances.get(1)).getStatus()).isEqualTo(this.scope == Scope.PROCESS_INSTANCE ? 1 : 2);
        } else if (this.strategy == JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE) {
            Assertions.assertThat((Integer)((ProcessInstanceLog)instances.get(0)).getStatus()).isEqualTo(this.scope == Scope.PROJECT ? 2 : 1);
            Assertions.assertThat((Integer)((ProcessInstanceLog)instances.get(1)).getStatus()).isEqualTo(this.scope == Scope.PROJECT ? 2 : 1);
        }
        Assertions.assertThat((Integer)((ProcessInstanceLog)instances.get(2)).getStatus()).isEqualTo(2);
    }

    private static enum Scope {
        DEFAULT,
        PROCESS_INSTANCE,
        PROJECT;

    }
}

