/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.casemgmt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.jbpm.casemgmt.CaseMgmtService;
import org.jbpm.casemgmt.CaseMgmtUtil;
import org.jbpm.process.instance.command.UpdateTimerCommand;
import org.jbpm.services.task.commands.SetTaskPropertyCommand;
import org.jbpm.test.casemgmt.SetNodeNameCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.InternalI18NText;

public class WorkCaseService {
    private RuntimeEngine runtimeEngine;
    private KieSession kieSession;
    private CaseMgmtService caseMgmtService;
    private TaskService taskService;
    private static String lastConsultTaskName = "Consult work with";

    public WorkCaseService(RuntimeEngine runtimeEngine) {
        this.runtimeEngine = runtimeEngine;
        this.kieSession = runtimeEngine.getKieSession();
        this.caseMgmtService = new CaseMgmtUtil(runtimeEngine);
        this.taskService = runtimeEngine.getTaskService();
    }

    public long createWork(String name, String goal, String responsiblePerson) {
        return this.createWork(name, goal, responsiblePerson, 10);
    }

    public long createWork(String name, String goal, String responsiblePerson, int timeout) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", name);
        params.put("timeout", timeout);
        ProcessInstance pi = this.kieSession.startProcess("WorkCase", params);
        long caseId = pi.getId();
        this.caseMgmtService.setCaseData(caseId, "goal", (Object)goal);
        this.caseMgmtService.setCaseData(caseId, "responsible", (Object)responsiblePerson);
        this.caseMgmtService.addUserToRole(caseId, "responsible", responsiblePerson);
        return caseId;
    }

    public void addApprover(long caseId, String userId) {
        this.caseMgmtService.addUserToRole(caseId, "accountable", userId);
    }

    public void addConsultant(long caseId, String userId) {
        this.caseMgmtService.addUserToRole(caseId, "consulted", userId);
    }

    public void addInformedPerson(long caseId, String userId) {
        this.caseMgmtService.addUserToRole(caseId, "informed", userId);
    }

    public void informAbout(long caseId, String message) {
        this.caseMgmtService.setCaseData(caseId, "informAbout", (Object)message);
        this.caseMgmtService.triggerAdHocFragment(caseId, "Inform interested people");
    }

    public void consultWith(long caseId, String userId) {
        List<Object> consultants = Arrays.asList((Object[])this.caseMgmtService.getCaseRoleInstanceNames(caseId).get("consulted"));
        if (!consultants.contains(userId)) {
            this.addConsultant(caseId, userId);
        }
        this.caseMgmtService.setCaseData(caseId, "consultant", (Object)userId);
        this.caseMgmtService.triggerAdHocFragment(caseId, lastConsultTaskName);
        List taskIds = this.taskService.getTasksByProcessInstanceId(caseId);
        for (Long taskId : taskIds) {
            Task t = this.taskService.getTaskById(taskId.longValue());
            if (!t.getName().startsWith("Consult work with")) continue;
            lastConsultTaskName = "Consult work with " + userId;
            this.updateTaskName(caseId, t, lastConsultTaskName);
        }
    }

    public void checkResolution(long caseId) {
        this.caseMgmtService.triggerAdHocFragment(caseId, "Check resolution");
    }

    public void milestone(long caseId, WorkCaseMilestones milestone) {
        this.caseMgmtService.triggerAdHocFragment(caseId, milestone.getTaskName());
    }

    public void prolongTimeoutTo(long caseId, int timeout) {
        this.kieSession.execute((Command)new UpdateTimerCommand(caseId, "Timeout", (long)timeout));
        this.caseMgmtService.setCaseData(caseId, "timeout", (Object)15);
    }

    public String getRandomUserInTheRole(long pid, String role) {
        String[] users = (String[])this.caseMgmtService.getCaseRoleInstanceNames(pid).get(role);
        Random rand = new Random();
        int n = 0;
        if (users.length > 1) {
            n = rand.nextInt(users.length);
        }
        return users[n];
    }

    private void updateTaskName(long caseId, Task t, String name) {
        this.kieSession.execute((Command)new SetNodeNameCommand(caseId, t.getName(), name));
        ArrayList<I18NText> updatedNames = new ArrayList<I18NText>();
        I18NText updatedName = TaskModelProvider.getFactory().newI18NText();
        ((InternalI18NText)updatedName).setLanguage(((I18NText)t.getNames().get(0)).getLanguage());
        ((InternalI18NText)updatedName).setText(name);
        updatedNames.add(updatedName);
        this.taskService.execute((Command)new SetTaskPropertyCommand(t.getId().longValue(), null, Integer.valueOf(4), updatedNames));
    }

    public static enum WorkCaseMilestones {
        PLANNING_DONE("Milestone: Planning Done"),
        WORK_DONE("Milestone: Work Done"),
        CLOSE("Milestone: Close");

        private String taskName;

        private WorkCaseMilestones(String taskName) {
            this.taskName = taskName;
        }

        public String getTaskName() {
            return this.taskName;
        }
    }
}

