/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.timer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.persistence.Persistence;
import javax.sql.DataSource;
import org.drools.core.time.TimerService;
import org.jbpm.process.core.timer.TimerServiceRegistry;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.process.core.timer.impl.QuartzSchedulerService;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.functional.timer.GlobalTimerServiceBaseTest;
import org.jbpm.test.functional.timer.TimerBaseTest;
import org.jbpm.test.listener.CountDownProcessEventListener;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

@RunWith(value=Parameterized.class)
public class GlobalQuartzDBTimerServiceTest
extends GlobalTimerServiceBaseTest {
    private int managerType;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{1}, {2}, {3}};
        return Arrays.asList(data);
    }

    public GlobalQuartzDBTimerServiceTest(int managerType) {
        this.managerType = managerType;
    }

    @Before
    public void setUp() {
        GlobalQuartzDBTimerServiceTest.cleanupSingletonSessionId();
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.test.persistence");
        System.setProperty("org.quartz.properties", "quartz-db.properties");
        this.testCreateQuartzSchema();
        this.globalScheduler = new QuartzSchedulerService();
        ((QuartzSchedulerService)this.globalScheduler).forceShutdown();
    }

    @After
    public void tearDown() {
        try {
            this.globalScheduler.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cleanup();
        System.clearProperty("org.quartz.properties");
    }

    @Override
    protected RuntimeManager getManager(RuntimeEnvironment environment, boolean waitOnStart) {
        RuntimeManager manager = null;
        if (this.managerType == 1) {
            manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        } else if (this.managerType == 2) {
            manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        } else if (this.managerType == 3) {
            manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        } else {
            throw new IllegalArgumentException("Invalid runtime maanger type");
        }
        if (waitOnStart) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return manager;
    }

    @Test(timeout=20000L)
    public void testTimerStartManagerClose() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("StartProcess", 3);
        QuartzSchedulerService additionalCopy = new QuartzSchedulerService();
        additionalCopy.initScheduler(null);
        final ArrayList timerExporations = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                timerExporations.add(event.getProcessInstance().getId());
            }
        };
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/TimerStart2.bpmn2"), ResourceType.BPMN2).schedulerService((Object)this.globalScheduler).registerableItemsFactory((RegisterableItemsFactory)(TimerBaseTest)this.new TimerBaseTest.TestRegisterableItemsFactory(new ProcessEventListener[]{listener, countDownListener})).get();
        this.manager = this.getManager(this.environment, false);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        GlobalQuartzDBTimerServiceTest.assertEquals((long)0L, (long)timerExporations.size());
        countDownListener.waitTillCompleted();
        this.manager.disposeRuntimeEngine(runtime);
        int atDispose = timerExporations.size();
        GlobalQuartzDBTimerServiceTest.assertTrue((atDispose > 0 ? 1 : 0) != 0);
        ((AbstractRuntimeManager)this.manager).close(true);
        countDownListener.reset(1);
        countDownListener.waitTillCompleted(3000L);
        GlobalQuartzDBTimerServiceTest.assertEquals((long)atDispose, (long)timerExporations.size());
        additionalCopy.shutdown();
    }

    @Test
    @Ignore
    public void testAbortGlobalTestService() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/IntermediateCatchEventTimerCycle3.bpmn2"), ResourceType.BPMN2).addConfiguration("drools.timerService", "org.jbpm.process.core.timer.impl.RegisteredTimerServiceDelegate").get();
        RuntimeManager manger = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        GlobalTimerService globalTs = new GlobalTimerService(manger, this.globalScheduler);
        TimerServiceRegistry.getInstance().registerTimerService("default", (TimerService)globalTs);
        final ArrayList timerExporations = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("timer")) {
                    timerExporations.add(event.getProcessInstance().getId());
                }
            }
        };
        long id = -1L;
        Thread.sleep(5000L);
        RuntimeEngine runtime = manger.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        ksession.addEventListener((ProcessEventListener)listener);
        ksession.abortProcessInstance(id);
        ProcessInstance processInstance = ksession.getProcessInstance(id);
        GlobalQuartzDBTimerServiceTest.assertNull((Object)processInstance);
        Thread.sleep(3000L);
        ksession.dispose();
    }

    @Test
    @Ignore
    public void testContinueGlobalTestService() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/IntermediateCatchEventTimerCycle2.bpmn2"), ResourceType.BPMN2).addConfiguration("drools.timerService", "org.jbpm.process.core.timer.impl.RegisteredTimerServiceDelegate").get();
        RuntimeManager manger = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        GlobalTimerService globalTs = new GlobalTimerService(manger, this.globalScheduler);
        TimerServiceRegistry.getInstance().registerTimerService("default", (TimerService)globalTs);
        final ArrayList timerExporations = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("timer")) {
                    timerExporations.add(event.getProcessInstance().getId());
                }
            }
        };
        Thread.sleep(5000L);
    }

    @Test(timeout=20000L)
    public void testContinueTimer() throws Exception {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("timer", 2);
        final ArrayList timerExporations = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("timer")) {
                    timerExporations.add(event.getProcessInstance().getId());
                }
            }
        };
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/IntermediateCatchEventTimerCycle4.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)(TimerBaseTest)this.new TimerBaseTest.TestRegisterableItemsFactory(new ProcessEventListener[]{listener, countDownListener})).get();
        this.manager = this.getManager(this.environment, true);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        this.manager.disposeRuntimeEngine(runtime);
        countDownListener.waitTillCompleted();
        this.manager.close();
        countDownListener.reset(1);
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/IntermediateCatchEventTimerCycle4.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)(TimerBaseTest)this.new TimerBaseTest.TestRegisterableItemsFactory(new ProcessEventListener[]{listener})).get();
        this.manager = this.getManager(this.environment, true);
        this.manager.disposeRuntimeEngine(runtime);
        countDownListener.waitTillCompleted(3000L);
        GlobalQuartzDBTimerServiceTest.assertEquals((long)2L, (long)timerExporations.size());
    }

    @Test(timeout=20000L)
    public void testTimerRequiresRecoveryFlagSet() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        JBossUserGroupCallbackImpl userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/HumanTaskWithBoundaryTimer.bpmn"), ResourceType.BPMN2).schedulerService((Object)this.globalScheduler).userGroupCallback((UserGroupCallback)userGroupCallback).get();
        this.manager = this.getManager(this.environment, true);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test", "john");
        ProcessInstance processInstance = ksession.startProcess("PROCESS_1", params);
        try {
            Connection connection = ((DataSource)InitialContext.doLookup("jdbc/jbpm-ds")).getConnection();
            Statement stmt = connection.createStatement();
            ResultSet resultSet = stmt.executeQuery("select REQUESTS_RECOVERY from QRTZ_JOB_DETAILS");
            while (resultSet.next()) {
                boolean requestsRecovery = resultSet.getBoolean(1);
                GlobalQuartzDBTimerServiceTest.assertEquals((String)"Requests recovery must be set to true", (Object)true, (Object)requestsRecovery);
            }
            stmt.close();
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ksession.abortProcessInstance(processInstance.getId());
        this.manager.disposeRuntimeEngine(runtime);
    }

    @Test(timeout=25000L)
    public void testContinueTimerWithMisfire() throws Exception {
        System.setProperty("org.quartz.properties", "quartz-db-short-misfire.properties");
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("StartProcess", 2);
        final ArrayList timerExporations = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                timerExporations.add(event.getProcessInstance().getId());
            }
        };
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/TimerStart2.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)(TimerBaseTest)this.new TimerBaseTest.TestRegisterableItemsFactory(new ProcessEventListener[]{listener, countDownListener})).get();
        this.manager = this.getManager(this.environment, true);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        countDownListener.waitTillCompleted();
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
        System.out.println("==== manager.close() ====");
        countDownListener.reset(3);
        Thread.sleep(5000L);
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/TimerStart2.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)(TimerBaseTest)this.new TimerBaseTest.TestRegisterableItemsFactory(new ProcessEventListener[]{listener, countDownListener})).get();
        this.manager = this.getManager(this.environment, true);
        countDownListener.waitTillCompleted(4000L);
        GlobalQuartzDBTimerServiceTest.assertEquals((long)5L, (long)timerExporations.size());
    }
}

