/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.HashMap;
import java.util.List;
import org.jbpm.services.task.events.DefaultTaskEventListener;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskEvent;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumanTaskVariablesAccessTest
extends JbpmTestCase {
    private static final Logger logger = LoggerFactory.getLogger(HumanTaskVariablesAccessTest.class);

    public HumanTaskVariablesAccessTest() {
        super(true, false);
    }

    @Test
    public void testBeforeEvents() {
        this.testHumanTaskWithListener((TaskLifeCycleEventListener)new DefaultTaskEventListener(){

            public void beforeTaskStartedEvent(TaskEvent event) {
                HumanTaskVariablesAccessTest.this.assertTaskStartedEvent(event);
            }

            public void beforeTaskCompletedEvent(TaskEvent event) {
                HumanTaskVariablesAccessTest.this.assertTaskCompletedEvent(event);
            }

            public void beforeTaskAddedEvent(TaskEvent event) {
                HumanTaskVariablesAccessTest.this.assertTaskAddedEvent(event);
            }
        });
    }

    @Test
    public void testAfterEvents() {
        this.testHumanTaskWithListener((TaskLifeCycleEventListener)new DefaultTaskEventListener(){

            public void afterTaskStartedEvent(TaskEvent event) {
                HumanTaskVariablesAccessTest.this.assertTaskStartedEvent(event);
            }

            public void afterTaskCompletedEvent(TaskEvent event) {
                HumanTaskVariablesAccessTest.this.assertTaskCompletedEvent(event);
            }

            public void afterTaskAddedEvent(TaskEvent event) {
                HumanTaskVariablesAccessTest.this.assertTaskAddedEvent(event);
            }
        });
    }

    private void testHumanTaskWithListener(TaskLifeCycleEventListener listener) {
        this.addTaskEventListener(listener);
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/HumanTaskWithVariables.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processHTInput", "Simple human task input");
        ProcessInstance processInstance = ksession.startProcess("humanTaskWithVariables", params);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task"});
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        params.clear();
        params.put("humanTaskOutput", "Simple human task output");
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", params);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    private void assertTaskStartedEvent(TaskEvent event) {
        HumanTaskVariablesAccessTest.assertNull((Object)event.getTask().getTaskData().getTaskInputVariables());
        HumanTaskVariablesAccessTest.assertNull((Object)event.getTask().getTaskData().getTaskOutputVariables());
        event.getTaskContext().loadTaskVariables(event.getTask());
        HumanTaskVariablesAccessTest.assertNotNull((Object)event.getTask().getTaskData().getTaskInputVariables());
        HumanTaskVariablesAccessTest.assertEquals((long)5L, (long)event.getTask().getTaskData().getTaskInputVariables().size());
        HumanTaskVariablesAccessTest.assertEquals((Object)"Simple human task input", event.getTask().getTaskData().getTaskInputVariables().get("humanTaskInput"));
        HumanTaskVariablesAccessTest.assertNull((Object)event.getTask().getTaskData().getTaskOutputVariables());
    }

    private void assertTaskCompletedEvent(TaskEvent event) {
        HumanTaskVariablesAccessTest.assertNull((Object)event.getTask().getTaskData().getTaskInputVariables());
        HumanTaskVariablesAccessTest.assertNotNull((Object)event.getTask().getTaskData().getTaskOutputVariables());
        HumanTaskVariablesAccessTest.assertEquals((long)1L, (long)event.getTask().getTaskData().getTaskOutputVariables().size());
        HumanTaskVariablesAccessTest.assertEquals((Object)"Simple human task output", event.getTask().getTaskData().getTaskOutputVariables().get("humanTaskOutput"));
        event.getTaskContext().loadTaskVariables(event.getTask());
        HumanTaskVariablesAccessTest.assertNotNull((Object)event.getTask().getTaskData().getTaskInputVariables());
        HumanTaskVariablesAccessTest.assertEquals((long)5L, (long)event.getTask().getTaskData().getTaskInputVariables().size());
        HumanTaskVariablesAccessTest.assertEquals((Object)"Simple human task input", event.getTask().getTaskData().getTaskInputVariables().get("humanTaskInput"));
        HumanTaskVariablesAccessTest.assertNotNull((Object)event.getTask().getTaskData().getTaskOutputVariables());
        HumanTaskVariablesAccessTest.assertEquals((long)1L, (long)event.getTask().getTaskData().getTaskOutputVariables().size());
        HumanTaskVariablesAccessTest.assertEquals((Object)"Simple human task output", event.getTask().getTaskData().getTaskOutputVariables().get("humanTaskOutput"));
    }

    private void assertTaskAddedEvent(TaskEvent event) {
        HumanTaskVariablesAccessTest.assertNotNull((Object)event.getTask().getTaskData().getTaskInputVariables());
        HumanTaskVariablesAccessTest.assertEquals((long)5L, (long)event.getTask().getTaskData().getTaskInputVariables().size());
        HumanTaskVariablesAccessTest.assertEquals((Object)"Simple human task input", event.getTask().getTaskData().getTaskInputVariables().get("humanTaskInput"));
        HumanTaskVariablesAccessTest.assertNull((Object)event.getTask().getTaskData().getTaskOutputVariables());
        event.getTaskContext().loadTaskVariables(event.getTask());
        HumanTaskVariablesAccessTest.assertNotNull((Object)event.getTask().getTaskData().getTaskInputVariables());
        HumanTaskVariablesAccessTest.assertEquals((long)5L, (long)event.getTask().getTaskData().getTaskInputVariables().size());
        HumanTaskVariablesAccessTest.assertEquals((Object)"Simple human task input", event.getTask().getTaskData().getTaskInputVariables().get("humanTaskInput"));
        HumanTaskVariablesAccessTest.assertNull((Object)event.getTask().getTaskData().getTaskOutputVariables());
    }
}

