/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.timer;

import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import org.jbpm.test.JBPMHelper;
import org.jbpm.test.JbpmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerPersistenceTest
extends JbpmTestCase {
    private static final Logger logger = LoggerFactory.getLogger(TimerPersistenceTest.class);
    private static final String DELAY_TIMER_FILE = "org/jbpm/test/functional/timer/delayTimerEventProcess.bpmn";
    private static final String DELAY_TIMER_PROCESS = "DelayTimerEventProcess";
    private static final String PROCESS_FILE_NAME = "org/jbpm/test/functional/timer/boundaryTimerProcess.bpmn";
    private static final String PROCESS_NAME = "BoundaryTimerEventProcess";
    private static final String WORK_ITEM_HANLDER_TASK = "Human Task";
    private static final String TIMER_FIRED_PROP = "timerFired";
    private static final String TIMER_FIRED_TIME_PROP = "afterTimerTime";

    public TimerPersistenceTest() {
        super(true, true);
    }

    @Before
    public void setup() {
        System.clearProperty(TIMER_FIRED_PROP);
        System.clearProperty(TIMER_FIRED_TIME_PROP);
    }

    @Test
    public void boundaryEventTimerAndCompleteHumanTask() throws InterruptedException {
        this.createRuntimeManager(new String[]{PROCESS_FILE_NAME});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        long ksessionId = ksession.getIdentifier();
        TimerPersistenceTest.assertTrue((String)"session id not saved.", (ksessionId > 0L ? 1 : 0) != 0);
        HumanTaskMockHandler humanTaskMockHandler = new HumanTaskMockHandler();
        ProcessInstance process = this.registerHTHandlerAndStartProcess(ksession, humanTaskMockHandler);
        this.sleepAndVerifyTimerRuns(process.getState());
        this.completeWork(ksession, humanTaskMockHandler);
        process = ksession.getProcessInstance(process.getId());
        TimerPersistenceTest.assertNull((String)"Expected process to have been completed and removed", (Object)process);
    }

    @Test
    @Ignore
    public void timerEventOutsideOfKnowledgeSessionTest() throws Exception {
        this.createRuntimeManager(new String[]{PROCESS_FILE_NAME});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        long ksessionId = ksession.getIdentifier();
        ProcessInstance process = ksession.startProcess(DELAY_TIMER_PROCESS);
        long processId = process.getId();
        Assert.assertEquals((long)1L, (long)process.getState());
        EntityManagerFactory emf = (EntityManagerFactory)ksession.getEnvironment().get("org.kie.api.persistence.jpa.EntityManagerFactory");
        ksession.dispose();
        ksession = null;
        emf.close();
        emf = null;
        TimerPersistenceTest.assertTrue((String)"sesssion id has not been saved", (ksessionId > 0L ? 1 : 0) != 0);
        TimerPersistenceTest.assertTrue((String)"process id has not been saved", (processId > 0L ? 1 : 0) != 0);
        process = null;
        int sleep = 2000;
        logger.debug("Sleeping {} seconds", (Object)(sleep / 1000));
        Thread.sleep(sleep);
        logger.debug("Awake!");
        TimerPersistenceTest.assertTrue((String)"The timer has not fired!", (boolean)this.timerHasFired());
        TimerPersistenceTest.assertTrue((String)"The did not fire at the right time!", (System.currentTimeMillis() > this.timerFiredTime() ? 1 : 0) != 0);
        this.disposeRuntimeManager();
        this.createRuntimeManager(new String[]{PROCESS_FILE_NAME});
        runtimeEngine = this.getRuntimeEngine();
        ksession = runtimeEngine.getKieSession();
        TimerPersistenceTest.assertNotNull((String)("Could not retrieve session " + ksessionId), (Object)ksession);
        process = ksession.getProcessInstance(processId);
        TimerPersistenceTest.assertNotNull((String)("Process " + processId + "should have completed and been deleted"), (Object)process);
    }

    @Test
    @Ignore
    public void boundaryEventTimerFiresAndCompleteHumanTaskWithoutKSession() throws Exception {
        this.createRuntimeManager(new String[]{PROCESS_FILE_NAME});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        long ksessionId = ksession.getIdentifier();
        TimerPersistenceTest.assertTrue((String)"session id not saved.", (ksessionId > 0L ? 1 : 0) != 0);
        HumanTaskMockHandler humanTaskMockHandler = new HumanTaskMockHandler();
        ProcessInstance process = this.registerHTHandlerAndStartProcess(ksession, humanTaskMockHandler);
        int processState = process.getState();
        EntityManagerFactory emf = (EntityManagerFactory)ksession.getEnvironment().get("org.kie.api.persistence.jpa.EntityManagerFactory");
        ksession.dispose();
        ksession = null;
        emf.close();
        emf = null;
        this.sleepAndVerifyTimerRuns(processState);
        this.disposeRuntimeManager();
        this.createRuntimeManager(new String[]{PROCESS_FILE_NAME});
        runtimeEngine = this.getRuntimeEngine();
        ksession = runtimeEngine.getKieSession();
        this.completeWork(ksession, humanTaskMockHandler);
        process = ksession.getProcessInstance(process.getId());
        TimerPersistenceTest.assertNull((String)"Expected process to have been completed and removed", (Object)process);
    }

    private ProcessInstance registerHTHandlerAndStartProcess(KieSession ksession, HumanTaskMockHandler humanTaskMockHandler) {
        ksession.getWorkItemManager().registerWorkItemHandler(WORK_ITEM_HANLDER_TASK, (WorkItemHandler)humanTaskMockHandler);
        ProcessInstance process = ksession.startProcess(PROCESS_NAME);
        long processId = process.getId();
        TimerPersistenceTest.assertTrue((String)"process id not saved", (processId > 0L ? 1 : 0) != 0);
        int processState = process.getState();
        TimerPersistenceTest.assertEquals((String)("Expected process state to be " + JBPMHelper.processStateName[1] + " not " + JBPMHelper.processStateName[processState]), (long)1L, (long)processState);
        return process;
    }

    private void completeWork(KieSession ksession, HumanTaskMockHandler humanTaskMockHandler) {
        TimerPersistenceTest.assertTrue((String)"The work item task handler does not have a work item!", (humanTaskMockHandler.workItem != null ? 1 : 0) != 0);
        long workItemId = humanTaskMockHandler.workItem.getId();
        TimerPersistenceTest.assertTrue((String)"work item id not saved", (workItemId > 0L ? 1 : 0) != 0);
        HashMap results = new HashMap();
        try {
            ksession.getWorkItemManager().completeWorkItem(workItemId, results);
        }
        catch (Exception e) {
            logger.warn("Work item could not be completed!");
            e.printStackTrace();
            TimerPersistenceTest.fail((String)(e.getClass().getSimpleName() + " thrown when completing work item: " + e.getMessage()));
        }
    }

    private void sleepAndVerifyTimerRuns(int processState) throws InterruptedException {
        if (processState == 1) {
            int sleep = 2000;
            logger.debug("Sleeping {} seconds", (Object)(sleep / 1000));
            Thread.sleep(sleep);
            logger.debug("Awake!");
        }
        long afterSleepTime = System.currentTimeMillis();
        TimerPersistenceTest.assertTrue((String)"The timer has not fired!", (boolean)this.timerHasFired());
        TimerPersistenceTest.assertTrue((String)"The timer did not fire on time!", (afterSleepTime > this.timerFiredTime() ? 1 : 0) != 0);
        int timerFiredCount = this.timerFiredCount();
        TimerPersistenceTest.assertTrue((String)("The timer only fired " + timerFiredCount + " times."), (timerFiredCount >= 1 ? 1 : 0) != 0);
    }

    private boolean timerHasFired() {
        String hasFired = System.getProperty(TIMER_FIRED_PROP);
        return hasFired != null;
    }

    private int timerFiredCount() {
        String timerFiredCount = System.getProperty(TIMER_FIRED_PROP);
        if (timerFiredCount == null) {
            return 0;
        }
        return Integer.parseInt(timerFiredCount);
    }

    private long timerFiredTime() {
        String timerFiredCount = System.getProperty(TIMER_FIRED_TIME_PROP);
        if (timerFiredCount == null) {
            return 0L;
        }
        return Long.parseLong(timerFiredCount);
    }

    private static class HumanTaskMockHandler
    implements org.drools.core.process.instance.WorkItemHandler {
        private WorkItemManager workItemManager;
        private WorkItem workItem;

        private HumanTaskMockHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItem = workItem;
            this.workItemManager = manager;
            logger.debug("Work completed!");
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItemManager.abortWorkItem(workItem.getId());
            logger.debug("Work aborted.");
        }
    }
}

