/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.gateway;

import java.util.HashMap;
import java.util.List;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;

public class InclusiveGatewayWithHumanTasksProcessTest
extends JbpmTestCase {
    public InclusiveGatewayWithHumanTasksProcessTest() {
        super(true, true);
    }

    @Test
    public void testInclusiveGatewayWithLoopAndUserTasks() {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/gateway/InclusiveGatewayWithHumanTasksProcess.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        String userId = "john";
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("firstXor", true);
        params.put("secondXor", true);
        params.put("thirdXor", true);
        ProcessInstance pi = ksession.startProcess("InclusiveWithAdvancedLoop", params);
        List tasks = taskService.getTasksAssignedAsPotentialOwner(userId, "en-UK");
        InclusiveGatewayWithHumanTasksProcessTest.assertNotNull((Object)tasks);
        InclusiveGatewayWithHumanTasksProcessTest.assertEquals((long)1L, (long)tasks.size());
        taskService.start(((TaskSummary)tasks.get(0)).getId().longValue(), userId);
        taskService.complete(((TaskSummary)tasks.get(0)).getId().longValue(), userId, new HashMap());
        tasks = taskService.getTasksAssignedAsPotentialOwner(userId, "en-UK");
        InclusiveGatewayWithHumanTasksProcessTest.assertNotNull((Object)tasks);
        InclusiveGatewayWithHumanTasksProcessTest.assertEquals((long)2L, (long)tasks.size());
        for (TaskSummary task : tasks) {
            if (!task.getName().equals("HT Form2")) continue;
            taskService.start(task.getId().longValue(), userId);
            taskService.complete(task.getId().longValue(), userId, new HashMap());
            break;
        }
        List johntasks = taskService.getTasksAssignedAsPotentialOwner(userId, "en-UK");
        InclusiveGatewayWithHumanTasksProcessTest.assertNotNull((Object)johntasks);
        InclusiveGatewayWithHumanTasksProcessTest.assertEquals((long)1L, (long)johntasks.size());
        taskService.start(((TaskSummary)johntasks.get(0)).getId().longValue(), userId);
        taskService.complete(((TaskSummary)johntasks.get(0)).getId().longValue(), userId, new HashMap());
        johntasks = taskService.getTasksAssignedAsPotentialOwner(userId, "en-UK");
        InclusiveGatewayWithHumanTasksProcessTest.assertNotNull((Object)johntasks);
        InclusiveGatewayWithHumanTasksProcessTest.assertEquals((long)1L, (long)johntasks.size());
        taskService.start(((TaskSummary)johntasks.get(0)).getId().longValue(), userId);
        taskService.complete(((TaskSummary)johntasks.get(0)).getId().longValue(), userId, new HashMap());
        this.assertProcessInstanceCompleted(pi.getId());
    }
}

