/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.event;

import java.util.HashMap;
import java.util.List;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;

public class BoundaryErrorMultiInstanceProcessTest
extends JbpmTestCase {
    public BoundaryErrorMultiInstanceProcessTest() {
        super(true, true);
    }

    @Test
    public void simpleSupportProcessTest() {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/event/BoundaryErrorMultiInstanceProcess.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("approvers", new String[]{"salaboy", "mary"});
        ProcessInstance processInstance = ksession.startProcess("boundary-catch-error-event", params);
        this.assertProcessInstanceActive(processInstance.getId());
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        BoundaryErrorMultiInstanceProcessTest.assertEquals((long)1L, (long)tasks.size());
        TaskSummary dataEntryTask = (TaskSummary)tasks.get(0);
        taskService.start(dataEntryTask.getId().longValue(), "john");
        taskService.complete(dataEntryTask.getId().longValue(), "john", null);
        tasks = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        BoundaryErrorMultiInstanceProcessTest.assertEquals((long)1L, (long)tasks.size());
        tasks = taskService.getTasksAssignedAsPotentialOwner("salaboy", "en-UK");
        BoundaryErrorMultiInstanceProcessTest.assertEquals((long)1L, (long)tasks.size());
        ksession.signalEvent("Terminate", null, processInstance.getId());
        tasks = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        BoundaryErrorMultiInstanceProcessTest.assertEquals((long)0L, (long)tasks.size());
        tasks = taskService.getTasksAssignedAsPotentialOwner("salaboy", "en-UK");
        BoundaryErrorMultiInstanceProcessTest.assertEquals((long)0L, (long)tasks.size());
        tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        BoundaryErrorMultiInstanceProcessTest.assertEquals((long)1L, (long)tasks.size());
        dataEntryTask = (TaskSummary)tasks.get(0);
        taskService.start(dataEntryTask.getId().longValue(), "john");
        taskService.complete(dataEntryTask.getId().longValue(), "john", null);
        tasks = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        BoundaryErrorMultiInstanceProcessTest.assertEquals((long)1L, (long)tasks.size());
        TaskSummary maryTask = (TaskSummary)tasks.get(0);
        taskService.start(maryTask.getId().longValue(), "mary");
        taskService.complete(maryTask.getId().longValue(), "mary", null);
        tasks = taskService.getTasksAssignedAsPotentialOwner("salaboy", "en-UK");
        BoundaryErrorMultiInstanceProcessTest.assertEquals((long)1L, (long)tasks.size());
        TaskSummary salaboyTask = (TaskSummary)tasks.get(0);
        taskService.start(salaboyTask.getId().longValue(), "salaboy");
        taskService.complete(salaboyTask.getId().longValue(), "salaboy", null);
        this.assertProcessInstanceCompleted(processInstance.getId());
    }
}

