/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.functional.task.ProcessRunner;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.task.TaskService;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.TaskModelProvider;

public class ConcurrentHumanTaskTest
extends JbpmTestCase {
    private static final int THREADS = 2;

    public ConcurrentHumanTaskTest() {
        super(true, true);
    }

    @Before
    public void populateOrgEntity() {
        TaskService taskService = HumanTaskServiceFactory.newTaskServiceConfigurator().entityManagerFactory(this.getEmf()).getTaskService();
        ((InternalTaskService)taskService).addUser(TaskModelProvider.getFactory().newUser("krisv"));
        ((InternalTaskService)taskService).addUser(TaskModelProvider.getFactory().newUser("sales-rep"));
        ((InternalTaskService)taskService).addUser(TaskModelProvider.getFactory().newUser("john"));
        ((InternalTaskService)taskService).addUser(TaskModelProvider.getFactory().newUser("Administrator"));
        ((InternalTaskService)taskService).addGroup(TaskModelProvider.getFactory().newGroup("sales"));
        ((InternalTaskService)taskService).addGroup(TaskModelProvider.getFactory().newGroup("PM"));
        ((InternalTaskService)taskService).addGroup(TaskModelProvider.getFactory().newGroup("Administrators"));
    }

    @Test(timeout=10000L)
    public void testConcurrentInvocationsIncludingUserTasks() throws Exception {
        CountDownLatch latch = new CountDownLatch(2);
        for (int i = 0; i < 2; ++i) {
            ProcessRunner pr = new ProcessRunner(i, this.getEmf(), latch);
            Thread t = new Thread((Runnable)pr, i + "-process-runner");
            t.start();
        }
        latch.await();
        JPAAuditLogService logService = new JPAAuditLogService(this.getEmf());
        List logs = logService.findProcessInstances("com.sample.humantask.concurrent");
        ConcurrentHumanTaskTest.assertEquals((long)2L, (long)logs.size());
        for (ProcessInstanceLog log : logs) {
            ConcurrentHumanTaskTest.assertEquals((long)2L, (long)log.getStatus().intValue());
        }
        logService.dispose();
    }
}

