/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.workitem;

import java.util.Collection;
import java.util.HashMap;
import org.drools.core.process.instance.WorkItemManager;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.functional.workitem.ExceptionWorkItemHandler;
import org.jbpm.test.functional.workitem.NoExceptionWorkItemHandler;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.runtime.manager.context.EmptyContext;

public class RetrySyncWorkItemByMemoryTest
extends JbpmTestCase {
    private static final String RETRY_WORKITEM_MEMORY_PROCESS_ID = "org.jbpm.test.retry-workitem-memory";

    public RetrySyncWorkItemByMemoryTest() {
        super(false, false);
    }

    @Test
    public void workItemRecoveryTestByMemory() {
        this.manager = this.createRuntimeManager(new String[]{"org/jbpm/test/functional/workitem/retry-workitem-memory.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine(EmptyContext.get());
        KieSession kieSession = runtimeEngine.getKieSession();
        WorkItemManager workItemManager = (WorkItemManager)kieSession.getWorkItemManager();
        workItemManager.registerWorkItemHandler("ExceptionWorkitem", (WorkItemHandler)new ExceptionWorkItemHandler());
        workItemManager.registerWorkItemHandler("NoExceptionWorkitem", (WorkItemHandler)new NoExceptionWorkItemHandler());
        ProcessInstance pi = kieSession.startProcess(RETRY_WORKITEM_MEMORY_PROCESS_ID);
        Assert.assertEquals((long)pi.getState(), (long)1L);
        WorkflowProcessInstance p = (WorkflowProcessInstance)kieSession.getProcessInstance(pi.getId());
        Collection nis = p.getNodeInstances();
        this.retryWorkItem(workItemManager, nis);
        Assert.assertEquals((long)p.getState(), (long)2L);
    }

    private void retryWorkItem(WorkItemManager workItemManager, Collection<NodeInstance> nis) {
        for (NodeInstance di : nis) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("exception", "no");
            workItemManager.retryWorkItem(Long.valueOf(di.getId()), map);
        }
    }
}

