/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.monitoring;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.management.JMX;
import javax.management.MBeanServer;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.ClockType;
import org.drools.core.management.DroolsManagementAgent;
import org.jbpm.process.instance.event.DefaultSignalManagerFactory;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.conf.MBeansOption;
import org.kie.api.management.GenericKieSessionMonitoringMXBean;
import org.kie.api.management.KieSessionMonitoringMXBean;
import org.kie.api.management.StatelessKieSessionMonitoringMXBean;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeansMonitoringWithJBpmTest {
    public static final Logger LOG = LoggerFactory.getLogger(MBeansMonitoringWithJBpmTest.class);
    public static final String KCONTAINER1 = "myContainerId";
    public static final String KSESSION1 = "KSession1";
    public static final String KBASE1 = "KBase1";
    private static final String KSESSION2 = "KSession2_stateless";
    private String mbeansprop;

    @Before
    public void setUp() throws Exception {
        this.mbeansprop = System.getProperty("kie.mbeans");
        System.setProperty("kie.mbeans", "enabled");
    }

    @After
    public void tearDown() throws Exception {
        if (this.mbeansprop != null) {
            System.setProperty("kie.mbeans", this.mbeansprop);
        } else {
            System.setProperty("kie.mbeans", MBeansOption.DISABLED.toString());
        }
    }

    @Test
    public void testRulesAndProcesses() throws Exception {
        String drl = "package org.drools.droolsjbpm_integration_testmgt\nrule S\nwhen\n    $s: String() \nthen\n    try { Thread.sleep(10); } catch (Exception e) { }\n    System.out.println($s); \nend\n";
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<definitions id=\"Definition\"\n             targetNamespace=\"http://www.example.org/MinimalExample\"\n             typeLanguage=\"http://www.java.com/javaTypes\"\n             expressionLanguage=\"http://www.mvel.org/2.0\"\n             xmlns=\"http://www.omg.org/spec/BPMN/20100524/MODEL\"\n             xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n             xs:schemaLocation=\"http://www.omg.org/spec/BPMN/20100524/MODEL BPMN20.xsd\"\n             xmlns:bpmndi=\"http://www.omg.org/spec/BPMN/20100524/DI\"\n             xmlns:dc=\"http://www.omg.org/spec/DD/20100524/DC\"\n             xmlns:di=\"http://www.omg.org/spec/DD/20100524/DI\"\n             xmlns:tns=\"http://www.jboss.org/drools\">\n\n  <process processType=\"Private\" isExecutable=\"true\" id=\"com.sample.HelloWorld\" name=\"Hello World\" >\n\n    <!-- nodes -->\n    <startEvent id=\"_a1\" name=\"StartProcess\" />\n    <scriptTask id=\"_a2\" name=\"Hello\" >\n      <script>System.out.println(\"Hello World\");</script>\n    </scriptTask>\n    <endEvent id=\"_a3\" name=\"EndProcess\" >\n        <terminateEventDefinition/>\n    </endEvent>\n\n    <!-- connections -->\n    <sequenceFlow id=\"_a1-_a2\" sourceRef=\"_a1\" targetRef=\"_a2\" />\n    <sequenceFlow id=\"_a2-_a3\" sourceRef=\"_a2\" targetRef=\"_a3\" />\n\n  </process>  <process processType=\"Private\" isExecutable=\"true\" id=\"com.sample.CiaoWorld\" name=\"Ciao World\" >\n\n    <!-- nodes -->\n    <startEvent id=\"_b1\" name=\"StartProcess\" />\n    <scriptTask id=\"_b2\" name=\"Ciao\" >\n      <script>System.out.println(\"Ciao World\");</script>\n    </scriptTask>\n    <endEvent id=\"_b3\" name=\"EndProcess\" >\n        <terminateEventDefinition/>\n    </endEvent>\n\n    <!-- connections -->\n    <sequenceFlow id=\"_b1-_b2\" sourceRef=\"_b1\" targetRef=\"_b2\" />\n    <sequenceFlow id=\"_b2-_b3\" sourceRef=\"_b2\" targetRef=\"_b3\" />\n\n  </process></definitions>";
        KieServices ks = KieServices.Factory.get();
        KieModuleModel kproj = ks.newKieModuleModel();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel(KBASE1).setDefault(true).setEventProcessingMode(EventProcessingOption.STREAM);
        KieSessionModel ksessionModel1 = kieBaseModel1.newKieSessionModel(KSESSION1).setDefault(true).setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        KieSessionModel ksessionModel2 = kieBaseModel1.newKieSessionModel(KSESSION2).setDefault(false).setType(KieSessionModel.KieSessionType.STATELESS);
        ReleaseId releaseId1 = ks.newReleaseId("org.kie.test", "mbeans", "1.0.0");
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        kfs.generateAndWritePomXML(releaseId1);
        kfs.write("src/main/resources/r1.drl", drl);
        kfs.write("src/main/resources/p1.bpmn2", process);
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            for (Message result : kb.getResults().getMessages()) {
                LOG.error(result.getText());
            }
        }
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule(releaseId1);
        KieContainer kc = ks.newKieContainer(KCONTAINER1, releaseId1);
        KieBase kiebase = kc.getKieBase(KBASE1);
        Properties ksessionConfigProps = new Properties();
        ksessionConfigProps.setProperty("drools.processSignalManagerFactory", DefaultSignalManagerFactory.class.getName());
        ksessionConfigProps.setProperty("drools.processInstanceManagerFactory", DefaultProcessInstanceManagerFactory.class.getName());
        KieSessionConfiguration sessionConf = ks.newKieSessionConfiguration(ksessionConfigProps);
        sessionConf.setOption((KieSessionOption)ForceEagerActivationOption.YES);
        KieSession ksession = kc.newKieSession(KSESSION1, sessionConf);
        MBeanServer mbserver = ManagementFactory.getPlatformMBeanServer();
        KieSessionMonitoringMXBean aggrMonitor = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)KCONTAINER1, (String)KBASE1, (KieSessionModel.KieSessionType)KieSessionModel.KieSessionType.STATEFUL, (String)KSESSION1), KieSessionMonitoringMXBean.class);
        long tft = 0L;
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor, 0L, 0L, 0L);
        this.checkTotalFactCount(aggrMonitor, 0);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor, tft);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor, 1);
        Assert.assertNull((Object)aggrMonitor.getStatsForProcess("com.sample.HelloWorld"));
        Assert.assertNull((Object)aggrMonitor.getStatsForProcess("com.sample.CiaoWorld"));
        Assert.assertFalse((boolean)aggrMonitor.getStatsByProcess().containsKey("com.sample.HelloWorld"));
        Assert.assertFalse((boolean)aggrMonitor.getStatsByProcess().containsKey("com.sample.CiaoWorld"));
        ksession.insert((Object)"Ciao");
        ksession.startProcess("com.sample.HelloWorld");
        ksession.startProcess("com.sample.HelloWorld");
        ksession.startProcess("com.sample.CiaoWorld");
        ksession.fireAllRules();
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor, 1L, 0L, 1L);
        this.checkTotalFactCount(aggrMonitor, 1);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor, tft + 1L);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor, 1);
        this.checkStatsForProcess((GenericKieSessionMonitoringMXBean)aggrMonitor, "com.sample.HelloWorld", 2L, 2L, 6L);
        this.checkStatsForProcess((GenericKieSessionMonitoringMXBean)aggrMonitor, "com.sample.CiaoWorld", 1L, 1L, 3L);
        ksession.fireAllRules();
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor, 1L, 0L, 1L);
        this.checkTotalFactCount(aggrMonitor, 1);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor, tft);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor, 1);
        this.checkStatsForProcess((GenericKieSessionMonitoringMXBean)aggrMonitor, "com.sample.HelloWorld", 2L, 2L, 6L);
        this.checkStatsForProcess((GenericKieSessionMonitoringMXBean)aggrMonitor, "com.sample.CiaoWorld", 1L, 1L, 3L);
        LOG.debug("---");
        KieSession ksession2 = kc.newKieSession(KSESSION1, sessionConf);
        ksession2.insert((Object)"Ciao");
        ksession.startProcess("com.sample.HelloWorld");
        ksession.startProcess("com.sample.HelloWorld");
        ksession.startProcess("com.sample.CiaoWorld");
        ksession2.fireAllRules();
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor, 2L, 0L, 2L);
        this.checkTotalFactCount(aggrMonitor, 2);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor, tft + 1L);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor, 2);
        this.checkStatsForProcess((GenericKieSessionMonitoringMXBean)aggrMonitor, "com.sample.HelloWorld", 4L, 4L, 12L);
        this.checkStatsForProcess((GenericKieSessionMonitoringMXBean)aggrMonitor, "com.sample.CiaoWorld", 2L, 2L, 6L);
        LOG.debug("--- NOW for the STATELESS ---");
        tft = 0L;
        StatelessKieSession stateless = kc.newStatelessKieSession(KSESSION2, sessionConf);
        StatelessKieSessionMonitoringMXBean aggrMonitor2 = JMX.newMXBeanProxy(mbserver, DroolsManagementAgent.createObjectNameBy((String)KCONTAINER1, (String)KBASE1, (KieSessionModel.KieSessionType)KieSessionModel.KieSessionType.STATELESS, (String)KSESSION2), StatelessKieSessionMonitoringMXBean.class);
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor2);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor2, 0L, 0L, 0L);
        this.checkRuleRuntimeTotals(aggrMonitor2, 0, 0);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor2, tft);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor2, 0);
        ArrayList<Command> cmds = new ArrayList<Command>();
        cmds.add(CommandFactory.newInsert((Object)"Ciao"));
        cmds.add(CommandFactory.newStartProcess((String)"com.sample.HelloWorld"));
        cmds.add(CommandFactory.newStartProcess((String)"com.sample.HelloWorld"));
        cmds.add(CommandFactory.newStartProcess((String)"com.sample.CiaoWorld"));
        BatchExecutionCommand batch = CommandFactory.newBatchExecution(cmds);
        stateless.execute((Command)batch);
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor2);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor2, 1L, 0L, 1L);
        this.checkRuleRuntimeTotals(aggrMonitor2, 1, 0);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor2, tft + 1L);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor2, 1);
        this.checkStatsForProcess((GenericKieSessionMonitoringMXBean)aggrMonitor2, "com.sample.HelloWorld", 2L, 2L, 6L);
        this.checkStatsForProcess((GenericKieSessionMonitoringMXBean)aggrMonitor2, "com.sample.CiaoWorld", 1L, 1L, 3L);
        stateless.execute((Command)batch);
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor2);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor2, 2L, 0L, 2L);
        this.checkRuleRuntimeTotals(aggrMonitor2, 2, 0);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor2, tft + 1L);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor2, 2);
        this.checkStatsForProcess((GenericKieSessionMonitoringMXBean)aggrMonitor2, "com.sample.HelloWorld", 4L, 4L, 12L);
        this.checkStatsForProcess((GenericKieSessionMonitoringMXBean)aggrMonitor2, "com.sample.CiaoWorld", 2L, 2L, 6L);
        StatelessKieSession stateless2 = kc.newStatelessKieSession(KSESSION2, sessionConf);
        LOG.debug(stateless + " " + stateless2);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor2, 2);
        stateless2.execute((Command)batch);
        this.print((GenericKieSessionMonitoringMXBean)aggrMonitor2);
        this.checkAgendaTotals((GenericKieSessionMonitoringMXBean)aggrMonitor2, 3L, 0L, 3L);
        this.checkRuleRuntimeTotals(aggrMonitor2, 3, 0);
        tft = this.checkTotalFiringTimeGEQ((GenericKieSessionMonitoringMXBean)aggrMonitor2, tft + 1L);
        this.checkTotalSessions((GenericKieSessionMonitoringMXBean)aggrMonitor2, 3);
        this.checkStatsForProcess((GenericKieSessionMonitoringMXBean)aggrMonitor2, "com.sample.HelloWorld", 6L, 6L, 18L);
        this.checkStatsForProcess((GenericKieSessionMonitoringMXBean)aggrMonitor2, "com.sample.CiaoWorld", 3L, 3L, 9L);
    }

    private void checkStatsForProcess(GenericKieSessionMonitoringMXBean mb, String ruleName, long iStarted, long iCompleted, long nodesTriggered) {
        Assert.assertEquals((long)iStarted, (long)mb.getStatsForProcess(ruleName).getProcessInstancesStarted());
        Assert.assertEquals((long)iCompleted, (long)mb.getStatsForProcess(ruleName).getProcessInstancesCompleted());
        Assert.assertEquals((long)nodesTriggered, (long)mb.getStatsForProcess(ruleName).getProcessNodesTriggered());
    }

    private static void blockOnSystemINforENTER() throws Exception {
        Runnable task2 = new Runnable(){

            @Override
            public void run() {
                System.out.println("Press ENTER to continue: ");
                Scanner sin = new Scanner(System.in);
                sin.nextLine();
            }
        };
        ExecutorService es = Executors.newCachedThreadPool();
        es.submit(task2).get();
    }

    private void checkStatsByRule(GenericKieSessionMonitoringMXBean mb, String ruleName, long mCreated, long mCancelled, long mFired) {
        Assert.assertEquals((long)mCreated, (long)((GenericKieSessionMonitoringMXBean.IAgendaStatsData)mb.getStatsByRule().get(ruleName)).getMatchesCreated());
        Assert.assertEquals((long)mCancelled, (long)((GenericKieSessionMonitoringMXBean.IAgendaStatsData)mb.getStatsByRule().get(ruleName)).getMatchesCancelled());
        Assert.assertEquals((long)mFired, (long)((GenericKieSessionMonitoringMXBean.IAgendaStatsData)mb.getStatsByRule().get(ruleName)).getMatchesFired());
    }

    private void checkStatsForRule(GenericKieSessionMonitoringMXBean mb, String ruleName, long mCreated, long mCancelled, long mFired) {
        Assert.assertEquals((long)mCreated, (long)mb.getStatsForRule(ruleName).getMatchesCreated());
        Assert.assertEquals((long)mCancelled, (long)mb.getStatsForRule(ruleName).getMatchesCancelled());
        Assert.assertEquals((long)mFired, (long)mb.getStatsForRule(ruleName).getMatchesFired());
    }

    private void print(GenericKieSessionMonitoringMXBean mb) {
        LOG.debug("total match created  : {}", (Object)mb.getTotalMatchesCreated());
        LOG.debug("total match cancelled: {}", (Object)mb.getTotalMatchesCancelled());
        LOG.debug("total match fired    : {}", (Object)mb.getTotalMatchesFired());
        if (mb instanceof StatelessKieSessionMonitoringMXBean) {
            StatelessKieSessionMonitoringMXBean c = (StatelessKieSessionMonitoringMXBean)mb;
            LOG.debug("inserted and deleted : +{} -{}", (Object)c.getTotalObjectsInserted(), (Object)c.getTotalObjectsDeleted());
        } else if (mb instanceof KieSessionMonitoringMXBean) {
            KieSessionMonitoringMXBean c = (KieSessionMonitoringMXBean)mb;
            LOG.debug("total tact count     : {}", (Object)c.getTotalFactCount());
        }
        LOG.debug("{} ms .", (Object)mb.getTotalFiringTime());
    }

    private long checkTotalFiringTimeGEQ(GenericKieSessionMonitoringMXBean mb, long amount) {
        Assert.assertTrue((mb.getTotalFiringTime() >= amount ? 1 : 0) != 0);
        return mb.getTotalFiringTime();
    }

    private void checkTotalSessions(GenericKieSessionMonitoringMXBean mb, int totalSessions) {
        Assert.assertEquals((long)totalSessions, (long)mb.getTotalSessions());
    }

    private void checkTotalFactCount(KieSessionMonitoringMXBean mb, int factCount) {
        Assert.assertEquals((long)factCount, (long)mb.getTotalFactCount());
    }

    private void checkRuleRuntimeTotals(StatelessKieSessionMonitoringMXBean mb, int inserted, int deleted) {
        Assert.assertEquals((long)inserted, (long)mb.getTotalObjectsInserted());
        Assert.assertEquals((long)deleted, (long)mb.getTotalObjectsDeleted());
    }

    private void checkAgendaTotals(GenericKieSessionMonitoringMXBean mb, long mCreated, long mCancelled, long mFired) {
        Assert.assertEquals((long)mCreated, (long)mb.getTotalMatchesCreated());
        Assert.assertEquals((long)mCancelled, (long)mb.getTotalMatchesCancelled());
        Assert.assertEquals((long)mFired, (long)mb.getTotalMatchesFired());
    }
}

