/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jbpm.persistence.api.integration.model.ProcessInstanceView;
import org.jbpm.persistence.api.integration.model.TaskInstanceView;
import org.jbpm.persistence.processinstance.objects.TestEventEmitter;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.JbpmTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessHumanTaskTest
extends JbpmTestCase {
    private static final Logger logger = LoggerFactory.getLogger(ProcessHumanTaskTest.class);

    public ProcessHumanTaskTest() {
        super(true, false);
    }

    @Test
    public void testProcess() {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    @Test
    public void testProcessWithCreatedBy() {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/humantaskwithcreatedby.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("person", "krisv");
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello.createdby", params);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        Assert.assertEquals((Object)"mary", (Object)task.getCreatedById());
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        Assert.assertEquals((Object)"krisv", (Object)task.getCreatedById());
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    @Test
    public void testProcessRequestStrategy() {
        this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.REQUEST, "manager", new String[]{"org/jbpm/test/functional/task/humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    @Test
    public void testProcessProcessInstanceStrategy() {
        RuntimeManager manager = this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE, "manager", new String[]{"org/jbpm/test/functional/task/humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        long ksessionID = ksession.getIdentifier();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        manager.disposeRuntimeEngine(runtimeEngine);
        runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        ksession = runtimeEngine.getKieSession();
        taskService = runtimeEngine.getTaskService();
        Assert.assertEquals((long)ksessionID, (long)ksession.getIdentifier());
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
        manager.disposeRuntimeEngine(runtimeEngine);
    }

    @Test
    public void testProcessAndTaskIntegrationWithEventManager() {
        this.sessionPersistence = true;
        TestEventEmitter.clear();
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        List events = TestEventEmitter.getEvents();
        List piEvents = events.stream().filter(instanceView -> instanceView instanceof ProcessInstanceView).collect(Collectors.toList());
        List tiEvents = events.stream().filter(instanceView -> instanceView instanceof TaskInstanceView).collect(Collectors.toList());
        Assert.assertEquals((long)3L, (long)events.size());
        Assert.assertEquals((long)1L, (long)piEvents.size());
        Assert.assertEquals((long)2L, (long)tiEvents.size());
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }
}

