/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression.async;

import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.executor.impl.wih.AsyncWorkItemHandler;
import org.jbpm.persistence.jpa.hibernate.DisabledFollowOnLockOracle10gDialect;
import org.jbpm.persistence.util.PersistenceUtil;
import org.jbpm.test.JbpmAsyncJobTestCase;
import org.jbpm.test.listener.TrackingProcessEventListener;
import org.junit.After;
import org.junit.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.executor.Command;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItemHandler;
import qa.tools.ikeeper.annotation.BZ;

public class AsyncWIHOnOracleTest
extends JbpmAsyncJobTestCase {
    public static final String PROCESS = "org/jbpm/test/regression/async/AsyncWIHOnOracle.bpmn2";
    public static final String PROCESS_ID = "org.jbpm.test.regression.async.AsyncWIHOnOracle";
    private static final int EXECUTOR_THREADS = 2;
    private static final int EXECUTOR_RETRIES = 2;
    private static final int EXECUTOR_INTERVAL = 1;

    public AsyncWIHOnOracleTest() {
        super(2, 2, 1);
    }

    @Override
    public void setUp() throws Exception {
        String driverClassName = PersistenceUtil.getDatasourceProperties().getProperty("driverClassName");
        if (driverClassName != null && driverClassName.contains("Oracle")) {
            String hibernateDialect = DisabledFollowOnLockOracle10gDialect.class.getName();
            this.setPersistenceProperty("hibernate.dialect", hibernateDialect);
            this.logger.info("Using hibernate.dialect=" + hibernateDialect);
        }
        super.setUp();
    }

    @Test
    @BZ(value={"1234592"})
    public void testAsyncWIHExecutedMoreThanOnceOnOracle() throws Exception {
        KieSession ksession = this.createKSession(PROCESS);
        TrackingProcessEventListener tpel = new TrackingProcessEventListener();
        ksession.addEventListener((ProcessEventListener)tpel);
        AsyncWorkItemHandler wih = new AsyncWorkItemHandler(this.getExecutorService(), CounterCommand.class.getName());
        ksession.getWorkItemManager().registerWorkItemHandler("async", (WorkItemHandler)wih);
        ksession.startProcess(PROCESS_ID);
        boolean completed = tpel.waitForProcessToComplete(10000L);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)completed).as("The process should have finished in 10s", new Object[0])).isTrue();
        ((AbstractIntegerAssert)Assertions.assertThat((int)CounterCommand.getCounter()).as("The job has not been executed", new Object[0])).isNotEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)CounterCommand.getCounter()).as("The job has been executed multiple times", new Object[0])).isEqualTo(1);
    }

    @Override
    @After
    public void tearDown() {
        try {
            super.tearDown();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class CounterCommand
    implements Command {
        private static int counter = 0;

        public ExecutionResults execute(CommandContext commandContext) throws Exception {
            ++counter;
            return new ExecutionResults();
        }

        public static int getCounter() {
            return counter;
        }
    }
}

