/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.timer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.UserTransaction;
import org.drools.core.command.SingleSessionCommandService;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.time.TimerService;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.TimerServiceRegistry;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.process.core.timer.impl.QuartzSchedulerService;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.functional.timer.TimerBaseTest;
import org.jbpm.test.listener.process.NodeLeftCountDownProcessEventListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.TaskSummary;
import org.kie.api.task.model.User;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.UserGroupCallback;
import org.kie.internal.task.api.model.InternalOrganizationalEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class GlobalTimerServiceVolumeTest
extends TimerBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(GlobalTimerServiceVolumeTest.class);
    private UserGroupCallback userGroupCallback;
    private GlobalSchedulerService globalScheduler;
    private RuntimeManager manager;
    private EntityManagerFactory emf;
    private int numberOfProcesses = 10;
    private NodeLeftCountDownProcessEventListener countDownListener;
    private String strategy;
    @Rule
    public TestName testName = new TestName();

    @Parameterized.Parameters(name="Strategy : {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"request"}, {"processinstance"}, {"case"});
    }

    public GlobalTimerServiceVolumeTest(String strategy) {
        this.strategy = strategy;
    }

    @Before
    public void setup() {
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        System.setProperty("org.quartz.properties", "quartz-db.properties");
        this.testCreateQuartzSchema();
        this.globalScheduler = new QuartzSchedulerService();
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.test.persistence");
        this.countDownListener = new NodeLeftCountDownProcessEventListener("timer", this.numberOfProcesses);
        final ArrayList timerExporations = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("timer")) {
                    timerExporations.add(event.getProcessInstance().getId());
                }
            }
        };
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/IntermediateCatchEventTimerCycleWithHT3.bpmn2"), ResourceType.BPMN2).schedulerService((Object)this.globalScheduler).registerableItemsFactory((RegisterableItemsFactory)(TimerBaseTest)this.new TimerBaseTest.TestRegisterableItemsFactory(new ProcessEventListener[]{listener, this.countDownListener})).get();
        if ("processinstance".equals(this.strategy)) {
            this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment, "first");
        } else if ("request".equals(this.strategy)) {
            this.manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment, "first");
        } else if ("case".equals(this.strategy)) {
            this.manager = RuntimeManagerFactory.Factory.get().newPerCaseRuntimeManager(environment, "first");
        } else {
            throw new RuntimeException("Unknow type of runtime strategy");
        }
    }

    @After
    public void tearDown() {
        this.globalScheduler.shutdown();
        if (this.manager != null) {
            this.manager.close();
        }
        this.emf.close();
    }

    @Test(timeout=30000L)
    public void testRuntimeManagerStrategyWithTimerService() throws Exception {
        RuntimeEngine engine = this.manager.getRuntimeEngine(EmptyContext.get());
        TaskService taskService = engine.getTaskService();
        Group grouphr = TaskModelProvider.getFactory().newGroup();
        ((InternalOrganizationalEntity)grouphr).setId("HR");
        Group groupadmins = TaskModelProvider.getFactory().newGroup();
        ((InternalOrganizationalEntity)groupadmins).setId("Administrators");
        User mary = TaskModelProvider.getFactory().newUser();
        ((InternalOrganizationalEntity)mary).setId("mary");
        User john = TaskModelProvider.getFactory().newUser();
        ((InternalOrganizationalEntity)john).setId("john");
        User admin = TaskModelProvider.getFactory().newUser();
        ((InternalOrganizationalEntity)admin).setId("Administrator");
        ((InternalTaskService)taskService).addGroup(grouphr);
        ((InternalTaskService)taskService).addGroup(groupadmins);
        ((InternalTaskService)taskService).addUser(mary);
        ((InternalTaskService)taskService).addUser(john);
        ((InternalTaskService)taskService).addUser(admin);
        this.manager.disposeRuntimeEngine(engine);
        for (int counter = this.numberOfProcesses; counter > 0; --counter) {
            new StartProcessPerProcessInstanceRunnable(this.manager).run();
        }
        Collection timers = null;
        ConcurrentHashMap jobs = null;
        TimerService timerService = TimerServiceRegistry.getInstance().get(this.manager.getIdentifier() + "-timerServiceId");
        if (timerService != null && timerService instanceof GlobalTimerService) {
            jobs = ((GlobalTimerService)timerService).getTimerJobsPerSession();
            timers = ((GlobalTimerService)timerService).getTimerJobFactoryManager().getTimerJobInstances();
        }
        Assert.assertNotNull((String)"Jobs should not be null as number of timers have been created", jobs);
        Assert.assertEquals((String)"There should be no jobs in the global timer service", (long)0L, (long)jobs.size());
        Assert.assertNotNull((String)"Timer instances should not be null as number of timers have been created", (Object)timers);
        Assert.assertEquals((String)"There should be no timer instances in the global timer service manager", (long)0L, (long)timers.size());
        RuntimeEngine empty = this.manager.getRuntimeEngine(EmptyContext.get());
        AuditService logService = empty.getAuditService();
        List logs = logService.findActiveProcessInstances("IntermediateCatchEvent");
        Assert.assertEquals((String)("Active process instances should be " + this.numberOfProcesses), (long)this.numberOfProcesses, (long)logs.size());
        this.countDownListener.waitTillCompleted();
        List tasks = empty.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((String)("Number of John's tasks should be " + this.numberOfProcesses), (long)this.numberOfProcesses, (long)tasks.size());
        for (TaskSummary task : tasks) {
            RuntimeEngine piEngine = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)task.getProcessInstanceId()));
            piEngine.getTaskService().start(task.getId().longValue(), "john");
            piEngine.getTaskService().complete(task.getId().longValue(), "john", null);
            this.manager.disposeRuntimeEngine(piEngine);
        }
        logs = logService.findActiveProcessInstances("IntermediateCatchEvent");
        Assert.assertEquals((String)"Active process instances should be 0", (long)0L, (long)logs.size());
        logService.dispose();
        this.manager.disposeRuntimeEngine(empty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testStartProcess(RuntimeEngine runtime) throws Exception {
        SingleSessionCommandService singleSessionCommandService = (SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)runtime.getKieSession()).getRunner();
        synchronized (singleSessionCommandService) {
            UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
            try {
                ut.begin();
                logger.debug("Starting process on ksession {}", (Object)runtime.getKieSession().getIdentifier());
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("x", "5s");
                ProcessInstance processInstance = runtime.getKieSession().startProcess("IntermediateCatchEvent", params);
                logger.debug("Started process instance {} on ksession {}", (Object)processInstance.getId(), (Object)runtime.getKieSession().getIdentifier());
                ut.commit();
            }
            catch (Exception ex) {
                ut.rollback();
                throw ex;
            }
        }
    }

    public class StartProcessPerProcessInstanceRunnable
    implements Runnable {
        private RuntimeManager manager;

        public StartProcessPerProcessInstanceRunnable(RuntimeManager manager) {
            this.manager = manager;
        }

        @Override
        public void run() {
            try {
                RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
                GlobalTimerServiceVolumeTest.this.testStartProcess(runtime);
                this.manager.disposeRuntimeEngine(runtime);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

