/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression.event;

import java.util.Arrays;
import java.util.Collection;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;

@RunWith(value=Parameterized.class)
public class BoundaryErrorEventTest
extends JbpmTestCase {
    private static final String PROCESS_PREFIX = "org/jbpm/test/regression/event/BoundaryErrorEvent-";
    private static final String PROCESS_ID = "org.jbpm.test.regression.event.BoundaryErrorEvent";
    private KieSession ksession;

    public BoundaryErrorEventTest(boolean persistence) {
        super(persistence);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{false}, {true}};
        return Arrays.asList(data);
    }

    @After
    public void tearDown() throws Exception {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
        super.tearDown();
    }

    @Test
    public void testBoundaryErrorEventDefaultHandlerWithErrorCodeWithStructureRef() {
        try {
            this.startInstance("WithErrorCodeWithStructureRef.bpmn2");
            Assert.fail((String)"This is not a default handler. So WorkflowRuntimeException must be thrown");
        }
        catch (WorkflowRuntimeException workflowRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testBoundaryErrorEventDefaultHandlerWithErrorCodeWithoutStructureRef() {
        try {
            this.startInstance("WithErrorCodeWithoutStructureRef.bpmn2");
            Assert.fail((String)"This is not a default handler. So WorkflowRuntimeException must be thrown");
        }
        catch (WorkflowRuntimeException workflowRuntimeException) {
            // empty catch block
        }
    }

    @Test
    public void testBoundaryErrorEventDefaultHandlerWithErrorCodeMatchWithStructureRef() {
        ProcessInstance processInstance = this.startInstance("WithErrorCodeMatchWithStructureRef.bpmn2");
        this.assertNodesTriggered(processInstance);
    }

    @Test
    public void testBoundaryErrorEventDefaultHandlerWithErrorCodeMatchWithoutStructureRef() {
        ProcessInstance processInstance = this.startInstance("WithErrorCodeMatchWithoutStructureRef.bpmn2");
        this.assertNodesTriggered(processInstance);
    }

    @Test
    public void testBoundaryErrorEventDefaultHandlerWithoutErrorCodeWithStructureRef() {
        ProcessInstance processInstance = this.startInstance("WithoutErrorCodeWithStructureRef.bpmn2");
        this.assertNodesTriggered(processInstance);
    }

    @Test
    public void testBoundaryErrorEventDefaultHandlerWithoutErrorCodeWithoutStructureRef() {
        ProcessInstance processInstance = this.startInstance("WithoutErrorCodeWithoutStructureRef.bpmn2");
        this.assertNodesTriggered(processInstance);
    }

    private ProcessInstance startInstance(String resourceSuffix) {
        this.ksession = this.createKSession(PROCESS_PREFIX + resourceSuffix);
        ExceptionWorkItemHandler handler = new ExceptionWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        return this.ksession.startProcess(PROCESS_ID);
    }

    private void assertNodesTriggered(ProcessInstance pi) {
        this.assertNodeTriggered(pi.getId(), new String[]{"Start", "User Task", "MyBoundaryErrorEvent", "Script Task 1"});
    }

    private class ExceptionWorkItemHandler
    implements WorkItemHandler {
        private ExceptionWorkItemHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            throw new RuntimeException();
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }
    }
}

