/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.migration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.transaction.TransactionManager;
import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.command.impl.RegistryContext;
import org.jbpm.persistence.processinstance.ProcessInstanceInfo;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.WorkflowProcessInstanceUpgrader;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;

public class ProcessInstanceMigrationTest
extends JbpmTestCase {
    private RuntimeManager manager;
    private RuntimeEngine engine;
    private KieSession ksession;
    private TaskService taskService;
    private TransactionManager transactionManager;

    public ProcessInstanceMigrationTest() {
        super(true, true);
    }

    @Before
    public void init() throws Exception {
        this.manager = this.createRuntimeManager(new String[]{"org/jbpm/test/functional/migration/sample.bpmn2", "org/jbpm/test/functional/migration/sample2.bpmn2", "org/jbpm/test/functional/migration/BPMN2-ProcessVersion-3.bpmn2", "org/jbpm/test/functional/migration/BPMN2-ProcessVersion-4.bpmn2", "org/jbpm/test/functional/migration/sample3.bpmn2", "org/jbpm/test/functional/migration/sample4.bpmn2", "org/jbpm/test/functional/migration/subprocess1.bpmn2", "org/jbpm/test/functional/migration/subprocess2.bpmn2"});
        this.engine = this.manager.getRuntimeEngine(null);
        this.ksession = this.engine.getKieSession();
        this.taskService = this.engine.getTaskService();
        this.transactionManager = com.arjuna.ats.jta.TransactionManager.transactionManager();
        this.transactionManager.setTransactionTimeout(3600);
    }

    @Test
    public void testProcessInstanceMigration() throws Exception {
        ProcessInstance p = this.ksession.startProcess("com.sample.bpmn.migration");
        long pid = p.getId();
        Assert.assertEquals((Object)"com.sample.bpmn.migration", (Object)this.ksession.getProcessInstance(pid).getProcessId());
        List<TaskSummary> list = this.assertTaskAssignedTo("john");
        UpgradeCommand c = new UpgradeCommand(pid, null, "com.sample.bpmn.migration2");
        this.ksession.execute((Command)c);
        this.completeTask(list.get(0));
        list = this.assertTaskAssignedTo("mary");
        this.assertDefinitionChanged(pid, "com.sample.bpmn.migration2", false);
    }

    @Test
    public void testProcessInstanceMigrationWithGatewaysAndSameUniqueId() throws Exception {
        PersistenceWorkItemHandler handler = new PersistenceWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 5);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)this.ksession.startProcess("com.sample.BPMN2ProcessVersion3", params);
        long pid = processInstance.getId();
        Assert.assertEquals((long)1L, (long)processInstance.getNodeInstances().size());
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("UserTask", "StartTask");
        ExplicitUpgradeCommand c = new ExplicitUpgradeCommand(pid, mapping, "com.sample.BPMN2ProcessVersion4");
        this.ksession.execute((Command)c);
        Assert.assertEquals((Object)"com.sample.BPMN2ProcessVersion4", (Object)this.ksession.getProcessInstance(pid).getProcessId());
        Assert.assertEquals((long)1L, (long)processInstance.getNodeInstances().size());
        NodeInstance current = (NodeInstance)processInstance.getNodeInstances().iterator().next();
        handler.completeWorkItem((WorkItem)((WorkItemNodeInstance)current).getWorkItem(), this.ksession.getWorkItemManager());
        handler.completeWorkItem(handler.getWorkItem("FirstPath"), this.ksession.getWorkItemManager());
        handler.completeWorkItem(handler.getWorkItem("SecondPath"), this.ksession.getWorkItemManager());
        List vars = this.engine.getAuditService().findVariableInstances(pid, "x");
        Assert.assertNotNull((Object)vars);
        Assert.assertEquals((long)2L, (long)vars.size());
        Assert.assertEquals((Object)"10", (Object)((VariableInstanceLog)vars.get(1)).getValue());
        this.assertDefinitionChanged(pid, "com.sample.BPMN2ProcessVersion4", true);
    }

    @Test
    public void testProcessInstanceMigrationExplicit() throws Exception {
        ProcessInstance p = this.ksession.startProcess("com.sample.bpmn.migration");
        long pid = p.getId();
        Assert.assertEquals((Object)"com.sample.bpmn.migration", (Object)this.ksession.getProcessInstance(pid).getProcessId());
        List<TaskSummary> list = this.assertTaskAssignedTo("john");
        Assert.assertEquals((long)1L, (long)p.getState());
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("Task 1", "Task 2");
        ExplicitUpgradeCommand c = new ExplicitUpgradeCommand(pid, mapping, "com.sample.bpmn.migration2");
        this.ksession.execute((Command)c);
        this.completeTask(list.get(0));
        this.assertDefinitionChanged(pid, "com.sample.bpmn.migration2", true);
    }

    @Test
    public void testProcessInstanceMigrationExplicitSubprocesses() throws Exception {
        PersistenceWorkItemHandler handler = new PersistenceWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)this.ksession.startProcess("com.sample.bpmn.migration3");
        long pid = processInstance.getId();
        Assert.assertEquals((Object)"com.sample.bpmn.migration3", (Object)this.ksession.getProcessInstance(pid).getProcessId());
        Assert.assertEquals((long)1L, (long)processInstance.getState());
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("ForJohn", "ForMary");
        ExplicitUpgradeCommand c = new ExplicitUpgradeCommand(pid, mapping, "com.sample.bpmn.migration4");
        this.ksession.execute((Command)c);
        Assert.assertEquals((Object)"com.sample.bpmn.migration4", (Object)this.ksession.getProcessInstance(pid).getProcessId());
        handler.completeWorkItem(handler.getWorkItem("ForJohn"), this.ksession.getWorkItemManager());
        handler.completeWorkItem(handler.getWorkItem("ForBill"), this.ksession.getWorkItemManager());
        this.assertDefinitionChanged(pid, "com.sample.bpmn.migration4", true);
    }

    @Test
    public void testProcessInstanceMigrationImplicitSubprocess() throws Exception {
        ProcessInstance p = this.ksession.startProcess("com.sample.bpmn.migration.subprocess1");
        long pid = p.getId();
        Assert.assertEquals((Object)"com.sample.bpmn.migration.subprocess1", (Object)this.ksession.getProcessInstance(pid).getProcessId());
        List<TaskSummary> list = this.assertTaskAssignedTo("john");
        UpgradeCommand c = new UpgradeCommand(pid, null, "com.sample.bpmn.migration.subprocess2");
        this.ksession.execute((Command)c);
        this.completeTask(list.get(0));
        list = this.assertTaskAssignedTo("mary");
        this.assertDefinitionChanged(pid, "com.sample.bpmn.migration.subprocess2", false);
    }

    @Test
    public void testProcessInstanceMigrationExplicitBack() throws Exception {
        ProcessInstance p = this.ksession.startProcess("com.sample.bpmn.migration.subprocess1");
        long pid = p.getId();
        Assert.assertEquals((Object)"com.sample.bpmn.migration.subprocess1", (Object)this.ksession.getProcessInstance(pid).getProcessId());
        List<TaskSummary> list = this.assertTaskAssignedTo("john");
        this.completeTask(list.get(0));
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("ForJohn2", "ForJohn1");
        ExplicitUpgradeCommand c = new ExplicitUpgradeCommand(pid, mapping, "com.sample.bpmn.migration.subprocess2");
        this.ksession.execute((Command)c);
        list = this.assertTaskAssignedTo("john");
        this.completeTask(list.get(0));
        list = this.assertTaskAssignedTo("mary");
        this.assertDefinitionChanged(pid, "com.sample.bpmn.migration.subprocess2", false);
    }

    private List<TaskSummary> assertTaskAssignedTo(String user) {
        List list = this.taskService.getTasksAssignedAsPotentialOwner(user, "en-UK");
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        return list;
    }

    private void completeTask(TaskSummary task) {
        this.taskService.start(task.getId().longValue(), "john");
        this.taskService.complete(task.getId().longValue(), "john", null);
    }

    private void assertDefinitionChanged(long pid, String sPid, boolean complete) throws InterruptedException {
        if (!complete) {
            Assert.assertEquals((Object)sPid, (Object)this.ksession.getProcessInstance(pid).getProcessId());
        }
        EntityManager em = this.getEmf().createEntityManager();
        Query query = em.createQuery("select p from ProcessInstanceInfo p where p.processInstanceId = :pid").setParameter("pid", (Object)pid);
        List found = query.getResultList();
        int count = complete ? 0 : 1;
        Assert.assertNotNull((Object)found);
        Assert.assertEquals((long)count, (long)found.size());
        if (!complete) {
            ProcessInstanceInfo instance = (ProcessInstanceInfo)found.get(0);
            Assert.assertEquals((Object)sPid, (Object)instance.getProcessId());
        }
        this.manager.disposeRuntimeEngine(this.engine);
    }

    private static class ExplicitUpgradeCommand
    implements ExecutableCommand<Object> {
        private static final long serialVersionUID = 8673518721648293556L;
        private long pid;
        private Map<String, String> mapping;
        private String toProcessId;

        private ExplicitUpgradeCommand(long pid, Map<String, String> mapping, String toProcessId) {
            this.pid = pid;
            this.mapping = mapping;
            this.toProcessId = toProcessId;
        }

        public Object execute(Context arg0) {
            KieSession ksession = (KieSession)((RegistryContext)arg0).lookup(KieSession.class);
            WorkflowProcessInstanceUpgrader.upgradeProcessInstanceByNodeNames((KieRuntime)ksession, (Long)this.pid, (String)this.toProcessId, this.mapping);
            return null;
        }
    }

    private static class UpgradeCommand
    implements ExecutableCommand<Object> {
        private static final long serialVersionUID = -626809842544969669L;
        private long pid;
        private Map<String, Long> mapping;
        private String toProcessId;

        private UpgradeCommand(long pid, Map<String, Long> mapping, String toProcessId) {
            this.pid = pid;
            this.mapping = mapping;
            this.toProcessId = toProcessId;
        }

        public Object execute(Context arg0) {
            KieSession ksession = (KieSession)((RegistryContext)arg0).lookup(KieSession.class);
            WorkflowProcessInstanceUpgrader.upgradeProcessInstance((KieRuntime)ksession, (long)this.pid, (String)this.toProcessId, this.mapping);
            return null;
        }
    }

    private class PersistenceWorkItemHandler
    implements WorkItemHandler {
        private List<WorkItem> workItems = new ArrayList<WorkItem>();

        private PersistenceWorkItemHandler() {
        }

        public WorkItem getWorkItem(String nodeName) {
            for (WorkItem item : this.workItems) {
                if (((String)item.getParameter("NodeName")).compareTo(nodeName) != 0) continue;
                return item;
            }
            return null;
        }

        public void completeWorkItem(WorkItem workItem, WorkItemManager manager) {
            manager.completeWorkItem(workItem.getId(), null);
            this.workItems.remove(workItem);
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItems.add(workItem);
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItems.remove(workItem);
            manager.abortWorkItem(workItem.getId());
        }
    }
}

