/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression.subprocess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.TrackingProcessEventListener;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import qa.tools.ikeeper.annotation.BZ;

public class EmbeddedSubprocessTest
extends JbpmTestCase {
    private static final String INVALID_SUBPROCESS = "org/jbpm/test/regression/subprocess/EmbeddedSubprocess-invalidSubprocess.bpmn2";
    private static final String INVALID_SUBPROCESS2 = "org/jbpm/test/regression/subprocess/EmbeddedSubprocess-invalidSubprocess2.bpmn2";
    public static final String TERMINATING_END_EVENT = "org/jbpm/test/regression/subprocess/EmbeddedSubprocess-terminatingEndEvent.bpmn2";
    public static final String TERMINATING_END_EVENT_ID = "org.jbpm.test.regression.subprocess.EmbeddedSubprocess-terminatingEndEvent";
    public static final String TASK_COMPENSATION = "org/jbpm/test/regression/subprocess/EmbeddedSubprocess-taskCompensation.bpmn2";
    public static final String TASK_COMPENSATION_ID = "org.jbpm.test.regression.subprocess.EmbeddedSubprocess-taskCompensation";

    @Test
    @BZ(value={"1139591"})
    public void testInvalidSubprocess() {
        try {
            this.createKSession(INVALID_SUBPROCESS);
            Assertions.fail((String)"Process definition is invalid. KieSession should not have been created.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    @BZ(value={"1150226"})
    public void testInvalidSubprocess2() {
        try {
            this.createKSession(INVALID_SUBPROCESS2);
            Assertions.fail((String)"Process definition is invalid. KieSession should not have been created.");
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
    }

    @Test
    @BZ(value={"851286"})
    public void testTerminatingEndEvent() {
        KieSession ksession = this.createKSession(TERMINATING_END_EVENT);
        TrackingProcessEventListener processEvents = new TrackingProcessEventListener();
        ksession.addEventListener((ProcessEventListener)processEvents);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(EmbeddedSubprocessTest.getCommands().newStartProcess(TERMINATING_END_EVENT_ID));
        ksession.execute((Command)EmbeddedSubprocessTest.getCommands().newBatchExecution(commands, null));
        Assertions.assertThat((boolean)processEvents.wasNodeTriggered("main-script")).isTrue();
        Assertions.assertThat((boolean)processEvents.wasNodeTriggered("main-end")).isTrue();
    }

    @Test
    @BZ(value={"1191768"})
    public void testTaskCompensation() throws Exception {
        KieSession kieSession = this.createKSession(TASK_COMPENSATION);
        kieSession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("compensation", "True");
        ProcessInstance processInstance = kieSession.startProcess(TASK_COMPENSATION_ID, params);
        long pid = processInstance.getId();
        this.assertProcessInstanceCompleted(pid);
        List log = this.getLogService().findVariableInstances(processInstance.getId(), "compensation");
        Assertions.assertThat((String)((VariableInstanceLog)log.get(log.size() - 1)).getValue()).isEqualTo((Object)"compensation");
    }
}

