/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.async;

import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import javax.persistence.EntityManagerFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.kie.services.impl.admin.commands.TriggerNodeCommand;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.TrackingProcessEventListener;
import org.jbpm.test.tools.TrackingListenerAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;

public class AsyncAdHocSubprocessTest
extends JbpmTestCase {
    private static final String ADHOC_ASYNC = "org/jbpm/test/functional/async/AsyncAdHocSubprocess.bpmn2";
    private static final String ADHOC_ASYNC_ID = "org.jbpm.test.functional.async.AsyncAdHocSubprocess";
    private static final String ERROR_MULTILEVEL_MAIN_PROCESS = "org/jbpm/test/functional/async/Level1P.bpmn2";
    private static final String ERROR_MULTILEVEL_CHILD_PROCESS = "org/jbpm/test/functional/async/Level2C.bpmn2";
    private static final String ERROR_MULTILEVEL_CHILD_CHILD_PROCESS = "org/jbpm/test/functional/async/Level3SC.bpmn2";
    private static final String ERROR_MULTILEVEL_EXCEPTION_PROCESS = "org/jbpm/test/functional/async/Exception.bpmn2";
    private static final String ERROR_MULTILEVEL_MAIN_PROCESS_ID = "nested-abort.level1P";
    private static final String ERROR_ASYNC_CHILD_EXCEPTION_PROCESS = "org/jbpm/test/functional/async/MainProcess.bpmn2";
    private static final String ERROR_ASYNC_MAIN_EXCEPTION_PROCESS = "org/jbpm/test/functional/async/SubProcess.bpmn2";
    private static final String ERROR_ASYNC_MAIN_EXCEPTION_PROCESS_ID = "cascade-abort.MainProcess";
    private ExecutorService executorService;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.getEmf());
        this.executorService.setInterval(1);
        this.executorService.init();
        this.addEnvironmentEntry("ExecutorService", this.executorService);
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.executorService.destroy();
    }

    @Test
    public void testAdHocSubAsyncProcessAuto() throws Exception {
        long WAIT_ACTION = 10000L;
        KieSession kieSession = this.createKSession(ADHOC_ASYNC);
        TrackingProcessEventListener eventListener = new TrackingProcessEventListener();
        kieSession.addEventListener((ProcessEventListener)eventListener);
        ProcessInstance pi = kieSession.startProcess(ADHOC_ASYNC_ID);
        long id = pi.getId();
        eventListener.waitForProcessToStart(10000L);
        TrackingListenerAssert.assertProcessStarted((TrackingProcessEventListener)eventListener, (String)ADHOC_ASYNC_ID);
        eventListener.waitForNodeToBeLeft("start", 10000L);
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)eventListener, (String)"start");
        kieSession.execute((Command)new TriggerNodeCommand(id, 3L));
        eventListener.waitForNodeToBeLeft("script1", 10000L);
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)eventListener, (String)"script1");
        kieSession.abortProcessInstance(id);
        eventListener.waitForProcessToAbort(10000L);
        this.assertProcessInstanceAborted(id);
    }

    @Test(timeout=30000L)
    public void testErrorMultilevelActivity() throws Exception {
        KieSession ksession = this.createKSession(ERROR_MULTILEVEL_MAIN_PROCESS, ERROR_MULTILEVEL_CHILD_PROCESS, ERROR_MULTILEVEL_CHILD_CHILD_PROCESS, ERROR_MULTILEVEL_EXCEPTION_PROCESS);
        final CountDownLatch latch = new CountDownLatch(1);
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                if (AsyncAdHocSubprocessTest.ERROR_MULTILEVEL_MAIN_PROCESS_ID.equals(event.getProcessInstance().getProcessId())) {
                    latch.countDown();
                }
            }
        });
        ksession.getWorkItemManager().registerWorkItemHandler("Rest", (WorkItemHandler)new RestWorkItemHandler());
        ProcessInstance pi = ksession.startProcess(ERROR_MULTILEVEL_MAIN_PROCESS_ID);
        latch.await();
        Thread.sleep(1000L);
        this.getLogService().findProcessInstances().stream().filter(e -> !e.getProcessId().equals("nested-abort.exception")).forEach(e -> MatcherAssert.assertThat((Object)e.getStatus(), (Matcher)CoreMatchers.is((Object)3)));
        this.assertProcessInstanceAborted(pi.getId());
    }

    @Test(timeout=30000L)
    public void testErrorAsyncActivity() throws Exception {
        KieSession ksession = this.createKSession(ERROR_ASYNC_CHILD_EXCEPTION_PROCESS, ERROR_ASYNC_MAIN_EXCEPTION_PROCESS);
        final CountDownLatch latch = new CountDownLatch(1);
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                if (AsyncAdHocSubprocessTest.ERROR_ASYNC_MAIN_EXCEPTION_PROCESS_ID.equals(event.getProcessInstance().getProcessId())) {
                    latch.countDown();
                }
            }
        });
        ksession.getWorkItemManager().registerWorkItemHandler("Rest", (WorkItemHandler)new RestWorkItemHandler(true));
        ProcessInstance pi = ksession.startProcess(ERROR_ASYNC_MAIN_EXCEPTION_PROCESS_ID);
        latch.await();
        Thread.sleep(1000L);
        this.getLogService().findProcessInstances().forEach(e -> MatcherAssert.assertThat((Object)e.getStatus(), (Matcher)CoreMatchers.is((Object)3)));
        this.assertProcessInstanceAborted(pi.getId());
    }

    static class RestWorkItemHandler
    implements WorkItemHandler {
        private boolean throwException;

        public RestWorkItemHandler() {
            this(false);
        }

        public RestWorkItemHandler(boolean throwException) {
            this.throwException = throwException;
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            if (this.throwException) {
                throw new RuntimeException();
            }
            manager.completeWorkItem(workItem.getId(), Collections.emptyMap());
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }
    }
}

