/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.timer;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.persistence.EntityManagerFactory;
import javax.transaction.UserTransaction;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.time.TimerService;
import org.jbpm.persistence.JpaProcessPersistenceContextManager;
import org.jbpm.persistence.jta.ContainerManagedTransactionManager;
import org.jbpm.process.core.timer.GlobalSchedulerService;
import org.jbpm.process.core.timer.TimerServiceRegistry;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.runtime.manager.impl.SimpleRuntimeEnvironment;
import org.jbpm.runtime.manager.impl.jpa.EntityManagerFactoryManager;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.services.task.impl.TaskDeadlinesServiceImpl;
import org.jbpm.services.task.persistence.JPATaskPersistenceContextManager;
import org.jbpm.test.functional.timer.TimerBaseTest;
import org.jbpm.test.listener.process.NodeLeftCountDownProcessEventListener;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.node.HumanTaskNodeInstance;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.command.RegistryContext;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.SessionNotFoundException;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GlobalTimerServiceBaseTest
extends TimerBaseTest {
    protected static final Logger logger = LoggerFactory.getLogger(GlobalTimerServiceBaseTest.class);
    protected GlobalSchedulerService globalScheduler;
    protected RuntimeManager manager;
    protected RuntimeEnvironment environment;
    protected EntityManagerFactory emf;

    protected abstract RuntimeManager getManager(RuntimeEnvironment var1, boolean var2);

    public void cleanup() {
        EntityManagerFactory emf;
        if (this.manager != null) {
            this.manager.close();
        }
        if (this.environment != null && (emf = ((SimpleRuntimeEnvironment)this.environment).getEmf()) != null) {
            emf.close();
        }
        if (this.emf != null && this.emf.isOpen()) {
            this.emf.close();
        }
        TaskDeadlinesServiceImpl.dispose();
    }

    @Test(timeout=20000L)
    public void testIntermediateTimerWithGlobalTestService() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 3);
        final ArrayList timerExpirations = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("timer")) {
                    timerExpirations.add(event.getProcessInstance().getId());
                }
            }
        };
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/IntermediateCatchEventTimerCycle3.bpmn2"), ResourceType.BPMN2).schedulerService((Object)this.globalScheduler).registerableItemsFactory((RegisterableItemsFactory)new TimerBaseTest.TestRegisterableItemsFactory((TimerBaseTest)this, new ProcessEventListener[]{listener, countDownListener})).get();
        this.manager = this.getManager(this.environment, true);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        this.manager.disposeRuntimeEngine(runtime);
        countDownListener.waitTillCompleted();
        try {
            runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            ksession = runtime.getKieSession();
            processInstance = ksession.getProcessInstance(processInstance.getId());
            Assert.assertNull((Object)processInstance);
        }
        catch (SessionNotFoundException sessionNotFoundException) {
            // empty catch block
        }
        Assert.assertEquals((long)3L, (long)timerExpirations.size());
        this.manager.disposeRuntimeEngine(runtime);
    }

    @Test(timeout=20000L)
    public void testTimerStart() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartProcess", 5);
        final ArrayList timerExpirations = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                timerExpirations.add(event.getProcessInstance().getId());
            }
        };
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/TimerStart2.bpmn2"), ResourceType.BPMN2).schedulerService((Object)this.globalScheduler).registerableItemsFactory((RegisterableItemsFactory)new TimerBaseTest.TestRegisterableItemsFactory((TimerBaseTest)this, new ProcessEventListener[]{listener, countDownListener})).get();
        this.manager = this.getManager(this.environment, false);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertEquals((long)0L, (long)timerExpirations.size());
        countDownListener.waitTillCompleted();
        this.manager.disposeRuntimeEngine(runtime);
        Assert.assertEquals((long)5L, (long)timerExpirations.size());
    }

    @Test
    @Ignore
    public void testTimerRule() throws Exception {
        int badNumTimers = 6;
        final CountDownLatch timerCompleted = new CountDownLatch(badNumTimers);
        final ArrayList timerExpirations = new ArrayList();
        DefaultAgendaEventListener listener = new DefaultAgendaEventListener(){

            public void beforeMatchFired(BeforeMatchFiredEvent event) {
                timerExpirations.add(event.getMatch().getRule().getId());
                timerCompleted.countDown();
            }
        };
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/timer-rules.drl"), ResourceType.DRL).schedulerService((Object)this.globalScheduler).registerableItemsFactory((RegisterableItemsFactory)new TimerBaseTest.TestRegisterableItemsFactory((TimerBaseTest)this, new AgendaEventListener[]{listener})).get();
        this.manager = this.getManager(this.environment, true);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        Assert.assertEquals((long)0L, (long)timerExpirations.size());
        boolean didNotWait = timerCompleted.await(6L, TimeUnit.SECONDS);
        Assert.assertTrue((String)("Too many timers elapsed: " + ((long)badNumTimers - timerCompleted.getCount())), (!didNotWait ? 1 : 0) != 0);
        this.manager.disposeRuntimeEngine(runtime);
        Assert.assertEquals((long)5L, (long)timerExpirations.size());
    }

    @Test(timeout=20000L)
    public void testInterediateTimerWithHTAfterWithGlobalTestService() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 3);
        final ArrayList timerExpirations = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("timer")) {
                    timerExpirations.add(event.getProcessInstance().getId());
                }
            }
        };
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        JBossUserGroupCallbackImpl userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/IntermediateCatchEventTimerCycleWithHT.bpmn2"), ResourceType.BPMN2).schedulerService((Object)this.globalScheduler).registerableItemsFactory((RegisterableItemsFactory)new TimerBaseTest.TestRegisterableItemsFactory((TimerBaseTest)this, new ProcessEventListener[]{listener, countDownListener})).userGroupCallback((UserGroupCallback)userGroupCallback).get();
        this.manager = this.getManager(this.environment, true);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "R3/PT1S");
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent", params);
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        logger.debug("Disposed after start");
        this.manager.disposeRuntimeEngine(runtime);
        countDownListener.waitTillCompleted();
        countDownListener.reset(1);
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        ksession = runtime.getKieSession();
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Reserved);
        List tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwnerByStatus("john", statuses, "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)3L, (long)tasks.size());
        for (TaskSummary task : tasks) {
            runtime.getTaskService().start(task.getId().longValue(), "john");
            runtime.getTaskService().complete(task.getId().longValue(), "john", null);
        }
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
        countDownListener.waitTillCompleted(3000L);
        this.manager.disposeRuntimeEngine(runtime);
        Assert.assertEquals((long)3L, (long)timerExpirations.size());
    }

    @Test(timeout=20000L)
    public void testInterediateTimerWithHTBeforeWithGlobalTestService() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 3);
        final ArrayList timerExpirations = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("timer")) {
                    timerExpirations.add(event.getProcessInstance().getId());
                }
            }
        };
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        JBossUserGroupCallbackImpl userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/IntermediateCatchEventTimerCycleWithHT2.bpmn2"), ResourceType.BPMN2).schedulerService((Object)this.globalScheduler).registerableItemsFactory((RegisterableItemsFactory)new TimerBaseTest.TestRegisterableItemsFactory((TimerBaseTest)this, new ProcessEventListener[]{listener, countDownListener})).userGroupCallback((UserGroupCallback)userGroupCallback).get();
        this.manager = this.getManager(this.environment, true);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "R3/PT1S");
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent", params);
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Reserved);
        List tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwnerByStatus("john", statuses, "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        for (TaskSummary task : tasks) {
            runtime.getTaskService().start(task.getId().longValue(), "john");
            runtime.getTaskService().complete(task.getId().longValue(), "john", null);
        }
        this.manager.disposeRuntimeEngine(runtime);
        countDownListener.waitTillCompleted();
        countDownListener.reset(1);
        try {
            runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            ksession = runtime.getKieSession();
            processInstance = ksession.getProcessInstance(processInstance.getId());
            Assert.assertNull((Object)processInstance);
        }
        catch (SessionNotFoundException sessionNotFoundException) {
            // empty catch block
        }
        countDownListener.waitTillCompleted(3000L);
        this.manager.disposeRuntimeEngine(runtime);
        Assert.assertEquals((long)3L, (long)timerExpirations.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testIntermediateTimerWithGlobalTestServiceRollback() throws Exception {
        ProcessInstance processInstance;
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/IntermediateCatchEventTimerCycle3.bpmn2"), ResourceType.BPMN2).schedulerService((Object)this.globalScheduler).get();
        this.manager = this.getManager(this.environment, true);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        long ksessionId = ksession.getIdentifier();
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        try {
            ut.begin();
            processInstance = ksession.startProcess("IntermediateCatchEvent");
        }
        finally {
            ut.rollback();
        }
        this.manager.disposeRuntimeEngine(runtime);
        try {
            runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
            Assert.assertNull((Object)processInstance);
        }
        catch (SessionNotFoundException sessionNotFoundException) {
            // empty catch block
        }
        TimerService timerService = TimerServiceRegistry.getInstance().get(this.manager.getIdentifier() + "-timerServiceId");
        Collection timerInstances = timerService.getTimerJobInstances(ksessionId);
        Assert.assertNotNull((Object)timerInstances);
        Assert.assertEquals((long)0L, (long)timerInstances.size());
        if (runtime != null) {
            this.manager.disposeRuntimeEngine(runtime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testInterediateTimerWithHTBeforeWithGlobalTestServiceRollback() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        JBossUserGroupCallbackImpl userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/IntermediateCatchEventTimerCycleWithHT2.bpmn2"), ResourceType.BPMN2).schedulerService((Object)this.globalScheduler).userGroupCallback((UserGroupCallback)userGroupCallback).get();
        this.manager = this.getManager(this.environment, true);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        long ksessionId = ksession.getIdentifier();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "R3/PT1S");
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent", params);
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Reserved);
        List tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwnerByStatus("john", statuses, "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary task = (TaskSummary)tasks.get(0);
        runtime.getTaskService().start(task.getId().longValue(), "john");
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        try {
            ut.begin();
            runtime.getTaskService().complete(task.getId().longValue(), "john", null);
        }
        finally {
            ut.rollback();
        }
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Collection activeNodes = ((WorkflowProcessInstance)processInstance).getNodeInstances();
        Assert.assertNotNull((Object)activeNodes);
        Assert.assertEquals((long)1L, (long)activeNodes.size());
        Assert.assertTrue((boolean)(activeNodes.iterator().next() instanceof HumanTaskNodeInstance));
        TimerService timerService = TimerServiceRegistry.getInstance().get(this.manager.getIdentifier() + "-timerServiceId");
        Collection timerInstances = timerService.getTimerJobInstances(ksessionId);
        Assert.assertNotNull((Object)timerInstances);
        Assert.assertEquals((long)0L, (long)timerInstances.size());
        ksession.abortProcessInstance(processInstance.getId());
        this.manager.disposeRuntimeEngine(runtime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testInterediateBoundaryTimerWithGlobalTestServiceRollback() throws Exception {
        ProcessInstance processInstance;
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        JBossUserGroupCallbackImpl userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/HumanTaskWithBoundaryTimer.bpmn"), ResourceType.BPMN2).schedulerService((Object)this.globalScheduler).userGroupCallback((UserGroupCallback)userGroupCallback).get();
        this.manager = this.getManager(this.environment, true);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        long ksessionId = ksession.getIdentifier();
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        try {
            ut.begin();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("test", "john");
            processInstance = ksession.startProcess("PROCESS_1", params);
        }
        finally {
            ut.rollback();
        }
        this.manager.disposeRuntimeEngine(runtime);
        try {
            runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            processInstance = runtime.getKieSession().getProcessInstance(processInstance.getId());
            Assert.assertNull((Object)processInstance);
        }
        catch (SessionNotFoundException params) {
            // empty catch block
        }
        TimerService timerService = TimerServiceRegistry.getInstance().get(this.manager.getIdentifier() + "-timerServiceId");
        Collection timerInstances = timerService.getTimerJobInstances(ksessionId);
        Assert.assertNotNull((Object)timerInstances);
        Assert.assertEquals((long)0L, (long)timerInstances.size());
        if (runtime != null) {
            this.manager.disposeRuntimeEngine(runtime);
        }
    }

    @Test
    public void testHumanTaskDeadlineWithGlobalTimerService() throws Exception {
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/HumanTaskWithDeadlines.bpmn"), ResourceType.BPMN2).schedulerService((Object)this.globalScheduler).get();
        this.manager = this.getManager(this.environment, true);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("htdeadlinetest");
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        List krisTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("krisv", "en-UK");
        Assert.assertEquals((long)1L, (long)krisTasks.size());
        List johnTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)0L, (long)johnTasks.size());
        List maryTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("mary", "en-UK");
        Assert.assertEquals((long)0L, (long)maryTasks.size());
        this.manager.disposeRuntimeEngine(runtime);
        Thread.sleep(3000L);
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        krisTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("krisv", "en-UK");
        Assert.assertEquals((long)0L, (long)krisTasks.size());
        johnTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)johnTasks.size());
        maryTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("mary", "en-UK");
        Assert.assertEquals((long)0L, (long)maryTasks.size());
        runtime.getTaskService().start(((TaskSummary)johnTasks.get(0)).getId().longValue(), "john");
        this.manager.disposeRuntimeEngine(runtime);
        Thread.sleep(2000L);
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        krisTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("krisv", "en-UK");
        Assert.assertEquals((long)0L, (long)krisTasks.size());
        johnTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)johnTasks.size());
        maryTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("mary", "en-UK");
        Assert.assertEquals((long)0L, (long)maryTasks.size());
        this.manager.disposeRuntimeEngine(runtime);
        Thread.sleep(3000L);
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        krisTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("krisv", "en-UK");
        Assert.assertEquals((long)0L, (long)krisTasks.size());
        johnTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)0L, (long)johnTasks.size());
        maryTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("mary", "en-UK");
        Assert.assertEquals((long)1L, (long)maryTasks.size());
        runtime.getTaskService().start(((TaskSummary)maryTasks.get(0)).getId().longValue(), "mary");
        runtime.getTaskService().complete(((TaskSummary)maryTasks.get(0)).getId().longValue(), "mary", null);
        this.manager.disposeRuntimeEngine(runtime);
        Thread.sleep(2000L);
        try {
            runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            ksession = runtime.getKieSession();
            processInstance = ksession.getProcessInstance(processInstance.getId());
            Assert.assertNull((Object)processInstance);
        }
        catch (SessionNotFoundException sessionNotFoundException) {
            // empty catch block
        }
        this.manager.disposeRuntimeEngine(runtime);
    }

    @Test
    public void testHumanTaskDeadlineWithGlobalTimerServiceMultipleInstances() throws Exception {
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/HumanTaskWithDeadlines.bpmn"), ResourceType.BPMN2).schedulerService((Object)this.globalScheduler).get();
        this.manager = this.getManager(this.environment, true);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("htdeadlinetest");
        this.manager.disposeRuntimeEngine(runtime);
        RuntimeEngine runtime2 = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession2 = runtime2.getKieSession();
        ProcessInstance processInstance2 = ksession2.startProcess("htdeadlinetest");
        ksession2.abortProcessInstance(processInstance2.getId());
        this.manager.disposeRuntimeEngine(runtime2);
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        List krisTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("krisv", "en-UK");
        Assert.assertEquals((long)1L, (long)krisTasks.size());
        List johnTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)0L, (long)johnTasks.size());
        List maryTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("mary", "en-UK");
        Assert.assertEquals((long)0L, (long)maryTasks.size());
        this.manager.disposeRuntimeEngine(runtime);
        Thread.sleep(3000L);
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        krisTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("krisv", "en-UK");
        Assert.assertEquals((long)0L, (long)krisTasks.size());
        johnTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)johnTasks.size());
        maryTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("mary", "en-UK");
        Assert.assertEquals((long)0L, (long)maryTasks.size());
        runtime.getTaskService().start(((TaskSummary)johnTasks.get(0)).getId().longValue(), "john");
        this.manager.disposeRuntimeEngine(runtime);
        Thread.sleep(2000L);
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        krisTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("krisv", "en-UK");
        Assert.assertEquals((long)0L, (long)krisTasks.size());
        johnTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)johnTasks.size());
        maryTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("mary", "en-UK");
        Assert.assertEquals((long)0L, (long)maryTasks.size());
        this.manager.disposeRuntimeEngine(runtime);
        Thread.sleep(3000L);
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        krisTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("krisv", "en-UK");
        Assert.assertEquals((long)0L, (long)krisTasks.size());
        johnTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)0L, (long)johnTasks.size());
        maryTasks = runtime.getTaskService().getTasksAssignedAsPotentialOwner("mary", "en-UK");
        Assert.assertEquals((long)1L, (long)maryTasks.size());
        runtime.getTaskService().start(((TaskSummary)maryTasks.get(0)).getId().longValue(), "mary");
        runtime.getTaskService().complete(((TaskSummary)maryTasks.get(0)).getId().longValue(), "mary", null);
        this.manager.disposeRuntimeEngine(runtime);
        Thread.sleep(2000L);
        try {
            runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            ksession = runtime.getKieSession();
            processInstance = ksession.getProcessInstance(processInstance.getId());
            Assert.assertNull((Object)processInstance);
        }
        catch (SessionNotFoundException sessionNotFoundException) {
            // empty catch block
        }
        this.manager.disposeRuntimeEngine(runtime);
    }

    @Test(timeout=20000L)
    public void testIntermediateTimerWithGlobalTestServiceSimulateCMT() throws Exception {
        ProcessInstance processInstance;
        KieSession ksession;
        RuntimeEngine runtime;
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 3);
        final ArrayList timerExpirations = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("timer")) {
                    timerExpirations.add(event.getProcessInstance().getId());
                }
            }
        };
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        JBossUserGroupCallbackImpl userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        EntityManagerFactory emf = EntityManagerFactoryManager.get().getOrCreate("org.jbpm.test.persistence");
        ContainerManagedTransactionManager tm = new ContainerManagedTransactionManager();
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.api.persistence.jpa.EntityManagerFactory", (Object)emf);
        env.set("org.kie.transaction.TransactionManager", (Object)tm);
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/IntermediateCatchEventTimerCycleWithHT2.bpmn2"), ResourceType.BPMN2).addEnvironmentEntry("org.kie.transaction.TransactionManager", (Object)tm).addEnvironmentEntry("org.kie.api.persistence.PersistenceContextManager", (Object)new JpaProcessPersistenceContextManager(env)).addEnvironmentEntry("org.kie.api.persistence.TaskPersistenceContextManager", (Object)new JPATaskPersistenceContextManager(env)).schedulerService((Object)this.globalScheduler).registerableItemsFactory((RegisterableItemsFactory)new TimerBaseTest.TestRegisterableItemsFactory((TimerBaseTest)this, new ProcessEventListener[]{listener, countDownListener})).userGroupCallback((UserGroupCallback)userGroupCallback).get();
        UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        try {
            ut.begin();
            this.manager = this.getManager(this.environment, true);
            runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
            ksession = runtime.getKieSession();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("x", "R3/PT1S");
            processInstance = ksession.startProcess("IntermediateCatchEvent", params);
            ut.commit();
        }
        catch (Exception ex) {
            ut.rollback();
            throw ex;
        }
        Assert.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        try {
            ut.begin();
            runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            ksession = runtime.getKieSession();
            ArrayList<Status> statuses = new ArrayList<Status>();
            statuses.add(Status.Reserved);
            List tasks = runtime.getTaskService().getTasksAssignedAsPotentialOwnerByStatus("john", statuses, "en-UK");
            Assert.assertNotNull((Object)tasks);
            Assert.assertEquals((long)1L, (long)tasks.size());
            for (TaskSummary task : tasks) {
                runtime.getTaskService().start(task.getId().longValue(), "john");
                runtime.getTaskService().complete(task.getId().longValue(), "john", null);
            }
            ut.commit();
        }
        catch (Exception ex) {
            ut.rollback();
            throw ex;
        }
        countDownListener.waitTillCompleted();
        countDownListener.reset(1);
        ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        try {
            ut.begin();
            try {
                runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
                ksession = runtime.getKieSession();
                processInstance = ksession.getProcessInstance(processInstance.getId());
                Assert.assertNull((Object)processInstance);
            }
            catch (SessionNotFoundException ex) {
                // empty catch block
            }
            ut.commit();
        }
        catch (Exception ex) {
            ut.rollback();
            throw ex;
        }
        countDownListener.waitTillCompleted(3000L);
        Assert.assertEquals((long)3L, (long)timerExpirations.size());
    }

    @Test(timeout=20000L)
    public void testTimerFailureAndRetrigger() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Timer_1m", 3);
        final ArrayList timerExpirations = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Timer_1m")) {
                    timerExpirations.add(event.getNodeInstance().getId());
                }
            }
        };
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/helloretrigger.bpmn2"), ResourceType.BPMN2).schedulerService((Object)this.globalScheduler).registerableItemsFactory((RegisterableItemsFactory)new TimerBaseTest.TestRegisterableItemsFactory((TimerBaseTest)this, new ProcessEventListener[]{listener, countDownListener})).get();
        this.manager = this.getManager(this.environment, false);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        HashMap params = new HashMap();
        ProcessInstance pi = ksession.startProcess("rescheduletimer.helloretrigger", params);
        Assert.assertEquals((String)"Process instance should be active", (long)1L, (long)pi.getState());
        this.manager.disposeRuntimeEngine(runtime);
        final long processInstanceId = pi.getId();
        countDownListener.waitTillCompleted(8000L);
        Assert.assertEquals((String)"There should be only 3 nodes as there third is failing", (long)3L, (long)timerExpirations.size());
        runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
        ksession = runtime.getKieSession();
        ksession.execute((Command)new ExecutableCommand<Void>(){

            public Void execute(org.kie.api.runtime.Context context) {
                KieSession ksession = (KieSession)((RegistryContext)context).lookup(KieSession.class);
                ProcessInstance pi = ksession.getProcessInstance(processInstanceId);
                ((WorkflowProcessInstance)pi).setVariable("fixed", (Object)true);
                return null;
            }
        });
        this.manager.disposeRuntimeEngine(runtime);
        countDownListener.reset(1);
        countDownListener.waitTillCompleted(5000L);
        Assert.assertEquals((String)"There should be 3 expirations as the failing one should finally proceed", (long)3L, (long)timerExpirations.size());
        try {
            runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstanceId));
            ksession = runtime.getKieSession();
            pi = ksession.getProcessInstance(processInstanceId);
            Assert.assertNull((Object)pi);
        }
        catch (SessionNotFoundException sessionNotFoundException) {
            // empty catch block
        }
        ((AbstractRuntimeManager)this.manager).close(true);
    }

    @Test(timeout=20000L)
    public void testTimerStartMemoryLeak() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartProcess", 5);
        final ArrayList timerExpirations = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                timerExpirations.add(event.getProcessInstance().getId());
            }
        };
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/TimerStart2.bpmn2"), ResourceType.BPMN2).schedulerService((Object)this.globalScheduler).registerableItemsFactory((RegisterableItemsFactory)new TimerBaseTest.TestRegisterableItemsFactory((TimerBaseTest)this, new ProcessEventListener[]{listener, countDownListener})).get();
        this.manager = this.getManager(this.environment, false);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assert.assertEquals((long)0L, (long)timerExpirations.size());
        countDownListener.waitTillCompleted();
        this.manager.disposeRuntimeEngine(runtime);
        Assert.assertEquals((long)5L, (long)timerExpirations.size());
        TimerServiceRegistry timerServiceRegistry = TimerServiceRegistry.getInstance();
        GlobalTimerService timerService = (GlobalTimerService)timerServiceRegistry.get(this.manager.getIdentifier() + "-timerServiceId");
        ConcurrentHashMap timerJobsPerSession = timerService.getTimerJobsPerSession();
        Assert.assertEquals((long)0L, (long)timerJobsPerSession.size());
    }

    public static void cleanupSingletonSessionId() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (tempDir.exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = tempDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("-jbpmSessionId.ser");
                }
            })) {
                new File(tempDir, file).delete();
            }
        }
    }
}

