/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.async;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.persistence.EntityManagerFactory;
import org.assertj.core.api.Assertions;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.test.JbpmTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.test.util.db.PoolingDataSourceWrapper;

public class AsyncMultisubprocessTest
extends JbpmTestCase {
    private static CountDownLatch latch = new CountDownLatch(1);
    private static final String BPMN_AICS = "org/jbpm/test/functional/async/AsyncSubMultiprocess.bpmn2";
    private static final String PROCESS_AICS = "TestSubMult";
    private ExecutorService executorService;
    PoolingDataSourceWrapper ds;

    @Before
    public void setUp() throws Exception {
        this.setupDataSource = true;
        super.setUp();
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.getEmf());
        this.executorService.setInterval(1);
        this.executorService.init();
        this.addEnvironmentEntry("ExecutorService", this.executorService);
        this.addEnvironmentEntry("AsyncMode", new String("true"));
        this.addProcessEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessCompleted(ProcessCompletedEvent event) {
                latch.countDown();
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.executorService.destroy();
    }

    @Test
    public void testCorrectProcessStateAfterExceptionEndSignal() throws Exception {
        String USER_ID = "rhpamAdmin";
        KieSession ksession = this.createKSession(BPMN_AICS);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("number_reviews", 4);
        properties.put("approvalsRequired", 4);
        properties.put("employee", "egonzale");
        ProcessInstance processInstance = ksession.startProcess(PROCESS_AICS, properties);
        long pid1 = processInstance.getId();
        TaskService taskService = this.getRuntimeEngine().getTaskService();
        List taskIds = taskService.getTasksByProcessInstanceId(pid1);
        while (taskIds.size() < 4) {
            taskIds = taskService.getTasksByProcessInstanceId(pid1);
            Thread.sleep(100L);
        }
        for (Long taskId : taskIds) {
            taskService.claim(taskId.longValue(), "rhpamAdmin");
            taskService.start(taskId.longValue(), "rhpamAdmin");
            taskService.complete(taskId.longValue(), "rhpamAdmin", Collections.singletonMap("results", Boolean.TRUE));
        }
        latch.await();
        processInstance = ksession.getProcessInstance(pid1);
        Assertions.assertThat((Object)processInstance).isNull();
    }
}

