/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import java.util.Properties;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.util.SocketUtils;
import org.junit.After;
import org.junit.Before;

public abstract class LdapJbpmTestCase
extends JbpmTestCase {
    private static InMemoryDirectoryServer server;
    private static final int PORT;
    private final String ldif;

    public LdapJbpmTestCase(String ldif) {
        this.ldif = ldif;
    }

    @Before
    public void startDirectoryServer() throws LDAPException {
        InMemoryListenerConfig listenerConfig = InMemoryListenerConfig.createLDAPConfig((String)"default", (int)PORT);
        InMemoryDirectoryServerConfig serverConfig = new InMemoryDirectoryServerConfig(new DN[]{new DN("dc=jboss,dc=org")});
        serverConfig.setListenerConfigs(new InMemoryListenerConfig[]{listenerConfig});
        serverConfig.addAdditionalBindCredentials("uid=admin,ou=system", "secret");
        serverConfig.setSchema(null);
        server = new InMemoryDirectoryServer(serverConfig);
        server.importFromLDIF(false, this.ldif);
        server.startListening();
    }

    @After
    public void stopDirectoryServer() {
        if (server != null) {
            server.shutDown(true);
        }
    }

    protected Properties createUserGroupCallbackProperties() {
        Properties properties = new Properties();
        properties.setProperty("java.naming.provider.url", "ldap://localhost:" + PORT);
        properties.setProperty("ldap.user.ctx", "ou=People,dc=jboss,dc=org");
        properties.setProperty("ldap.role.ctx", "ou=Roles,dc=jboss,dc=org");
        properties.setProperty("ldap.user.filter", "(uid={0})");
        properties.setProperty("ldap.role.filter", "(cn={0})");
        properties.setProperty("ldap.user.roles.filter", "(member={0})");
        return properties;
    }

    static {
        PORT = SocketUtils.findAvailablePort();
    }
}

