/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.jobexec;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.impl.utils.DefaultCaseServiceConfigurator;
import org.jbpm.executor.AsynchronousJobListener;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.impl.ExecutorServiceImpl;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.task.audit.service.TaskJPAAuditService;
import org.jbpm.test.listener.CountDownAsyncJobListener;
import org.jbpm.test.services.AbstractCaseServicesTest;
import org.junit.Test;
import org.kie.api.executor.ExecutorService;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.runtime.manager.audit.query.NodeInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.ProcessInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.VariableInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.deploy.DeploymentDescriptorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseLogCleanupCommandTest
extends AbstractCaseServicesTest {
    private static final Logger logger = LoggerFactory.getLogger(CaseLogCleanupCommandTest.class);
    private static final String DEPLOYMENT_UNIT = "org.jbpm.cases:case-module:1.0.0";
    protected static final String ARTIFACT_ID = "case-module";
    protected static final String GROUP_ID = "org.jbpm.cases";
    protected static final String VERSION = "1.0.0";
    protected static final String USER = "john";
    public static final String LOG_CLEANUP = "org/jbpm/test/functional/jobexec/CaseLogCleanupCommand.bpmn2";
    public static final String LOG_CLEANUP_ID = "org.jbpm.test.functional.jobexec.CaseLogCleanupCommand";
    public static final String LOG_INCOMPLETE_CLEANUP = "org/jbpm/test/functional/jobexec/CaseLogIncompleteCleanupCommand.bpmn2";
    public static final String LOG_INCOMPLETE_CLEANUP_ID = "org.jbpm.test.functional.jobexec.CaseLogIncompleteCleanupCommand";
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final int EXECUTOR_THREADS = 4;
    private static final int EXECUTOR_RETRIES = 3;
    private static final int EXECUTOR_INTERVAL = 0;
    private int executorThreads = 4;
    private int executorRetries = 3;
    private int executorInterval = 0;
    private String dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private TaskJPAAuditService taskAuditService;
    private JPAAuditLogService auditLogService;
    private ExecutorService executorService;

    protected String getJndiDatasourceName() {
        return "jdbc/jbpm-ds";
    }

    public void setUp() throws Exception {
        super.setUp();
        this.taskAuditService = new TaskJPAAuditService(this.getEmf());
        this.taskAuditService.clear();
        this.auditLogService = new JPAAuditLogService(this.getEmf());
        this.auditLogService.clear();
    }

    protected String getPersistenceUnitName() {
        return "org.jbpm.test.persistence";
    }

    private EntityManagerFactory getEmf() {
        return ((DefaultCaseServiceConfigurator)this.caseConfigurator).getEmf();
    }

    public void tearDown() {
        try {
            this.taskAuditService.clear();
            this.taskAuditService.dispose();
            this.auditLogService.clear();
            this.auditLogService.dispose();
            this.executorService.clearAllRequests();
            this.executorService.clearAllErrors();
            this.executorService.destroy();
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void deleteAllLogsTest() throws Exception {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(1);
        ((ExecutorServiceImpl)this.getExecutorService()).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        String caseIdIncomplete = this.caseService.startCase(DEPLOYMENT_UNIT, LOG_INCOMPLETE_CLEANUP_ID);
        logger.info("CASE CREATED: {}", (Object)caseIdIncomplete);
        this.caseService.cancelCase(caseIdIncomplete);
        Thread.sleep(1010L);
        Assertions.assertThat((long)this.getCaseFileDataLogSize()).isEqualTo(1L);
        Assertions.assertThat((long)this.getCaseAssignmentRoleLogSize()).isPositive();
        this.scheduleLogCleanup(null, "1s", Collections.emptyMap());
        countDownListener.waitTillCompleted();
        Assertions.assertThat((long)this.getCaseFileDataLogSize()).isZero();
        Assertions.assertThat((long)this.getCaseAssignmentRoleLogSize()).isZero();
        Assertions.assertThat((int)this.getProcessLogSize(LOG_INCOMPLETE_CLEANUP_ID)).isZero();
        Assertions.assertThat((int)this.getTaskLogSize(LOG_INCOMPLETE_CLEANUP_ID)).isZero();
        Assertions.assertThat((int)this.getNodeInstanceLogSize(LOG_INCOMPLETE_CLEANUP_ID)).isZero();
        Assertions.assertThat((int)this.getVariableLogSize(LOG_INCOMPLETE_CLEANUP_ID)).isZero();
    }

    @Test
    public void deleteForDeploymentUnit() throws Exception {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(1);
        ((ExecutorServiceImpl)this.getExecutorService()).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        String caseIdIncomplete = this.caseService.startCase(DEPLOYMENT_UNIT, LOG_INCOMPLETE_CLEANUP_ID);
        logger.info("CASE CREATED: {}", (Object)caseIdIncomplete);
        this.caseService.cancelCase(caseIdIncomplete);
        Thread.sleep(1010L);
        Assertions.assertThat((long)this.getCaseFileDataLogSize()).isEqualTo(1L);
        Assertions.assertThat((long)this.getCaseAssignmentRoleLogSize()).isPositive();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Status", "2,3");
        params.put("ForDeployment", DEPLOYMENT_UNIT);
        this.scheduleLogCleanup(null, "1s", params);
        countDownListener.waitTillCompleted();
        Assertions.assertThat((long)this.getCaseFileDataLogSize()).isZero();
        Assertions.assertThat((long)this.getCaseAssignmentRoleLogSize()).isZero();
        Assertions.assertThat((int)this.getProcessLogSize(LOG_INCOMPLETE_CLEANUP_ID)).isZero();
        Assertions.assertThat((int)this.getTaskLogSize(LOG_INCOMPLETE_CLEANUP_ID)).isZero();
        Assertions.assertThat((int)this.getNodeInstanceLogSize(LOG_INCOMPLETE_CLEANUP_ID)).isZero();
        Assertions.assertThat((int)this.getVariableLogSize(LOG_INCOMPLETE_CLEANUP_ID)).isZero();
    }

    @Test
    public void deleteForCaseDefinition() throws Exception {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(1);
        ((ExecutorServiceImpl)this.getExecutorService()).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        String caseIdIncomplete = this.caseService.startCase(DEPLOYMENT_UNIT, LOG_INCOMPLETE_CLEANUP_ID);
        logger.info("CASE CREATED: {}", (Object)caseIdIncomplete);
        this.caseService.cancelCase(caseIdIncomplete);
        Thread.sleep(1010L);
        Assertions.assertThat((long)this.getCaseFileDataLogSize()).isEqualTo(1L);
        Assertions.assertThat((long)this.getCaseAssignmentRoleLogSize()).isPositive();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ForCaseDefId", LOG_INCOMPLETE_CLEANUP_ID);
        this.scheduleLogCleanup(null, "1s", params);
        countDownListener.waitTillCompleted();
        Assertions.assertThat((long)this.getCaseFileDataLogSize()).isZero();
        Assertions.assertThat((long)this.getCaseAssignmentRoleLogSize()).isZero();
        Assertions.assertThat((int)this.getProcessLogSize(LOG_INCOMPLETE_CLEANUP_ID)).isZero();
        Assertions.assertThat((int)this.getTaskLogSize(LOG_INCOMPLETE_CLEANUP_ID)).isZero();
        Assertions.assertThat((int)this.getNodeInstanceLogSize(LOG_INCOMPLETE_CLEANUP_ID)).isZero();
        Assertions.assertThat((int)this.getVariableLogSize(LOG_INCOMPLETE_CLEANUP_ID)).isZero();
    }

    @Test
    public void deletePartialLogsTest() throws Exception {
        CountDownAsyncJobListener countDownListener = new CountDownAsyncJobListener(1);
        ((ExecutorServiceImpl)this.getExecutorService()).addAsyncJobListener((AsynchronousJobListener)countDownListener);
        String caseIdComplete = this.caseService.startCase(DEPLOYMENT_UNIT, LOG_CLEANUP_ID);
        logger.info("CASE CREATED: {}", (Object)caseIdComplete);
        String caseIdIncomplete = this.caseService.startCase(DEPLOYMENT_UNIT, LOG_INCOMPLETE_CLEANUP_ID);
        logger.info("CASE CREATED: {}", (Object)caseIdIncomplete);
        Thread.sleep(1010L);
        Assertions.assertThat((long)this.getCaseFileDataLogSize()).isEqualTo(2L);
        Assertions.assertThat((long)this.getCaseAssignmentRoleLogSize()).isPositive();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("Status", "2");
        this.scheduleLogCleanup(null, "1s", params);
        countDownListener.waitTillCompleted();
        Assertions.assertThat((long)this.getCaseFileDataLogSize()).isEqualTo(1L);
        Assertions.assertThat((long)this.getCaseAssignmentRoleLogSize()).isPositive();
        Assertions.assertThat((int)this.getProcessLogSize(LOG_CLEANUP_ID)).isZero();
        Assertions.assertThat((int)this.getTaskLogSize(LOG_CLEANUP_ID)).isZero();
        Assertions.assertThat((int)this.getNodeInstanceLogSize(LOG_CLEANUP_ID)).isZero();
        Assertions.assertThat((int)this.getVariableLogSize(LOG_CLEANUP_ID)).isZero();
        Assertions.assertThat((int)this.getProcessLogSize(LOG_INCOMPLETE_CLEANUP_ID)).isPositive();
        Assertions.assertThat((int)this.getTaskLogSize(LOG_INCOMPLETE_CLEANUP_ID)).isPositive();
        Assertions.assertThat((int)this.getNodeInstanceLogSize(LOG_INCOMPLETE_CLEANUP_ID)).isPositive();
        Assertions.assertThat((int)this.getVariableLogSize(LOG_INCOMPLETE_CLEANUP_ID)).isPositive();
    }

    protected ExecutorService getExecutorService() {
        if (this.executorService == null) {
            this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.getEmf());
            this.executorService.setThreadPoolSize(this.executorThreads);
            this.executorService.setRetries(this.executorRetries);
            this.executorService.setInterval(this.executorInterval);
            this.executorService.init();
            logger.debug("Created ExecutorService with parameters: '" + this.executorThreads + " threads', '" + this.executorRetries + " retries', interval '" + this.executorInterval + "s'");
        }
        return this.executorService;
    }

    private long getCaseAssignmentRoleLogSize() {
        EntityManager em = this.getEmf().createEntityManager();
        long count = (Long)em.createQuery("SELECT COUNT(O) FROM CaseRoleAssignmentLog O").getSingleResult();
        em.close();
        return count;
    }

    private long getCaseFileDataLogSize() {
        EntityManager em = this.getEmf().createEntityManager();
        long count = (Long)em.createQuery("SELECT COUNT(O) FROM CaseFileDataLog O").getSingleResult();
        em.close();
        return count;
    }

    private int getProcessLogSize(String processId) {
        return ((ProcessInstanceLogQueryBuilder)this.auditLogService.processInstanceLogQuery().processId(new String[]{processId})).build().getResultList().size();
    }

    private int getTaskLogSize(String processId) {
        return this.taskAuditService.auditTaskQuery().processId(new String[]{processId}).build().getResultList().size();
    }

    private int getNodeInstanceLogSize(String processId) {
        return ((NodeInstanceLogQueryBuilder)this.auditLogService.nodeInstanceLogQuery().processId(new String[]{processId})).build().getResultList().size();
    }

    private int getVariableLogSize(String processId) {
        return ((VariableInstanceLogQueryBuilder)this.auditLogService.variableInstanceLogQuery().processId(new String[]{processId})).build().getResultList().size();
    }

    private void scheduleLogCleanup(Date olderThan, String olderThanDuration, Map<String, Object> parameters) {
        CommandContext commandContext = new CommandContext();
        commandContext.setData("EmfName", (Object)"org.jbpm.test.persistence");
        commandContext.setData("SingleRun", (Object)"true");
        commandContext.setData("DateFormat", (Object)this.dateFormat);
        commandContext.setData("OlderThan", (Object)LocalDateTime.now().format(DateTimeFormatter.ofPattern(this.dateFormat)));
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            commandContext.setData(entry.getKey(), entry.getValue());
        }
        this.getExecutorService().scheduleRequest("org.jbpm.casemgmt.impl.audit.CaseLogCleanupCommand", (org.kie.api.executor.CommandContext)commandContext);
    }

    protected DeploymentUnit prepareDeploymentUnit() throws Exception {
        this.identityProvider.setName(USER);
        return this.createAndDeployUnit(GROUP_ID, ARTIFACT_ID, VERSION);
    }

    protected List<String> getProcessDefinitionFiles() {
        return Arrays.asList(LOG_CLEANUP, LOG_INCOMPLETE_CLEANUP);
    }

    protected void registerDefaultListenerMvelDefinitions() {
    }

    public DeploymentUnit createDeploymentUnit(String groupId, String artifactid, String version) throws Exception {
        this.listenerMvelDefinitions.clear();
        KModuleDeploymentUnit deploymentUnit = (KModuleDeploymentUnit)super.createDeploymentUnit(groupId, artifactid, version);
        DeploymentDescriptorImpl descriptor = (DeploymentDescriptorImpl)deploymentUnit.getDeploymentDescriptor();
        descriptor.setPersistenceUnit(this.getPersistenceUnitName());
        descriptor.setAuditPersistenceUnit(this.getPersistenceUnitName());
        return deploymentUnit;
    }
}

