/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import bitronix.tm.BitronixTransaction;
import bitronix.tm.TransactionManagerServices;
import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.transaction.SystemException;
import junit.framework.Assert;
import org.drools.ClockType;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.SystemEventListenerFactory;
import org.drools.audit.WorkingMemoryInMemoryLogger;
import org.drools.audit.event.LogEvent;
import org.drools.audit.event.RuleFlowNodeLogEvent;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderError;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.definition.process.Node;
import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.impl.EnvironmentFactory;
import org.drools.io.ResourceFactory;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.runtime.Environment;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.conf.ClockTypeOption;
import org.drools.runtime.conf.KnowledgeSessionOption;
import org.drools.runtime.process.NodeInstance;
import org.drools.runtime.process.NodeInstanceContainer;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.jbpm.process.audit.JPAProcessInstanceDbLog;
import org.jbpm.process.audit.JPAWorkingMemoryDbLogger;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.workitem.wsht.SyncWSHumanTaskHandler;
import org.jbpm.task.TaskService;
import org.jbpm.task.service.TaskServiceSession;
import org.jbpm.task.service.local.LocalTaskService;
import org.jbpm.test.JBPMHelper;
import org.jbpm.test.KnowledgeSessionCleanup;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JbpmJUnitTestCase
extends Assert {
    protected static final String EOL = System.getProperty("line.separator");
    private boolean setupDataSource = false;
    private boolean sessionPersistence = false;
    private EntityManagerFactory emf;
    private PoolingDataSource ds;
    private H2Server server = new H2Server();
    private org.jbpm.task.service.TaskService taskService;
    private TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
    private WorkingMemoryInMemoryLogger logger;
    private JPAProcessInstanceDbLog log;
    private Logger testLogger = null;
    @Rule
    public KnowledgeSessionCleanup ksessionCleanupRule = new KnowledgeSessionCleanup();
    protected static ThreadLocal<Set<StatefulKnowledgeSession>> knowledgeSessionSetLocal = KnowledgeSessionCleanup.knowledgeSessionSetLocal;
    @Rule
    public TestName testName = new TestName();

    public JbpmJUnitTestCase() {
        this(false);
    }

    public JbpmJUnitTestCase(boolean setupDataSource) {
        System.setProperty("jbpm.usergroup.callback", "org.jbpm.task.service.DefaultUserGroupCallbackImpl");
        this.setupDataSource = setupDataSource;
    }

    public static PoolingDataSource setupPoolingDataSource() {
        PoolingDataSource pds = new PoolingDataSource();
        pds.setUniqueName("jdbc/jbpm-ds");
        pds.setClassName("bitronix.tm.resource.jdbc.lrc.LrcXADataSource");
        pds.setMaxPoolSize(5);
        pds.setAllowLocalTransactions(true);
        pds.getDriverProperties().put("user", "sa");
        pds.getDriverProperties().put("password", "");
        pds.getDriverProperties().put("url", "jdbc:h2:tcp://localhost/~/jbpm-db");
        pds.getDriverProperties().put("driverClassName", "org.h2.Driver");
        pds.init();
        return pds;
    }

    public void setPersistence(boolean sessionPersistence) {
        this.sessionPersistence = sessionPersistence;
    }

    public boolean isPersistence() {
        return this.sessionPersistence;
    }

    @Before
    public void setUp() throws Exception {
        if (this.testLogger == null) {
            this.testLogger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        }
        if (this.setupDataSource) {
            this.server.start();
            this.ds = JbpmJUnitTestCase.setupPoolingDataSource();
            this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.setupDataSource) {
            int testTxState;
            this.taskService = null;
            if (this.emf != null) {
                this.emf.close();
                this.emf = null;
            }
            if (this.ds != null) {
                this.ds.close();
                this.ds = null;
            }
            this.server.stop();
            DeleteDbFiles.execute((String)"~", (String)"jbpm-db", (boolean)true);
            BitronixTransaction tx = TransactionManagerServices.getTransactionManager().getCurrentTransaction();
            if (tx != null && (testTxState = tx.getStatus()) != 6 && testTxState != 4 && testTxState != 3) {
                try {
                    tx.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Assert.fail((String)("Transaction had status " + JBPMHelper.txStateName[testTxState] + " at the end of the test."));
            }
        }
    }

    protected KnowledgeBase createKnowledgeBase(String ... process) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (String p : process) {
            kbuilder.add(ResourceFactory.newClassPathResource((String)p), ResourceType.BPMN2);
        }
        if (kbuilder.hasErrors() && kbuilder.getErrors().size() > 0) {
            boolean errors = false;
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                this.testLogger.warn(error.toString());
                errors = true;
            }
            JbpmJUnitTestCase.assertFalse((String)"Could not build knowldge base.", (boolean)errors);
        }
        return kbuilder.newKnowledgeBase();
    }

    protected KnowledgeBase createKnowledgeBase(Map<String, ResourceType> resources) throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        for (Map.Entry<String, ResourceType> entry : resources.entrySet()) {
            kbuilder.add(ResourceFactory.newClassPathResource((String)entry.getKey()), entry.getValue());
        }
        return kbuilder.newKnowledgeBase();
    }

    protected KnowledgeBase createKnowledgeBaseGuvnor(String ... packages) throws Exception {
        return this.createKnowledgeBaseGuvnor(false, "http://localhost:8080/drools-guvnor", "admin", "admin", packages);
    }

    protected KnowledgeBase createKnowledgeBaseGuvnorAssets(String pkg, String ... assets) throws Exception {
        return this.createKnowledgeBaseGuvnor(false, "http://localhost:8080/drools-guvnor", "admin", "admin", pkg, assets);
    }

    protected KnowledgeBase createKnowledgeBaseGuvnor(boolean dynamic, String url, String username, String password, String pkg, String ... assets) throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        String changeSet = "<change-set xmlns='http://drools.org/drools-5.0/change-set'" + EOL + "            xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'" + EOL + "            xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >" + EOL + "    <add>" + EOL;
        for (String a : assets) {
            if (a.indexOf(".bpmn") >= 0) {
                a = a.substring(0, a.indexOf(".bpmn"));
            }
            changeSet = changeSet + "        <resource source='" + url + "/rest/packages/" + pkg + "/assets/" + a + "/binary' type='BPMN2' basicAuthentication=\"enabled\" username=\"" + username + "\" password=\"" + password + "\" />" + EOL;
        }
        changeSet = changeSet + "    </add>" + EOL + "</change-set>";
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])changeSet.getBytes()), ResourceType.CHANGE_SET);
        return kbuilder.newKnowledgeBase();
    }

    protected KnowledgeBase createKnowledgeBaseGuvnor(boolean dynamic, String url, String username, String password, String ... packages) throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        String changeSet = "<change-set xmlns='http://drools.org/drools-5.0/change-set'" + EOL + "            xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'" + EOL + "            xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >" + EOL + "    <add>" + EOL;
        for (String p : packages) {
            changeSet = changeSet + "        <resource source='" + url + "/rest/packages/" + p + "/binary' type='PKG' basicAuthentication=\"enabled\" username=\"" + username + "\" password=\"" + password + "\" />" + EOL;
        }
        changeSet = changeSet + "    </add>" + EOL + "</change-set>";
        kbuilder.add(ResourceFactory.newByteArrayResource((byte[])changeSet.getBytes()), ResourceType.CHANGE_SET);
        return kbuilder.newKnowledgeBase();
    }

    protected StatefulKnowledgeSession createKnowledgeSession(KnowledgeBase kbase) {
        StatefulKnowledgeSession result;
        KnowledgeSessionConfiguration conf = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        if (this.sessionPersistence) {
            Environment env = JBPMHelper.createEnvironment(this.emf);
            result = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, (KnowledgeSessionConfiguration)conf, (Environment)env);
            new JPAWorkingMemoryDbLogger((KnowledgeRuntimeEventManager)result);
            if (this.log == null) {
                this.log = new JPAProcessInstanceDbLog(result.getEnvironment());
            }
        } else {
            Environment env = EnvironmentFactory.newEnvironment();
            env.set("drools.persistence.jpa.EntityManagerFactory", (Object)this.emf);
            result = kbase.newStatefulKnowledgeSession(conf, env);
            this.logger = new WorkingMemoryInMemoryLogger((KnowledgeRuntimeEventManager)result);
        }
        knowledgeSessionSetLocal.get().add(result);
        return result;
    }

    protected StatefulKnowledgeSession createKnowledgeSession(String ... process) {
        KnowledgeBase kbase = this.createKnowledgeBase(process);
        return this.createKnowledgeSession(kbase);
    }

    protected StatefulKnowledgeSession restoreSession(StatefulKnowledgeSession ksession, boolean noCache) throws SystemException {
        if (this.sessionPersistence) {
            int id = ksession.getId();
            KnowledgeBase kbase = ksession.getKnowledgeBase();
            BitronixTransaction tx = TransactionManagerServices.getTransactionManager().getCurrentTransaction();
            if (tx != null) {
                int txStatus = tx.getStatus();
                JbpmJUnitTestCase.assertTrue((String)("Current transaction state is " + JBPMHelper.txStateName[txStatus]), (tx.getStatus() == 6 ? 1 : 0) != 0);
            }
            Environment env = null;
            if (noCache) {
                this.emf.close();
                env = EnvironmentFactory.newEnvironment();
                this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
                env.set("drools.persistence.jpa.EntityManagerFactory", (Object)this.emf);
                env.set("drools.transaction.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
                this.log = new JPAProcessInstanceDbLog(env);
                this.taskService = null;
            } else {
                env = ksession.getEnvironment();
                this.taskService = null;
            }
            KnowledgeSessionConfiguration config = ksession.getSessionConfiguration();
            ksession.dispose();
            ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, (KnowledgeSessionConfiguration)config, (Environment)env);
            KnowledgeSessionCleanup.knowledgeSessionSetLocal.get().add(ksession);
            new JPAWorkingMemoryDbLogger((KnowledgeRuntimeEventManager)ksession);
            return ksession;
        }
        return ksession;
    }

    public StatefulKnowledgeSession loadSession(int id, String ... process) {
        KnowledgeBase kbase = this.createKnowledgeBase(process);
        KnowledgeSessionConfiguration config = KnowledgeBaseFactory.newKnowledgeSessionConfiguration();
        config.setOption((KnowledgeSessionOption)ClockTypeOption.get((String)ClockType.PSEUDO_CLOCK.getId()));
        StatefulKnowledgeSession ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)id, (KnowledgeBase)kbase, (KnowledgeSessionConfiguration)config, (Environment)JBPMHelper.createEnvironment(this.emf));
        KnowledgeSessionCleanup.knowledgeSessionSetLocal.get().add(ksession);
        new JPAWorkingMemoryDbLogger((KnowledgeRuntimeEventManager)ksession);
        return ksession;
    }

    public Object getVariableValue(String name, long processInstanceId, StatefulKnowledgeSession ksession) {
        return ((WorkflowProcessInstance)ksession.getProcessInstance(processInstanceId)).getVariable(name);
    }

    public void assertProcessInstanceCompleted(long processInstanceId, StatefulKnowledgeSession ksession) {
        JbpmJUnitTestCase.assertNull((Object)ksession.getProcessInstance(processInstanceId));
    }

    public void assertProcessInstanceAborted(long processInstanceId, StatefulKnowledgeSession ksession) {
        JbpmJUnitTestCase.assertNull((Object)ksession.getProcessInstance(processInstanceId));
    }

    public void assertProcessInstanceActive(long processInstanceId, StatefulKnowledgeSession ksession) {
        JbpmJUnitTestCase.assertNotNull((Object)ksession.getProcessInstance(processInstanceId));
    }

    public void assertNodeActive(long processInstanceId, StatefulKnowledgeSession ksession, String ... name) {
        ArrayList<String> names = new ArrayList<String>();
        for (String n : name) {
            names.add(n);
        }
        ProcessInstance processInstance = ksession.getProcessInstance(processInstanceId);
        if (processInstance instanceof WorkflowProcessInstance) {
            this.assertNodeActive((NodeInstanceContainer)((WorkflowProcessInstance)processInstance), names);
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            JbpmJUnitTestCase.fail((String)("Node(s) not active: " + s));
        }
    }

    private void assertNodeActive(NodeInstanceContainer container, List<String> names) {
        for (NodeInstance nodeInstance : container.getNodeInstances()) {
            String nodeName = nodeInstance.getNodeName();
            if (names.contains(nodeName)) {
                names.remove(nodeName);
            }
            if (!(nodeInstance instanceof NodeInstanceContainer)) continue;
            this.assertNodeActive((NodeInstanceContainer)nodeInstance, names);
        }
    }

    public void assertNodeTriggered(long processInstanceId, String ... nodeNames) {
        ArrayList<String> names = new ArrayList<String>();
        for (String nodeName : nodeNames) {
            names.add(nodeName);
        }
        if (this.sessionPersistence) {
            List logs = this.log.findNodeInstances(processInstanceId);
            if (logs != null) {
                for (NodeInstanceLog l : logs) {
                    String nodeName;
                    nodeName = l.getNodeName();
                    if (l.getType() != 0 || !names.contains(nodeName)) continue;
                    names.remove(nodeName);
                }
            }
        } else {
            for (LogEvent event : this.logger.getLogEvents()) {
                String nodeName;
                if (!(event instanceof RuleFlowNodeLogEvent) || !names.contains(nodeName = ((RuleFlowNodeLogEvent)event).getNodeName())) continue;
                names.remove(nodeName);
            }
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            JbpmJUnitTestCase.fail((String)("Node(s) not executed: " + s));
        }
    }

    protected void clearHistory() {
        if (this.sessionPersistence) {
            if (this.log == null) {
                this.log = new JPAProcessInstanceDbLog();
            }
            this.log.clear();
        } else {
            this.logger.clear();
        }
    }

    public TestWorkItemHandler getTestWorkItemHandler() {
        return this.workItemHandler;
    }

    public void assertProcessVarExists(ProcessInstance process, String ... processVarNames) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        ArrayList<String> names = new ArrayList<String>();
        for (String nodeName : processVarNames) {
            names.add(nodeName);
        }
        for (String pvar : instance.getVariables().keySet()) {
            if (!names.contains(pvar)) continue;
            names.remove(pvar);
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            JbpmJUnitTestCase.fail((String)("Process Variable(s) do not exist: " + s));
        }
    }

    public void assertNodeExists(ProcessInstance process, String ... nodeNames) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        ArrayList<String> names = new ArrayList<String>();
        for (String string : nodeNames) {
            names.add(string);
        }
        for (String string : instance.getNodeContainer().getNodes()) {
            if (!names.contains(string.getName())) continue;
            names.remove(string.getName());
        }
        if (!names.isEmpty()) {
            String s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = s + ", " + (String)names.get(i);
            }
            JbpmJUnitTestCase.fail((String)("Node(s) do not exist: " + s));
        }
    }

    public void assertNumOfIncommingConnections(ProcessInstance process, String nodeName, int num) {
        this.assertNodeExists(process, nodeName);
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        for (Node node : instance.getNodeContainer().getNodes()) {
            if (!node.getName().equals(nodeName)) continue;
            if (node.getIncomingConnections().size() == num) break;
            JbpmJUnitTestCase.fail((String)("Expected incomming connections: " + num + " - found " + node.getIncomingConnections().size()));
        }
    }

    public void assertNumOfOutgoingConnections(ProcessInstance process, String nodeName, int num) {
        this.assertNodeExists(process, nodeName);
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        for (Node node : instance.getNodeContainer().getNodes()) {
            if (!node.getName().equals(nodeName)) continue;
            if (node.getOutgoingConnections().size() == num) break;
            JbpmJUnitTestCase.fail((String)("Expected outgoing connections: " + num + " - found " + node.getOutgoingConnections().size()));
        }
    }

    public void assertVersionEquals(ProcessInstance process, String version) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getVersion().equals(version)) {
            JbpmJUnitTestCase.fail((String)("Expected version: " + version + " - found " + instance.getWorkflowProcess().getVersion()));
        }
    }

    public void assertProcessNameEquals(ProcessInstance process, String name) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getName().equals(name)) {
            JbpmJUnitTestCase.fail((String)("Expected name: " + name + " - found " + instance.getWorkflowProcess().getName()));
        }
    }

    public void assertPackageNameEquals(ProcessInstance process, String packageName) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getPackageName().equals(packageName)) {
            JbpmJUnitTestCase.fail((String)("Expected package name: " + packageName + " - found " + instance.getWorkflowProcess().getPackageName()));
        }
    }

    public TaskService getTaskService(StatefulKnowledgeSession ksession) {
        if (this.taskService == null) {
            this.taskService = new org.jbpm.task.service.TaskService(this.emf, SystemEventListenerFactory.getSystemEventListener());
        }
        TaskServiceSession taskServiceSession = this.taskService.createSession();
        taskServiceSession.setTransactionType("local-JTA");
        SyncWSHumanTaskHandler humanTaskHandler = new SyncWSHumanTaskHandler((TaskService)new LocalTaskService(taskServiceSession), (KnowledgeRuntime)ksession);
        humanTaskHandler.setLocal(true);
        humanTaskHandler.connect();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)humanTaskHandler);
        return new LocalTaskService(taskServiceSession);
    }

    public org.jbpm.task.service.TaskService getService() {
        return new org.jbpm.task.service.TaskService(this.emf, SystemEventListenerFactory.getSystemEventListener());
    }

    private static class H2Server {
        private Server server;

        private H2Server() {
        }

        public synchronized void start() {
            if (this.server == null || !this.server.isRunning(false)) {
                try {
                    DeleteDbFiles.execute((String)"~", (String)"jbpm-db", (boolean)true);
                    this.server = Server.createTcpServer((String[])new String[0]);
                    this.server.start();
                }
                catch (SQLException e) {
                    throw new RuntimeException("Cannot start h2 server database", e);
                }
            }
        }

        public synchronized void finalize() throws Throwable {
            this.stop();
            super.finalize();
        }

        public void stop() {
            if (this.server != null) {
                this.server.stop();
                this.server.shutdown();
                DeleteDbFiles.execute((String)"~", (String)"jbpm-db", (boolean)true);
                this.server = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestWorkItemHandler
    implements WorkItemHandler {
        private List<WorkItem> workItems = new ArrayList<WorkItem>();

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItems.add(workItem);
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }

        public WorkItem getWorkItem() {
            if (this.workItems.size() == 0) {
                return null;
            }
            if (this.workItems.size() == 1) {
                WorkItem result = this.workItems.get(0);
                this.workItems.clear();
                return result;
            }
            throw new IllegalArgumentException("More than one work item active");
        }

        public List<WorkItem> getWorkItems() {
            ArrayList<WorkItem> result = new ArrayList<WorkItem>(this.workItems);
            this.workItems.clear();
            return result;
        }
    }
}

