/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.session;

import org.drools.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.persistence.SingleSessionCommandService;
import org.jbpm.process.audit.JPAWorkingMemoryDbLogger;
import org.jbpm.process.workitem.wsht.LocalHTWorkItemHandler;
import org.jbpm.session.SynchronizedTaskService;
import org.jbpm.task.TaskService;
import org.jbpm.task.service.local.LocalTaskService;
import org.kie.runtime.StatefulKnowledgeSession;

public class SessionEnvironment {
    private StatefulKnowledgeSession ksession;
    private TaskService taskService;
    private LocalHTWorkItemHandler humanTaskHandler;
    private JPAWorkingMemoryDbLogger historyLogger;

    public SessionEnvironment(StatefulKnowledgeSession ksession, LocalTaskService taskService, LocalHTWorkItemHandler humanTaskHandler, JPAWorkingMemoryDbLogger historyLogger) {
        this.ksession = ksession;
        this.taskService = new SynchronizedTaskService((SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService(), (TaskService)taskService);
        this.humanTaskHandler = humanTaskHandler;
        this.historyLogger = historyLogger;
    }

    public StatefulKnowledgeSession getKnowledgeSession() {
        return this.ksession;
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public void dispose() throws Exception {
        if (this.historyLogger != null) {
            this.historyLogger.dispose();
            this.historyLogger = null;
        }
        System.out.println("Disposing ksession " + this.ksession.getId());
        this.humanTaskHandler.dispose();
        this.humanTaskHandler = null;
        this.taskService.disconnect();
        this.taskService = null;
        this.ksession.dispose();
        this.ksession = null;
    }
}

