/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.session;

import javax.persistence.EntityManagerFactory;
import org.jbpm.process.audit.JPAWorkingMemoryDbLogger;
import org.jbpm.process.workitem.wsht.LocalHTWorkItemHandler;
import org.jbpm.session.SessionEnvironment;
import org.jbpm.task.TaskService;
import org.jbpm.task.service.local.LocalTaskService;
import org.kie.KieBase;
import org.kie.KnowledgeBase;
import org.kie.KnowledgeBaseFactory;
import org.kie.SystemEventListenerFactory;
import org.kie.event.KnowledgeRuntimeEventManager;
import org.kie.persistence.jpa.JPAKnowledgeService;
import org.kie.runtime.Environment;
import org.kie.runtime.KnowledgeRuntime;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.WorkItemHandler;

public class StatefulKnowledgeSessionFactory {
    private EntityManagerFactory emf;
    private KnowledgeBase kbase;
    private boolean useHistoryLogger = true;

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public void setKnowledgeBase(KnowledgeBase kbase) {
        this.kbase = kbase;
    }

    public void setUseHistoryLogger(boolean useHistoryLogger) {
        this.useHistoryLogger = useHistoryLogger;
    }

    public SessionEnvironment createStatefulKnowledgeSession() {
        Environment env = KnowledgeBaseFactory.newEnvironment();
        env.set("org.kie.persistence.jpa.EntityManagerFactory", (Object)this.emf);
        StatefulKnowledgeSession ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)this.kbase, null, (Environment)env);
        JPAWorkingMemoryDbLogger historyLogger = null;
        if (this.useHistoryLogger) {
            historyLogger = new JPAWorkingMemoryDbLogger((KnowledgeRuntimeEventManager)ksession);
        }
        org.jbpm.task.service.TaskService internalTaskService = new org.jbpm.task.service.TaskService(this.emf, SystemEventListenerFactory.getSystemEventListener());
        LocalTaskService taskService = new LocalTaskService(internalTaskService);
        LocalHTWorkItemHandler humanTaskHandler = new LocalHTWorkItemHandler((TaskService)taskService, (KnowledgeRuntime)ksession);
        humanTaskHandler.connect();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)humanTaskHandler);
        System.out.println("Created ksession " + ksession.getId());
        return new SessionEnvironment(ksession, taskService, humanTaskHandler, historyLogger);
    }
}

