/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import bitronix.tm.TransactionManagerServices;
import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.util.HashMap;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.impl.EnvironmentFactory;
import org.h2.tools.Server;
import org.jbpm.process.workitem.wsht.HornetQHTWorkItemHandler;
import org.jbpm.process.workitem.wsht.MinaHTWorkItemHandler;
import org.jbpm.task.service.TaskService;
import org.jbpm.task.service.hornetq.HornetQTaskServer;
import org.jbpm.task.service.mina.MinaTaskServer;
import org.jbpm.test.KnowledgeSessionCleanup;
import org.kie.KieBase;
import org.kie.KnowledgeBase;
import org.kie.SystemEventListenerFactory;
import org.kie.persistence.jpa.JPAKnowledgeService;
import org.kie.runtime.Environment;
import org.kie.runtime.KnowledgeRuntime;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.WorkItemHandler;

public final class JBPMHelper {
    public static String[] processStateName = new String[]{"PENDING", "ACTIVE", "COMPLETED", "ABORTED", "SUSPENDED"};
    public static String[] txStateName = new String[]{"ACTIVE", "MARKED_ROLLBACK", "PREPARED", "COMMITTED", "ROLLEDBACK", "UNKNOWN", "NO_TRANSACTION", "PREPARING", "COMMITTING", "ROLLING_BACK"};

    private JBPMHelper() {
    }

    public static void startUp() {
        Properties properties = JBPMHelper.getProperties();
        String driverClassName = properties.getProperty("persistence.datasource.driverClassName", "org.h2.Driver");
        if (driverClassName.startsWith("org.h2")) {
            JBPMHelper.startH2Server();
        }
        String persistenceEnabled = properties.getProperty("persistence.enabled", "false");
        String humanTaskEnabled = properties.getProperty("taskservice.enabled", "false");
        if ("true".equals(persistenceEnabled) || "true".equals(humanTaskEnabled)) {
            JBPMHelper.setupDataSource();
        }
        if ("true".equals(humanTaskEnabled)) {
            JBPMHelper.startTaskService();
        }
    }

    public static Server startH2Server() {
        try {
            Server server = Server.createTcpServer((String[])new String[0]);
            server.start();
            return server;
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not start H2 server", t);
        }
    }

    public static PoolingDataSource setupDataSource() {
        Properties properties = JBPMHelper.getProperties();
        PoolingDataSource pds = new PoolingDataSource();
        pds.setUniqueName(properties.getProperty("persistence.datasource.name", "jdbc/jbpm-ds"));
        pds.setClassName("bitronix.tm.resource.jdbc.lrc.LrcXADataSource");
        pds.setMaxPoolSize(5);
        pds.setAllowLocalTransactions(true);
        pds.getDriverProperties().put("user", properties.getProperty("persistence.datasource.user", "sa"));
        pds.getDriverProperties().put("password", properties.getProperty("persistence.datasource.password", ""));
        pds.getDriverProperties().put("url", properties.getProperty("persistence.datasource.url", "jdbc:h2:tcp://localhost/~/jbpm-db;MVCC=TRUE"));
        pds.getDriverProperties().put("driverClassName", properties.getProperty("persistence.datasource.driverClassName", "org.h2.Driver"));
        pds.init();
        return pds;
    }

    public static TaskService startTaskService() {
        Properties properties = JBPMHelper.getProperties();
        String dialect = properties.getProperty("persistence.persistenceunit.dialect", "org.hibernate.dialect.H2Dialect");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hibernate.dialect", dialect);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)properties.getProperty("taskservice.datasource.name", "org.jbpm.task"), map);
        System.setProperty("jbpm.user.group.mapping", properties.getProperty("taskservice.usergroupmapping", "classpath:/usergroups.properties"));
        System.setProperty("jbpm.usergroup.callback", properties.getProperty("taskservice.usergroupcallback", "org.jbpm.task.identity.DefaultUserGroupCallbackImpl"));
        TaskService taskService = new TaskService(emf, SystemEventListenerFactory.getSystemEventListener());
        String transport = properties.getProperty("taskservice.transport", "mina");
        if ("mina".equals(transport)) {
            MinaTaskServer taskServer = new MinaTaskServer(taskService);
            Thread thread = new Thread((Runnable)taskServer);
            thread.start();
        } else if ("hornetq".equals(transport)) {
            HornetQTaskServer taskServer = new HornetQTaskServer(taskService, Integer.parseInt(properties.getProperty("taskservice.port", "5153")));
            Thread thread = new Thread((Runnable)taskServer);
            thread.start();
        } else {
            throw new RuntimeException("Unknown task service transport " + transport);
        }
        return taskService;
    }

    public static void registerTaskService(StatefulKnowledgeSession ksession) {
        Properties properties = JBPMHelper.getProperties();
        String transport = properties.getProperty("taskservice.transport", "hornetq");
        if ("mina".equals(transport)) {
            ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new MinaHTWorkItemHandler((KnowledgeRuntime)ksession));
        } else if ("hornetq".equals(transport)) {
            ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new HornetQHTWorkItemHandler((KnowledgeRuntime)ksession));
        } else {
            throw new RuntimeException("Unknown task service transport " + transport);
        }
    }

    protected static Environment createEnvironment(EntityManagerFactory emf) {
        Environment env = EnvironmentFactory.newEnvironment();
        env.set("org.kie.persistence.jpa.EntityManagerFactory", (Object)emf);
        env.set("org.kie.transaction.TransactionManager", (Object)TransactionManagerServices.getTransactionManager());
        return env;
    }

    public static StatefulKnowledgeSession newStatefulKnowledgeSession(KnowledgeBase kbase) {
        return JBPMHelper.loadStatefulKnowledgeSession(kbase, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatefulKnowledgeSession loadStatefulKnowledgeSession(KnowledgeBase kbase, int sessionId) {
        StatefulKnowledgeSession ksession;
        Properties properties = JBPMHelper.getProperties();
        String persistenceEnabled = properties.getProperty("persistence.enabled", "false");
        if ("true".equals(persistenceEnabled)) {
            String dialect = properties.getProperty("persistence.persistenceunit.dialect", "org.hibernate.dialect.H2Dialect");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("hibernate.dialect", dialect);
            EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)properties.getProperty("persistence.persistenceunit.name", "org.jbpm.persistence.jpa"), map);
            Environment env = JBPMHelper.createEnvironment(emf);
            ksession = sessionId == -1 ? JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env) : JPAKnowledgeService.loadStatefulKnowledgeSession((int)sessionId, (KieBase)kbase, null, (Environment)env);
            String humanTaskEnabled = properties.getProperty("taskservice.enabled", "false");
            if ("true".equals(humanTaskEnabled)) {
                String transport = properties.getProperty("taskservice.transport", "hornetq");
                if ("mina".equals(transport)) {
                    ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new MinaHTWorkItemHandler((KnowledgeRuntime)ksession));
                } else {
                    if (!"hornetq".equals(transport)) throw new RuntimeException("Unknown task service transport " + transport);
                    ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new HornetQHTWorkItemHandler((KnowledgeRuntime)ksession));
                }
            }
        } else {
            ksession = kbase.newStatefulKnowledgeSession();
            String humanTaskEnabled = properties.getProperty("taskservice.enabled", "false");
            if ("true".equals(humanTaskEnabled)) {
                String transport = properties.getProperty("taskservice.transport", "hornetq");
                if ("mina".equals(transport)) {
                    ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new MinaHTWorkItemHandler((KnowledgeRuntime)ksession));
                } else {
                    if (!"hornetq".equals(transport)) throw new RuntimeException("Unknown task service transport " + transport);
                    ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new HornetQHTWorkItemHandler((KnowledgeRuntime)ksession));
                }
            }
        }
        KnowledgeSessionCleanup.knowledgeSessionSetLocal.get().add(ksession);
        return ksession;
    }

    public static Properties getProperties() {
        Properties properties = new Properties();
        try {
            properties.load(JBPMHelper.class.getResourceAsStream("/jBPM.properties"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return properties;
    }
}

