/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.session;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.session.SessionEnvironment;
import org.jbpm.session.SessionManager;
import org.jbpm.session.SessionManagerFactory;
import org.jbpm.session.SingletonSessionManager;
import org.jbpm.session.StatefulKnowledgeSessionFactory;
import org.kie.KnowledgeBase;

public class SingletonSessionManagerFactory
implements SessionManagerFactory {
    private EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
    private SessionEnvironment sessionEnvironment;

    public SingletonSessionManagerFactory(KnowledgeBase kbase) {
        StatefulKnowledgeSessionFactory factory = new StatefulKnowledgeSessionFactory();
        factory.setEntityManagerFactory(this.emf);
        factory.setKnowledgeBase(kbase);
        this.sessionEnvironment = factory.createStatefulKnowledgeSession();
    }

    @Override
    public SessionManager getSessionManager() {
        return new SingletonSessionManager(this.sessionEnvironment);
    }

    @Override
    public SessionManager getSessionManager(String context) {
        throw new UnsupportedOperationException("When using one singleton session, no context object is required, use getSessionManager().");
    }

    @Override
    public void dispose() throws Exception {
        this.sessionEnvironment.dispose();
        this.emf.close();
    }
}

