/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.persistence;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.services.task.admin.listener.TaskCleanUpProcessEventListener;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.InternalTaskService;

@RunWith(value=Parameterized.class)
public class CallActivitiesWithUserTasksProcessTest
extends JbpmJUnitBaseTestCase {
    private final boolean userManagedTx;
    private final JbpmJUnitBaseTestCase.Strategy strategy;

    @Parameterized.Parameters(name="{1} | user managed={0}")
    public static Collection<Object[]> parameters() {
        Object[][] locking = new Object[][]{{true, JbpmJUnitBaseTestCase.Strategy.SINGLETON}, {true, JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE}, {false, JbpmJUnitBaseTestCase.Strategy.SINGLETON}, {false, JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE}};
        return Arrays.asList(locking);
    }

    public CallActivitiesWithUserTasksProcessTest(boolean txManagedType, JbpmJUnitBaseTestCase.Strategy runtimeStrategy) {
        super(true, true);
        this.userManagedTx = txManagedType;
        this.strategy = runtimeStrategy;
    }

    @Test
    public void testCallActivitiesWithUserTasks() throws Exception {
        RuntimeEngine runtimeEngine;
        TaskCleanUpProcessEventListener taskListener = new TaskCleanUpProcessEventListener(null);
        this.addWorkItemHandler("Sysout", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.addProcessEventListener((ProcessEventListener)taskListener);
        InitialContext context = new InitialContext();
        UserTransaction ut = (UserTransaction)context.lookup("java:comp/UserTransaction");
        RuntimeManager manager = this.createRuntimeManager(this.strategy, null, new String[]{"BPMN2-CallActivityWithTask-Main.bpmn2", "BPMN2-CallActivityWithTask-Sub.bpmn2"});
        if (JbpmJUnitBaseTestCase.Strategy.SINGLETON.equals((Object)this.strategy)) {
            runtimeEngine = this.getRuntimeEngine();
        } else if (JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE.equals((Object)this.strategy)) {
            runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        } else {
            throw new IllegalStateException("Not possible!");
        }
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        taskListener.setTaskService((InternalTaskService)taskService);
        if (this.userManagedTx) {
            ut.begin();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pActorId", "john");
        ProcessInstance processInstance = ksession.startProcess("PolicyValueAnalysis", params);
        if (this.userManagedTx) {
            ut.commit();
            manager.disposeRuntimeEngine(runtimeEngine);
            runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            ksession = runtimeEngine.getKieSession();
            taskService = runtimeEngine.getTaskService();
            taskListener.setTaskService((InternalTaskService)taskService);
            ut.begin();
        } else {
            manager.disposeRuntimeEngine(runtimeEngine);
            runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            ksession = runtimeEngine.getKieSession();
            taskService = runtimeEngine.getTaskService();
            taskListener.setTaskService((InternalTaskService)taskService);
        }
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        CallActivitiesWithUserTasksProcessTest.assertNotNull((Object)tasks);
        CallActivitiesWithUserTasksProcessTest.assertEquals((long)1L, (long)tasks.size());
        Long taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId.longValue(), "john");
        taskService.complete(taskId.longValue(), "john", null);
        if (this.userManagedTx) {
            ut.commit();
            manager.disposeRuntimeEngine(runtimeEngine);
            runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            ksession = runtimeEngine.getKieSession();
            taskService = runtimeEngine.getTaskService();
            taskListener.setTaskService((InternalTaskService)taskService);
            ut.begin();
        } else {
            manager.disposeRuntimeEngine(runtimeEngine);
            runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            ksession = runtimeEngine.getKieSession();
            taskService = runtimeEngine.getTaskService();
            taskListener.setTaskService((InternalTaskService)taskService);
        }
        tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        CallActivitiesWithUserTasksProcessTest.assertNotNull((Object)tasks);
        CallActivitiesWithUserTasksProcessTest.assertEquals((long)1L, (long)tasks.size());
        taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId.longValue(), "john");
        taskService.complete(taskId.longValue(), "john", null);
        if (this.userManagedTx) {
            ut.commit();
            ut.begin();
        }
        this.assertProcessInstanceCompleted(processInstance.getId());
        if (this.userManagedTx) {
            ut.commit();
        }
    }

    @Test
    public void testCallActivitiesWith2ndUserTaskInSub() throws Exception {
        RuntimeEngine runtimeEngine;
        TaskCleanUpProcessEventListener taskListener = new TaskCleanUpProcessEventListener(null);
        this.addWorkItemHandler("Sysout", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.addProcessEventListener((ProcessEventListener)taskListener);
        InitialContext context = new InitialContext();
        UserTransaction ut = (UserTransaction)context.lookup("java:comp/UserTransaction");
        RuntimeManager manager = this.createRuntimeManager(this.strategy, null, new String[]{"BPMN2-CallActivityWithTaskInSub-Main.bpmn2", "BPMN2-CallActivityWithTaskInSub-Sub.bpmn2"});
        if (JbpmJUnitBaseTestCase.Strategy.SINGLETON.equals((Object)this.strategy)) {
            runtimeEngine = this.getRuntimeEngine();
        } else if (JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE.equals((Object)this.strategy)) {
            runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        } else {
            throw new IllegalStateException("Not possible!");
        }
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        taskListener.setTaskService((InternalTaskService)taskService);
        if (this.userManagedTx) {
            ut.begin();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pActorId", "john");
        ProcessInstance processInstance = ksession.startProcess("PolicyValueAnalysis", params);
        if (this.userManagedTx) {
            ut.commit();
            manager.disposeRuntimeEngine(runtimeEngine);
            runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            ksession = runtimeEngine.getKieSession();
            taskService = runtimeEngine.getTaskService();
            taskListener.setTaskService((InternalTaskService)taskService);
            ut.begin();
        } else {
            manager.disposeRuntimeEngine(runtimeEngine);
            runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            ksession = runtimeEngine.getKieSession();
            taskService = runtimeEngine.getTaskService();
            taskListener.setTaskService((InternalTaskService)taskService);
        }
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        CallActivitiesWithUserTasksProcessTest.assertNotNull((Object)tasks);
        CallActivitiesWithUserTasksProcessTest.assertEquals((long)1L, (long)tasks.size());
        Long taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId.longValue(), "john");
        taskService.complete(taskId.longValue(), "john", null);
        if (this.userManagedTx) {
            ut.commit();
            manager.disposeRuntimeEngine(runtimeEngine);
            runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            ksession = runtimeEngine.getKieSession();
            taskService = runtimeEngine.getTaskService();
            taskListener.setTaskService((InternalTaskService)taskService);
            ut.begin();
        } else {
            manager.disposeRuntimeEngine(runtimeEngine);
            runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            ksession = runtimeEngine.getKieSession();
            taskService = runtimeEngine.getTaskService();
            taskListener.setTaskService((InternalTaskService)taskService);
        }
        tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        CallActivitiesWithUserTasksProcessTest.assertNotNull((Object)tasks);
        CallActivitiesWithUserTasksProcessTest.assertEquals((long)1L, (long)tasks.size());
        taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId.longValue(), "john");
        taskService.complete(taskId.longValue(), "john", null);
        if (this.userManagedTx) {
            ut.commit();
            manager.disposeRuntimeEngine(runtimeEngine);
            runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            ksession = runtimeEngine.getKieSession();
            taskService = runtimeEngine.getTaskService();
            taskListener.setTaskService((InternalTaskService)taskService);
            ut.begin();
        } else {
            manager.disposeRuntimeEngine(runtimeEngine);
            runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            ksession = runtimeEngine.getKieSession();
            taskService = runtimeEngine.getTaskService();
            taskListener.setTaskService((InternalTaskService)taskService);
        }
        tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        CallActivitiesWithUserTasksProcessTest.assertNotNull((Object)tasks);
        CallActivitiesWithUserTasksProcessTest.assertEquals((long)1L, (long)tasks.size());
        taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId.longValue(), "john");
        taskService.complete(taskId.longValue(), "john", null);
        if (this.userManagedTx) {
            ut.commit();
            manager.disposeRuntimeEngine(runtimeEngine);
            runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            ksession = runtimeEngine.getKieSession();
            taskService = runtimeEngine.getTaskService();
            taskListener.setTaskService((InternalTaskService)taskService);
            ut.begin();
        } else {
            manager.disposeRuntimeEngine(runtimeEngine);
            runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            ksession = runtimeEngine.getKieSession();
            taskService = runtimeEngine.getTaskService();
            taskListener.setTaskService((InternalTaskService)taskService);
        }
        tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        CallActivitiesWithUserTasksProcessTest.assertNotNull((Object)tasks);
        CallActivitiesWithUserTasksProcessTest.assertEquals((long)1L, (long)tasks.size());
        taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId.longValue(), "john");
        taskService.complete(taskId.longValue(), "john", null);
        if (this.userManagedTx) {
            this.assertProcessInstanceActive(processInstance.getId());
            ut.commit();
        }
        this.assertProcessInstanceCompleted(processInstance.getId());
    }
}

