/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.tasks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.jbpm.services.task.wih.ExternalTaskEventListener;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.TaskSummary;
import org.kie.api.task.model.User;
import org.kie.internal.event.KnowledgeRuntimeEventManager;
import org.kie.internal.logger.KnowledgeRuntimeLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTasksServiceTest
extends JbpmJUnitBaseTestCase {
    private static final Logger logger = LoggerFactory.getLogger(LocalTasksServiceTest.class);
    private EntityManagerFactory emfTasks;
    protected Map<String, User> users;
    protected Map<String, Group> groups;
    protected Properties conf;
    protected ExternalTaskEventListener externalTaskEventListener;

    public LocalTasksServiceTest() {
        super(true, true);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.emfTasks = Persistence.createEntityManagerFactory((String)"org.jbpm.services.task");
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.emfTasks != null && this.emfTasks.isOpen()) {
            this.emfTasks.close();
        }
    }

    @Test
    public void groupTaskQueryTest() throws Exception {
        this.createRuntimeManager(new String[]{"Evaluation2.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        KnowledgeRuntimeLoggerFactory.newConsoleLogger((KnowledgeRuntimeEventManager)((KnowledgeRuntimeEventManager)ksession));
        logger.info("### Starting process ###");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("employee", "salaboy");
        ProcessInstance process = ksession.startProcess("com.sample.evaluation", parameters);
        long processInstanceId = process.getId();
        Assert.assertEquals((long)1L, (long)process.getState());
        List salaboysTasks = taskService.getTasksAssignedAsPotentialOwner("salaboy", "en-UK");
        Assert.assertEquals((long)1L, (long)salaboysTasks.size());
        taskService.start(((TaskSummary)salaboysTasks.get(0)).getId().longValue(), "salaboy");
        taskService.complete(((TaskSummary)salaboysTasks.get(0)).getId().longValue(), "salaboy", null);
        List pmsTasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)pmsTasks.size());
        List hrsTasks = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        Assert.assertEquals((long)1L, (long)hrsTasks.size());
    }

    @Test
    public void testMultipleActorsClaimedQuery() {
        RuntimeManager manager = this.createRuntimeManager(new String[]{"BPMN2-HumanTaskMultipleActors.bpmn2"});
        RuntimeEngine runtime = this.getRuntimeEngine();
        KieSession ksession = runtime.getKieSession();
        HashMap params = new HashMap();
        ProcessInstance pi = ksession.startProcess("com.sample.humantask.multipleactors", params);
        TaskService taskService = runtime.getTaskService();
        List task1 = taskService.getTasksAssignedAsPotentialOwner("krisv", "en-UK");
        LocalTasksServiceTest.assertNotNull((Object)task1);
        LocalTasksServiceTest.assertEquals((long)1L, (long)task1.size());
        System.out.println("krisv's task:" + ((TaskSummary)task1.get(0)).getName());
        taskService.claim(((TaskSummary)task1.get(0)).getId().longValue(), "krisv");
        List task2 = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        LocalTasksServiceTest.assertNotNull((Object)task2);
        LocalTasksServiceTest.assertEquals((long)0L, (long)task2.size());
        taskService.start(((TaskSummary)task1.get(0)).getId().longValue(), "krisv");
        taskService.complete(((TaskSummary)task1.get(0)).getId().longValue(), "krisv", null);
        this.assertProcessInstanceCompleted(pi.getId());
        manager.disposeRuntimeEngine(runtime);
    }

    @Test
    public void testHumanTaskWithSingleTypeContent() {
        RuntimeManager manager = this.createRuntimeManager(new String[]{"HumanTaskWithSingleTypeContent.bpmn2"});
        RuntimeEngine runtime = this.getRuntimeEngine();
        KieSession ksession = runtime.getKieSession();
        TaskService taskService = runtime.getTaskService();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pVar", "sampleValue");
        ksession.startProcess("com.sample.bpmn.hello1", params);
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        Content content = taskService.getContentById(taskService.getTaskById(task.getId().longValue()).getTaskData().getDocumentContentId());
        byte[] contentbyte = content.getContent();
        Object tmpObject = ContentMarshallerHelper.unmarshall((byte[])contentbyte, (Environment)ksession.getEnvironment());
        LocalTasksServiceTest.assertNotNull((Object)tmpObject);
        LocalTasksServiceTest.assertTrue((boolean)(tmpObject instanceof String));
        LocalTasksServiceTest.assertEquals((Object)"someContent", (Object)tmpObject);
        Map contentMap = taskService.getTaskContent(task.getId().longValue());
        LocalTasksServiceTest.assertNotNull((Object)contentMap);
        LocalTasksServiceTest.assertEquals((long)1L, (long)contentMap.size());
        LocalTasksServiceTest.assertTrue((boolean)contentMap.containsKey("Content"));
        String actualContent = (String)contentMap.get("Content");
        LocalTasksServiceTest.assertNotNull((Object)actualContent);
        LocalTasksServiceTest.assertEquals((Object)"someContent", (Object)actualContent);
        taskService.complete(task.getId().longValue(), "john", null);
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        manager.disposeRuntimeEngine(runtime);
    }
}

