/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.persistence.objects.MedicalRecord;
import org.jbpm.test.persistence.objects.Patient;
import org.jbpm.test.persistence.objects.RecordRow;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatientVariablePersistenceStrategyTest
extends JbpmJUnitBaseTestCase {
    private static final Logger logger = LoggerFactory.getLogger(PatientVariablePersistenceStrategyTest.class);
    private EntityManagerFactory emfDomain;

    public PatientVariablePersistenceStrategyTest() {
        super(true, true);
    }

    @Test
    public void simplePatientMedicalRecordTest() throws Exception {
        Patient salaboy = new Patient("salaboy");
        MedicalRecord medicalRecord = new MedicalRecord("Last Three Years Medical Hisotry", salaboy);
        this.emfDomain = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.patient.example");
        EntityManager em = this.emfDomain.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)medicalRecord);
        em.getTransaction().commit();
        this.createRuntimeManager(new String[]{"patient-appointment.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        logger.info("### Starting process ###");
        HashMap<String, MedicalRecord> parameters = new HashMap<String, MedicalRecord>();
        parameters.put("medicalRecord", medicalRecord);
        ProcessInstance process = ksession.startProcess("org.jbpm.PatientAppointment", parameters);
        long processInstanceId = process.getId();
        Assert.assertEquals((long)1L, (long)process.getState());
        List frontDeskTasks = taskService.getTasksAssignedAsPotentialOwner("frontDesk", "en-UK");
        Assert.assertEquals((long)1L, (long)frontDeskTasks.size());
        List doctorTasks = taskService.getTasksAssignedAsPotentialOwner("doctor", "en-UK");
        Assert.assertTrue((boolean)doctorTasks.isEmpty());
        List managerTasks = taskService.getTasksAssignedAsPotentialOwner("manager", "en-UK");
        Assert.assertTrue((boolean)managerTasks.isEmpty());
        taskService.start(((TaskSummary)frontDeskTasks.get(0)).getId().longValue(), "frontDesk");
        MedicalRecord taskMedicalRecord = this.getTaskContent(runtimeEngine, (TaskSummary)frontDeskTasks.get(0));
        Assert.assertNotNull((Object)taskMedicalRecord.getId());
        taskMedicalRecord.setDescription("Initial Description of the Medical Record");
        em.getTransaction().begin();
        em.merge((Object)taskMedicalRecord);
        em.getTransaction().commit();
        taskService.complete(((TaskSummary)frontDeskTasks.get(0)).getId().longValue(), "frontDesk", null);
        doctorTasks = taskService.getTasksAssignedAsPotentialOwner("doctor", "en-UK");
        Assert.assertEquals((long)1L, (long)doctorTasks.size());
        managerTasks = taskService.getTasksAssignedAsPotentialOwner("manager", "en-UK");
        Assert.assertTrue((boolean)managerTasks.isEmpty());
        taskMedicalRecord = this.getTaskContent(runtimeEngine, (TaskSummary)doctorTasks.get(0));
        taskService.start(((TaskSummary)doctorTasks.get(0)).getId().longValue(), "doctor");
        taskMedicalRecord = (MedicalRecord)em.find(MedicalRecord.class, (Object)taskMedicalRecord.getId());
        Assert.assertEquals((Object)"Initial Description of the Medical Record", (Object)taskMedicalRecord.getDescription());
        em.getTransaction().begin();
        taskMedicalRecord.setDescription("Medical Record Validated by Doctor");
        ArrayList<RecordRow> rows = new ArrayList<RecordRow>();
        RecordRow recordRow = new RecordRow("CODE-999", "Just a regular Cold");
        recordRow.setMedicalRecord(medicalRecord);
        rows.add(recordRow);
        taskMedicalRecord.setRows(rows);
        taskMedicalRecord.setPriority(1);
        em.getTransaction().commit();
        taskService.complete(((TaskSummary)doctorTasks.get(0)).getId().longValue(), "doctor", null);
        managerTasks = taskService.getTasksAssignedAsPotentialOwner("manager", "en-UK");
        Assert.assertEquals((long)1L, (long)managerTasks.size());
        taskService.start(((TaskSummary)managerTasks.get(0)).getId().longValue(), "manager");
        em.getTransaction().begin();
        Patient patient = taskMedicalRecord.getPatient();
        patient.setNextAppointment(new Date());
        em.getTransaction().commit();
        taskService.complete(((TaskSummary)managerTasks.get(0)).getId().longValue(), "manager", null);
        process = ksession.getProcessInstance(process.getId());
        Assert.assertNull((Object)process);
    }

    private MedicalRecord getTaskContent(RuntimeEngine runtimeEngine, TaskSummary summary) throws IOException, ClassNotFoundException {
        logger.info(" >>> Getting Task Content = {}", (Object)summary.getId());
        Task task = runtimeEngine.getTaskService().getTaskById(summary.getId().longValue());
        long documentContentId = task.getTaskData().getDocumentContentId();
        Content content = runtimeEngine.getTaskService().getContentById(documentContentId);
        Object readObject = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), (Environment)runtimeEngine.getKieSession().getEnvironment());
        logger.info(" >>> Object = {}", readObject);
        return (MedicalRecord)readObject;
    }
}

