/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.persistence.migration;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.TransactionManagerServices;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.jbpm.persistence.processinstance.ProcessInstanceInfo;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.workflow.instance.WorkflowProcessInstanceUpgrader;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.command.Context;

public class ProcessInstanceMigrationTest
extends JbpmJUnitBaseTestCase {
    public ProcessInstanceMigrationTest() {
        super(true, true);
    }

    @Test
    public void testProcessInstanceMigration() throws Exception {
        RuntimeManager manager = this.createRuntimeManager(new String[]{"migration/sample.bpmn2", "migration/sample2.bpmn2"});
        RuntimeEngine engine = manager.getRuntimeEngine(null);
        KieSession ksession = engine.getKieSession();
        TaskService taskService = engine.getTaskService();
        BitronixTransactionManager transactionManager = TransactionManagerServices.getTransactionManager();
        transactionManager.setTransactionTimeout(3600);
        ProcessInstance p = ksession.startProcess("com.sample.bpmn.migration");
        long pid = p.getId();
        ProcessInstanceMigrationTest.assertEquals((Object)"com.sample.bpmn.migration", (Object)ksession.getProcessInstance(pid).getProcessId());
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        ProcessInstanceMigrationTest.assertNotNull((Object)list);
        ProcessInstanceMigrationTest.assertEquals((long)1L, (long)list.size());
        UpgradeCommand c = new UpgradeCommand(pid);
        ksession.execute((Command)c);
        TaskSummary task = (TaskSummary)list.get(0);
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        ProcessInstanceMigrationTest.assertNotNull((Object)list);
        ProcessInstanceMigrationTest.assertEquals((long)1L, (long)list.size());
        ProcessInstanceMigrationTest.assertEquals((Object)"com.sample.bpmn.migration2", (Object)ksession.getProcessInstance(pid).getProcessId());
        EntityManager em = this.getEmf().createEntityManager();
        Query query = em.createQuery("select p from ProcessInstanceInfo p where p.processInstanceId = :pid").setParameter("pid", (Object)pid);
        List found = query.getResultList();
        ProcessInstanceMigrationTest.assertNotNull((Object)found);
        ProcessInstanceMigrationTest.assertEquals((long)1L, (long)found.size());
        ProcessInstanceInfo instance = (ProcessInstanceInfo)found.get(0);
        ProcessInstanceMigrationTest.assertEquals((Object)"com.sample.bpmn.migration2", (Object)instance.getProcessId());
        Thread.sleep(400L);
        manager.disposeRuntimeEngine(engine);
    }

    private static class UpgradeCommand
    implements GenericCommand<Object> {
        private static final long serialVersionUID = -626809842544969669L;
        private long pid;

        private UpgradeCommand(long pid) {
            this.pid = pid;
        }

        public Object execute(Context arg0) {
            KieSession ksession = ((KnowledgeCommandContext)arg0).getKieSession();
            WorkflowProcessInstanceUpgrader.upgradeProcessInstance((KieRuntime)ksession, (long)this.pid, (String)"com.sample.bpmn.migration2", null);
            return null;
        }
    }
}

