/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.tasks.identity;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;

public class JBossUserGroupCallbackTest
extends JbpmJUnitBaseTestCase {
    public JBossUserGroupCallbackTest() {
        super(true, true);
    }

    @BeforeClass
    public static void setupOnce() {
        System.setProperty("org.jbpm.ht.user.separator", "#");
    }

    @AfterClass
    public static void cleanupOnce() {
        System.clearProperty("org.jbpm.ht.user.separator");
    }

    @Before
    public void configure() {
        Properties properties = new Properties();
        properties.setProperty("krisv", "krisvgg");
        properties.setProperty("mary", "maryg,g");
        properties.setProperty("john", "johngg");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
    }

    @Test
    public void testProcess() throws Exception {
        RuntimeManager manager = this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE, "default", new String[]{"CustomSeparatorGroupIdUserTaskTest.bpmn"});
        RuntimeEngine runtime = this.getRuntimeEngine();
        KieSession ksession = runtime.getKieSession();
        HashMap params = new HashMap();
        ProcessInstance pi = ksession.startProcess("com.sample.bpmn.hello", params);
        System.out.println("A process instance started : pid = " + pi.getId());
        Assert.assertEquals((long)1L, (long)pi.getState());
        TaskService taskService = runtime.getTaskService();
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        System.out.println("Listing if the there are any tasks for john to complete: list= " + list);
        Assert.assertEquals((long)1L, (long)list.size());
        for (TaskSummary taskSummary : list) {
            System.out.println("john starts a task : taskId = " + taskSummary.getId());
            taskService.start(taskSummary.getId().longValue(), "john");
            System.out.println("john started the task : taskId = " + taskSummary.getId() + ", which had assigned to Group/Owner: " + taskService.getTaskById(taskSummary.getId().longValue()).getPeopleAssignments().getPotentialOwners());
            taskService.complete(taskSummary.getId().longValue(), "john", null);
            System.out.println("john completed the task .");
        }
        List taskList = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        Assert.assertEquals((long)1L, (long)taskList.size());
        for (TaskSummary taskSummary : taskList) {
            System.out.println("mary starts a task : taskId = " + taskSummary.getId() + ", which had assigned to Group/Owner: " + taskService.getTaskById(taskSummary.getId().longValue()).getPeopleAssignments().getPotentialOwners());
            taskService.start(taskSummary.getId().longValue(), "mary");
            System.out.println("mary started the task : taskId = " + taskSummary.getId());
            taskService.complete(taskSummary.getId().longValue(), "mary", null);
            System.out.println("mary completed the task .");
        }
        this.assertProcessInstanceCompleted(pi.getId());
        System.out.println("Process Instance with id: '" + pi.getId() + "' , got completed successfully.");
        manager.disposeRuntimeEngine(runtime);
    }
}

