/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.timer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jbpm.process.core.timer.impl.ThreadPoolSchedulerService;
import org.jbpm.test.timer.GlobalTimerServiceBaseTest;
import org.jbpm.test.timer.TimerBaseTest;
import org.jbpm.test.timer.TransactionalThreadPoolSchedulerService;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.SessionNotFoundException;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

@RunWith(value=Parameterized.class)
public class GlobalThreadPoolTimerServiceTest
extends GlobalTimerServiceBaseTest {
    private int managerType;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{1}, {2}, {3}};
        return Arrays.asList(data);
    }

    public GlobalThreadPoolTimerServiceTest(int managerType) {
        this.managerType = managerType;
    }

    @Before
    public void setUp() {
        GlobalThreadPoolTimerServiceTest.cleanupSingletonSessionId();
        this.globalScheduler = new ThreadPoolSchedulerService(1);
    }

    @After
    public void tearDown() {
        try {
            this.globalScheduler.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected RuntimeManager getManager(RuntimeEnvironment environment, boolean waitOnStart) {
        if (this.managerType == 1) {
            return RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        }
        if (this.managerType == 2) {
            return RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        }
        if (this.managerType == 3) {
            return RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        }
        throw new IllegalArgumentException("Invalid runtime maanger type");
    }

    @Test
    public void testInterediateTimerWithGlobalTestServiceWithinTransaction() throws Exception {
        this.globalScheduler = new TransactionalThreadPoolSchedulerService(3);
        final ArrayList timerExporations = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("timer")) {
                    timerExporations.add(event.getProcessInstance().getId());
                }
            }
        };
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-IntermediateCatchEventTimerCycle3.bpmn2"), ResourceType.BPMN2).schedulerService((Object)this.globalScheduler).registerableItemsFactory((RegisterableItemsFactory)new TimerBaseTest.TestRegisterableItemsFactory((TimerBaseTest)this, (ProcessEventListener)listener)).get();
        this.manager = this.getManager(this.environment, true);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        GlobalThreadPoolTimerServiceTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        Thread.sleep(1500L);
        this.manager.disposeRuntimeEngine(runtime);
        Thread.sleep(2000L);
        try {
            runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            ksession = runtime.getKieSession();
            processInstance = ksession.getProcessInstance(processInstance.getId());
            GlobalThreadPoolTimerServiceTest.assertNull((Object)processInstance);
        }
        catch (SessionNotFoundException e) {
            // empty catch block
        }
        Thread.sleep(3000L);
        GlobalThreadPoolTimerServiceTest.assertEquals((long)3L, (long)timerExporations.size());
        this.manager.disposeRuntimeEngine(runtime);
    }
}

