/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import java.util.HashMap;
import java.util.List;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessHumanTaskTest
extends JbpmJUnitBaseTestCase {
    private static final Logger logger = LoggerFactory.getLogger(ProcessHumanTaskTest.class);

    public ProcessHumanTaskTest() {
        super(true, false);
    }

    @Test
    public void testProcess() {
        this.createRuntimeManager(new String[]{"humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    @Test
    public void testProcessWithCreatedBy() {
        this.createRuntimeManager(new String[]{"humantaskwithcreatedby.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("person", "krisv");
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello.createdby", params);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        ProcessHumanTaskTest.assertEquals((Object)"mary", (Object)task.getCreatedById());
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        ProcessHumanTaskTest.assertEquals((Object)"krisv", (Object)task.getCreatedById());
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    @Test
    public void testProcessRequestStrategy() {
        this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.REQUEST, "manager", new String[]{"humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    @Test
    public void testProcessProcessInstanceStrategy() {
        RuntimeManager manager = this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE, "manager", new String[]{"humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        long ksessionID = ksession.getIdentifier();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        manager.disposeRuntimeEngine(runtimeEngine);
        runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        ksession = runtimeEngine.getKieSession();
        taskService = runtimeEngine.getTaskService();
        ProcessHumanTaskTest.assertEquals((long)ksessionID, (long)ksession.getIdentifier());
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
        manager.disposeRuntimeEngine(runtimeEngine);
    }
}

