/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import org.jbpm.test.JBPMHelper;
import org.kie.api.io.ResourceType;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessMain {
    private static final Logger logger = LoggerFactory.getLogger(ProcessMain.class);

    public static final void main(String[] args) throws Exception {
        JBPMHelper.startUp();
        KnowledgeBase kbase = ProcessMain.readKnowledgeBase();
        StatefulKnowledgeSession ksession = JBPMHelper.newStatefulKnowledgeSession((KnowledgeBase)kbase);
        ksession.startProcess("com.sample.bpmn.hello");
        logger.info("Process started ...");
    }

    private static KnowledgeBase readKnowledgeBase() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"humantask.bpmn"), ResourceType.BPMN2);
        return kbuilder.newKnowledgeBase();
    }

    private static void startUp() {
        JBPMHelper.startH2Server();
        JBPMHelper.setupDataSource();
        JBPMHelper.startTaskService();
    }
}

