/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;

public class ProcessPersistenceTest
extends JbpmJUnitBaseTestCase {
    public ProcessPersistenceTest() {
        super(true, true);
    }

    @Test
    public void testProcess() {
        RuntimeManager manager = this.createRuntimeManager(new String[]{"hello.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        this.assertProcessInstanceCompleted(processInstance.getId());
        this.assertNodeTriggered(processInstance.getId(), new String[]{"StartProcess", "Hello", "EndProcess"});
        manager.disposeRuntimeEngine(runtimeEngine);
        manager.close();
    }

    @Test
    public void testTransactions() throws Exception {
        this.createRuntimeManager(new String[]{"humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        UserTransaction ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
        ut.begin();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        ut.rollback();
        ProcessPersistenceTest.assertNull((Object)ksession.getProcessInstance(processInstance.getId()));
    }
}

