/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.concurrent;

import java.util.List;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.concurrent.ProcessRunner;
import org.junit.Test;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;

public class ConcurrentHumanTaskTest
extends JbpmJUnitBaseTestCase {
    private static final int THREADS = 2;

    public ConcurrentHumanTaskTest() {
        super(true, true);
    }

    @Test
    public void testConcurrentInvocationsIncludingUserTasks() throws Exception {
        for (int i = 0; i < 2; ++i) {
            ProcessRunner pr = new ProcessRunner(i, this.getEmf());
            Thread t = new Thread((Runnable)pr, i + "-process-runner");
            t.start();
        }
        Thread.sleep(5000L);
        JPAAuditLogService logService = new JPAAuditLogService(this.getEmf());
        List logs = logService.findProcessInstances("com.sample.humantask.concurrent");
        ConcurrentHumanTaskTest.assertEquals((long)2L, (long)logs.size());
        for (ProcessInstanceLog log : logs) {
            ConcurrentHumanTaskTest.assertEquals((long)2L, (long)log.getStatus().intValue());
        }
        logService.dispose();
    }
}

