/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.persistence;

import bitronix.tm.BitronixTransactionManager;
import bitronix.tm.TransactionManagerServices;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.transaction.UserTransaction;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.marshalling.impl.MarshallingConfigurationImpl;
import org.drools.core.marshalling.impl.ProtobufMarshaller;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.timer.TimerInstance;
import org.jbpm.process.instance.timer.TimerManager;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.marshalling.MarshallingConfiguration;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializedTimerRollbackTest
extends JbpmJUnitBaseTestCase {
    private static final Logger logger = LoggerFactory.getLogger(SerializedTimerRollbackTest.class);

    public SerializedTimerRollbackTest() {
        super(true, true);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        try {
            UserTransaction ut = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
            ut.begin();
            EntityManager em = this.getEmf().createEntityManager();
            em.createQuery("delete from SessionInfo").executeUpdate();
            em.close();
            ut.commit();
        }
        catch (Exception e) {
            logger.error("Something went wrong deleting the Session Info", (Throwable)e);
        }
    }

    @Test
    public void testSerizliableTestsWithExternalRollback() {
        try {
            this.createRuntimeManager(new String[]{"HumanTaskWithBoundaryTimer.bpmn"});
            RuntimeEngine runtimeEngine = this.getRuntimeEngine();
            KieSession ksession = runtimeEngine.getKieSession();
            TaskService taskService = runtimeEngine.getTaskService();
            logger.debug("Created knowledge session");
            BitronixTransactionManager tm = TransactionManagerServices.getTransactionManager();
            ArrayList<Long> committedProcessInstanceIds = new ArrayList<Long>();
            for (int i = 0; i < 10; ++i) {
                tm.begin();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("test", "john");
                logger.debug("Creating process instance: {}", (Object)i);
                ProcessInstance pi = ksession.startProcess("PROCESS_1", params);
                if (i % 2 == 0) {
                    committedProcessInstanceIds.add(pi.getId());
                    tm.commit();
                    continue;
                }
                tm.rollback();
            }
            Connection c = this.getDs().getConnection();
            Statement st = c.createStatement();
            ResultSet rs = st.executeQuery("select rulesbytearray from sessioninfo");
            rs.next();
            Blob b = rs.getBlob("rulesbytearray");
            SerializedTimerRollbackTest.assertNotNull((Object)b);
            KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            ProtobufMarshaller marshaller = new ProtobufMarshaller((KieBase)builder.newKnowledgeBase(), (MarshallingConfiguration)new MarshallingConfigurationImpl());
            StatefulKnowledgeSession session = marshaller.unmarshall(b.getBinaryStream());
            SerializedTimerRollbackTest.assertNotNull((Object)session);
            TimerManager timerManager = ((InternalProcessRuntime)((InternalKnowledgeRuntime)session).getProcessRuntime()).getTimerManager();
            SerializedTimerRollbackTest.assertNotNull((Object)timerManager);
            Collection timers = timerManager.getTimers();
            SerializedTimerRollbackTest.assertNotNull((Object)timers);
            SerializedTimerRollbackTest.assertEquals((long)5L, (long)timers.size());
            for (TimerInstance timerInstance : timers) {
                SerializedTimerRollbackTest.assertTrue((boolean)committedProcessInstanceIds.contains(timerInstance.getProcessInstanceId()));
                ksession.abortProcessInstance(timerInstance.getProcessInstanceId());
            }
            List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
            SerializedTimerRollbackTest.assertEquals((long)0L, (long)tasks.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            SerializedTimerRollbackTest.fail((String)"Exception thrown");
        }
    }

    @Test
    public void testSerizliableTestsWithEngineRollback() {
        try {
            this.createRuntimeManager(new String[]{"HumanTaskWithBoundaryTimer.bpmn"});
            RuntimeEngine runtimeEngine = this.getRuntimeEngine();
            KieSession ksession = runtimeEngine.getKieSession();
            logger.debug("Created knowledge session");
            TaskService taskService = runtimeEngine.getTaskService();
            logger.debug("Task service created");
            ArrayList<Long> committedProcessInstanceIds = new ArrayList<Long>();
            for (int i = 0; i < 10; ++i) {
                HashMap<String, String> params;
                if (i % 2 == 0) {
                    params = new HashMap<String, String>();
                    params.put("test", "john");
                    logger.debug("Creating process instance: {}", (Object)i);
                    ProcessInstance pi = ksession.startProcess("PROCESS_1", params);
                    committedProcessInstanceIds.add(pi.getId());
                    continue;
                }
                try {
                    params = new HashMap();
                    params.put("test", null);
                    logger.debug("Creating process instance: {}", (Object)i);
                    ksession.startProcess("PROCESS_1", params);
                    continue;
                }
                catch (Exception e) {
                    logger.debug("Process rolled back");
                }
            }
            Connection c = this.getDs().getConnection();
            Statement st = c.createStatement();
            ResultSet rs = st.executeQuery("select rulesbytearray from sessioninfo");
            rs.next();
            Blob b = rs.getBlob("rulesbytearray");
            SerializedTimerRollbackTest.assertNotNull((Object)b);
            KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            ProtobufMarshaller marshaller = new ProtobufMarshaller((KieBase)builder.newKnowledgeBase(), (MarshallingConfiguration)new MarshallingConfigurationImpl());
            StatefulKnowledgeSession session = marshaller.unmarshall(b.getBinaryStream());
            SerializedTimerRollbackTest.assertNotNull((Object)session);
            TimerManager timerManager = ((InternalProcessRuntime)((InternalKnowledgeRuntime)session).getProcessRuntime()).getTimerManager();
            SerializedTimerRollbackTest.assertNotNull((Object)timerManager);
            Collection timers = timerManager.getTimers();
            SerializedTimerRollbackTest.assertNotNull((Object)timers);
            SerializedTimerRollbackTest.assertEquals((long)5L, (long)timers.size());
            for (TimerInstance timerInstance : timers) {
                SerializedTimerRollbackTest.assertTrue((boolean)committedProcessInstanceIds.contains(timerInstance.getProcessInstanceId()));
                ksession.abortProcessInstance(timerInstance.getProcessInstanceId());
            }
            List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
            SerializedTimerRollbackTest.assertEquals((long)0L, (long)tasks.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            SerializedTimerRollbackTest.fail((String)"Exception thrown");
        }
    }
}

