/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jbpm.runtime.manager.impl.DefaultRegisterableItemsFactory;
import org.jbpm.runtime.manager.impl.RuntimeEnvironmentBuilder;
import org.jbpm.services.task.audit.JPATaskLifeCycleEventListener;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;

public class MultipleRuntimeManagerTest
extends JbpmJUnitBaseTestCase {
    public MultipleRuntimeManagerTest() {
        super(true, true);
    }

    @Test
    public void testCreationOfRuntimeManagersConcurrently() throws Exception {
        CopyOnWriteArrayList<RuntimeManager> managers = new CopyOnWriteArrayList<RuntimeManager>();
        HumanTaskResolver htr1 = new HumanTaskResolver(1L, managers);
        HumanTaskResolver htr2 = new HumanTaskResolver(2L, managers);
        Thread t1 = new Thread((Runnable)htr1, "first");
        Thread t2 = new Thread((Runnable)htr2, "second");
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        MultipleRuntimeManagerTest.assertEquals((long)2L, (long)managers.size());
    }

    class HumanTaskResolver
    implements Runnable {
        private final long pid;
        private List<RuntimeManager> managers;

        public HumanTaskResolver(long pid, List<RuntimeManager> managers) {
            this.pid = pid;
            this.managers = managers;
        }

        @Override
        public void run() {
            RuntimeManager manager = this.getRuntimeManager("humantask.bpmn");
            this.managers.add(manager);
            manager.close();
        }

        private RuntimeManager getRuntimeManager(String process) {
            Properties properties = new Properties();
            properties.setProperty("john", "");
            JBossUserGroupCallbackImpl userGroupCallback = new JBossUserGroupCallbackImpl(properties);
            KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
            kbuilder.add(ResourceFactory.newClassPathResource((String)process), ResourceType.BPMN2);
            org.kie.internal.runtime.manager.RuntimeEnvironment environment = RuntimeEnvironmentBuilder.getDefault().persistence(false).entityManagerFactory((Object)MultipleRuntimeManagerTest.this.getEmf()).userGroupCallback((UserGroupCallback)userGroupCallback).knowledgeBase((KieBase)kbuilder.newKnowledgeBase()).registerableItemsFactory((RegisterableItemsFactory)new DefaultRegisterableItemsFactory(){

                public List<TaskLifeCycleEventListener> getTaskListeners() {
                    ArrayList<TaskLifeCycleEventListener> defaultListeners = new ArrayList<TaskLifeCycleEventListener>();
                    defaultListeners.add((TaskLifeCycleEventListener)new JPATaskLifeCycleEventListener(false));
                    defaultListeners.addAll(super.getTaskListeners());
                    defaultListeners.addAll(this.getTaskListenersFromDescriptor());
                    return defaultListeners;
                }
            }).get();
            return RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager((RuntimeEnvironment)environment, "exec-" + this.pid);
        }
    }
}

