/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.concurrent;

import java.util.HashMap;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.core.timer.TimerServiceRegistry;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.concurrent.HumanTaskResolver;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

class ProcessRunner
implements Runnable {
    private int i;
    private EntityManagerFactory emf;

    public ProcessRunner(int i, EntityManagerFactory emf) {
        this.i = i;
        this.emf = emf;
    }

    private RuntimeManager getRuntimeManager(String process, int i) {
        Properties properties = new Properties();
        properties.setProperty("krisv", "");
        properties.setProperty("sales-rep", "sales");
        properties.setProperty("john", "PM");
        KnowledgeBuilder knowledgeBuilder = this.createKBuilder(process, ResourceType.BPMN2);
        KnowledgeBase kieBase = knowledgeBuilder.newKnowledgeBase();
        JBossUserGroupCallbackImpl userGroupCallback = new JBossUserGroupCallbackImpl(properties);
        TimerServiceRegistry.getInstance();
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().userGroupCallback((UserGroupCallback)userGroupCallback).persistence(true).entityManagerFactory((Object)this.emf).knowledgeBase((KieBase)kieBase).get();
        return RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment, "id-" + i);
    }

    private KnowledgeBuilder createKBuilder(String resource, ResourceType resourceType) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)resource), resourceType);
        if (kbuilder.hasErrors()) {
            int errors = kbuilder.getErrors().size();
            if (errors > 0) {
                System.out.println("Found " + errors + " errors");
                for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                    System.out.println(error.getMessage());
                }
            }
            throw new IllegalArgumentException("Application process definition has errors, see log for more details");
        }
        return kbuilder;
    }

    @Override
    public void run() {
        System.out.println(" building runtime: " + this.i);
        RuntimeManager manager = this.getRuntimeManager("concurrent/HumanTask.bpmn", this.i);
        RuntimeEngine runtime = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", "krisv");
        params.put("description", "Need a new laptop computer");
        ProcessInstance pi = ksession.startProcess("com.sample.humantask.concurrent", params);
        System.out.println(" starting runtime: " + this.i);
        HumanTaskResolver htr = new HumanTaskResolver(pi.getId(), manager);
        Thread t = new Thread((Runnable)htr, this.i + "-ht-resolver");
        t.start();
    }
}

