/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.tasks.service;

import java.util.Date;
import java.util.HashMap;
import org.jbpm.process.workitem.bpmn2.ServiceTaskHandler;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.WorkItemHandler;

public class ServiceTaskHandlerTest
extends JbpmJUnitBaseTestCase {
    private KieSession ksession;
    private org.jbpm.bpmn2.handler.ServiceTaskHandler bpmn2Handler;
    private ServiceTaskHandler workitemsHandler;
    private static final int BPMN2 = 0;
    private static final int WORKITEMS = 1;

    public ServiceTaskHandlerTest() {
        super(true, true);
    }

    @Before
    public void setup() {
        RuntimeManager manager = this.createRuntimeManager(new String[]{"BPMN2-ServiceTaskShortenInterfaceName.bpmn2", "BPMN2-ServiceTaskFullInterfaceName.bpmn2"});
        RuntimeEngine engine = manager.getRuntimeEngine(null);
        this.ksession = engine.getKieSession();
        this.bpmn2Handler = new org.jbpm.bpmn2.handler.ServiceTaskHandler();
        this.workitemsHandler = new ServiceTaskHandler();
    }

    @After
    public void dispose() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    @Test
    public void testShortenInterfaceNameBPMN2() throws Exception {
        this.assertServiceTaskCompleted("BPMN2-ServiceTaskShortenInterfaceName", 0);
    }

    @Test
    public void testFullInterfaceNameBPMN2() throws Exception {
        this.assertServiceTaskCompleted("BPMN2-ServiceTaskFullInterfaceName", 0);
    }

    @Test
    public void testShortenInterfaceNameWorkitems() throws Exception {
        this.assertServiceTaskCompleted("BPMN2-ServiceTaskShortenInterfaceName", 1);
    }

    @Test
    public void testFullInterfaceNameWorkitems() throws Exception {
        this.assertServiceTaskCompleted("BPMN2-ServiceTaskFullInterfaceName", 1);
    }

    private void assertServiceTaskCompleted(String processName, int jbpmmodule) throws Exception {
        if (jbpmmodule == 0) {
            this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)this.bpmn2Handler);
        } else if (jbpmmodule == 1) {
            this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)this.workitemsHandler);
        }
        HashMap<String, Comparable<Integer>> params = new HashMap<String, Comparable<Integer>>();
        params.put("IntegerVar", new Integer(12345));
        params.put("DateVar", new Date());
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)this.ksession.startProcess(processName.replace("-", ""), params);
        ServiceTaskHandlerTest.assertEquals((long)2L, (long)processInstance.getState());
        ServiceTaskHandlerTest.assertEquals((Object)1, (Object)processInstance.getVariable("IntegerVar"));
    }
}

