/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import java.util.List;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.context.EmptyContext;

public class JbpmJUnitBaseTestCaseTest
extends JbpmJUnitBaseTestCase {
    public JbpmJUnitBaseTestCaseTest() {
        super(true, true);
    }

    @Test
    public void testAssertNodeActive() throws Exception {
        RuntimeManager manager = this.createRuntimeManager(new String[]{"humantask.bpmn"});
        RuntimeEngine engine = this.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = engine.getKieSession();
        TaskService taskService = engine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("com.sample.bpmn.hello");
        long processInstanceId = processInstance.getId();
        this.assertProcessInstanceActive(processInstanceId);
        this.assertNodeTriggered(processInstanceId, new String[]{"Start", "Task 1"});
        this.assertNodeActive(processInstanceId, ksession, new String[]{"Task 1"});
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        taskService.start(taskSummary.getId().longValue(), "john");
        taskService.complete(taskSummary.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstanceId, new String[]{"Start", "Task 1", "Task 2"});
        this.assertNodeActive(processInstanceId, ksession, new String[]{"Task 2"});
        tasks = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskSummary = (TaskSummary)tasks.get(0);
        taskService.start(taskSummary.getId().longValue(), "mary");
        taskService.complete(taskSummary.getId().longValue(), "mary", null);
        this.assertProcessInstanceCompleted(processInstanceId);
    }
}

