/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.kie.api.KieBase;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.test.util.db.PersistenceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessMain {
    private static final Logger logger = LoggerFactory.getLogger(ProcessMain.class);
    private static final boolean usePersistence = true;

    public static final void main(String[] args) throws Exception {
        ProcessMain.cleanupSingletonSessionId();
        KieBase kbase = ProcessMain.readKnowledgeBase();
        StatefulKnowledgeSession ksession = ProcessMain.newStatefulKnowledgeSession(kbase);
        ksession.startProcess("com.sample.bpmn.hello");
        logger.info("Process started ...");
        System.exit(0);
    }

    private static KieBase readKnowledgeBase() throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"simple.bpmn"), ResourceType.BPMN2);
        return kbuilder.newKieBase();
    }

    public static StatefulKnowledgeSession newStatefulKnowledgeSession(KieBase kbase) {
        RuntimeEnvironmentBuilder builder = null;
        Properties properties = new Properties();
        properties.put("driverClassName", "org.h2.Driver");
        properties.put("className", "org.h2.jdbcx.JdbcDataSource");
        properties.put("user", "sa");
        properties.put("password", "");
        properties.put("url", "jdbc:h2:tcp://localhost/~/jbpm-db;MODE=LEGACY;NON_KEYWORDS=VALUE");
        properties.put("datasourceName", "jdbc/jbpm-ds");
        PersistenceUtil.setupPoolingDataSource((Properties)properties);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("hibernate.dialect", "org.hibernate.dialect.H2Dialect");
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)properties.getProperty("persistence.persistenceunit.name", "org.jbpm.persistence.jpa"), map);
        builder = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)emf);
        builder.knowledgeBase(kbase);
        RuntimeManager manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(builder.get());
        return (StatefulKnowledgeSession)manager.getRuntimeEngine(EmptyContext.get()).getKieSession();
    }

    private static void cleanupSingletonSessionId() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (tempDir.exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = tempDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("-jbpmSessionId.ser");
                }
            })) {
                new File(tempDir, file).delete();
            }
        }
    }
}

