/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.newcase;

import com.google.common.base.Strings;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.cm.client.newcase.NewCaseInstancePresenter;
import org.jbpm.workbench.cm.client.util.AbstractView;
import org.jbpm.workbench.cm.client.util.FormGroup;
import org.jbpm.workbench.cm.client.util.FormLabel;
import org.jbpm.workbench.cm.client.util.Modal;
import org.jbpm.workbench.cm.client.util.Select;
import org.jbpm.workbench.cm.client.util.ValidationState;

@Dependent
@Templated
public class NewCaseInstanceViewImpl
extends AbstractView<NewCaseInstancePresenter>
implements NewCaseInstancePresenter.NewCaseInstanceView {
    @Inject
    @DataField(value="definition-name-group")
    private FormGroup caseDefinitionNameGroup;
    @Inject
    @DataField(value="modal")
    private Modal modal;
    @Inject
    @DataField(value="definition-name-help")
    private Span definitionNameHelp;
    @Inject
    @DataField(value="definition-name-select")
    private Select caseTemplatesList;
    @Inject
    @DataField(value="definition-name-label")
    private FormLabel caseDefinitionNameLabel;
    @Inject
    private TranslationService translationService;

    @PostConstruct
    public void init() {
        this.caseDefinitionNameLabel.addRequiredIndicator();
    }

    @Override
    public void show() {
        this.cleanForm();
        this.modal.show();
    }

    @Override
    public void hide() {
        this.cleanForm();
        this.modal.hide();
    }

    @Override
    public void clearCaseDefinitions() {
        this.caseTemplatesList.removeAllOptions();
    }

    @Override
    public void setCaseDefinitions(List<String> definitions) {
        for (String definition : definitions) {
            this.caseTemplatesList.addOption(definition);
        }
        this.caseTemplatesList.refresh();
    }

    public void cleanForm() {
        this.caseTemplatesList.setValue("");
        this.caseTemplatesList.getElement().focus();
        this.caseTemplatesList.enable();
        this.clearErrorMessages();
    }

    private boolean validateForm() {
        this.clearErrorMessages();
        if (Strings.isNullOrEmpty((String)this.caseTemplatesList.getValue())) {
            this.caseTemplatesList.getElement().focus();
            this.definitionNameHelp.setTextContent(this.translationService.format("PleaseSelectCaseDefinition", new Object[0]));
            this.caseDefinitionNameGroup.setValidationState(ValidationState.ERROR);
            return false;
        }
        this.caseDefinitionNameGroup.setValidationState(ValidationState.SUCCESS);
        return true;
    }

    public HTMLElement getElement() {
        return this.modal.getElement();
    }

    private void createCaseInstance() {
        ((NewCaseInstancePresenter)this.presenter).createCaseInstance(this.caseTemplatesList.getValue());
    }

    private void clearErrorMessages() {
        this.definitionNameHelp.setTextContent("");
        this.caseDefinitionNameGroup.clearValidationState();
    }

    @EventHandler(value={"start"})
    public void onCreateClick(@ForEvent(value={"click"}) MouseEvent event) {
        if (this.validateForm()) {
            this.createCaseInstance();
        }
    }

    @EventHandler(value={"cancel"})
    public void onCancelClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }

    @EventHandler(value={"close"})
    public void onCloseClick(@ForEvent(value={"click"}) MouseEvent event) {
        this.hide();
    }
}

