/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.overview;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.cm.client.overview.CaseOverviewPresenter;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
@Templated(stylesheet="CaseOverviewViewImpl.css")
public class CaseOverviewViewImpl
implements CaseOverviewPresenter.CaseOverviewView {
    @Inject
    @DataField(value="container")
    Div container;
    @Inject
    @DataField(value="case-details-content")
    FlowPanel caseDetails;
    @Inject
    @DataField(value="side-bar-left")
    FlowPanel sideBarLeft;
    @Inject
    @DataField(value="side-bar-right")
    FlowPanel sideBarRight;
    @Inject
    @DataField(value="case-stages")
    FlowPanel caseStages;
    @Inject
    @DataField(value="case-comments")
    FlowPanel caseComments;
    @Inject
    FlowPanel caseFiles;
    @Inject
    @DataField(value="case-roles")
    FlowPanel caseRoles;
    @Inject
    @DataField(value="case-milestones")
    FlowPanel caseMilestones;
    @Inject
    @DataField(value="case-title")
    Span caseTitle;
    @Inject
    @DataField(value="case-id")
    Span caseId;
    @Inject
    @DataField(value="case-destroy")
    Anchor destroyCase;
    @Inject
    @DataField(value="case-cancel")
    Button cancelCase;
    @Inject
    @DataField(value="backToList")
    Button backToList;
    @Inject
    @DataField(value="refresh")
    Button refresh;
    @Inject
    PlaceManager placeManager;
    private CaseOverviewPresenter presenter;

    public void init(CaseOverviewPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void addCaseDetails(String placeId, Map<String, String> properties) {
        this.addWidget(placeId, properties, (HasWidgets)this.caseDetails);
    }

    @Override
    public void addCaseActions(String placeId, Map<String, String> properties) {
        this.addWidget(placeId, properties, (HasWidgets)this.sideBarLeft);
    }

    @Override
    public void addCaseStages(String placeId, Map<String, String> properties) {
        this.addWidget(placeId, properties, (HasWidgets)this.caseStages);
    }

    @Override
    public void addCaseComments(String placeId, Map<String, String> properties) {
        this.addWidget(placeId, properties, (HasWidgets)this.caseComments);
    }

    @Override
    public void addCaseFiles(String placeId, Map<String, String> properties) {
        this.addWidget(placeId, properties, (HasWidgets)this.caseFiles);
    }

    @Override
    public void addCaseRoles(String placeId, Map<String, String> properties) {
        this.addWidget(placeId, properties, (HasWidgets)this.caseRoles);
    }

    @Override
    public void addCaseMilestones(String placeId, Map<String, String> properties) {
        this.addWidget(placeId, properties, (HasWidgets)this.caseMilestones);
    }

    @Override
    public void addCaseActivities(String placeId, Map<String, String> properties) {
        this.addWidget(placeId, properties, (HasWidgets)this.sideBarRight);
    }

    private void addWidget(String placeId, Map<String, String> properties, HasWidgets widget) {
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest(placeId, properties), widget);
    }

    @Override
    public void setCaseTitle(String title) {
        this.caseTitle.setTextContent(title);
    }

    @Override
    public void setCaseId(String description) {
        this.caseId.setTextContent(description);
    }

    @EventHandler(value={"case-destroy"})
    public void onDestroyClick(@ForEvent(value={"click"}) Event event) {
        this.presenter.destroyCaseInstance();
    }

    @EventHandler(value={"case-cancel"})
    public void onCancelClick(@ForEvent(value={"click"}) Event event) {
        this.presenter.cancelCaseInstance();
    }

    @EventHandler(value={"backToList"})
    public void onBackToListClick(@ForEvent(value={"click"}) Event event) {
        this.presenter.backToList();
    }

    @EventHandler(value={"refresh"})
    public void onRefreshClick(@ForEvent(value={"click"}) Event event) {
        this.presenter.refreshCase();
    }

    public HTMLElement getElement() {
        return this.container;
    }
}

