/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.stages;

import com.google.gwt.user.client.TakesValue;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.ListItem;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.cm.client.stages.CaseStagesPresenter;
import org.jbpm.workbench.cm.client.util.AbstractView;
import org.jbpm.workbench.cm.client.util.CaseStageStatus;
import org.jbpm.workbench.cm.model.CaseStageSummary;

@Dependent
@Templated(stylesheet="CaseStageItemViewImpl.css")
public class CaseStageItemViewImpl
extends AbstractView<CaseStagesPresenter>
implements TakesValue<CaseStageSummary>,
IsElement {
    @Inject
    @DataField(value="stage-name")
    @Bound
    Span name;
    @Inject
    @DataField(value="stage-status")
    Span status;
    @Inject
    @DataField(value="list-group-item")
    ListItem listGroupItem;
    @Inject
    @AutoBound
    private DataBinder<CaseStageSummary> caseStageSummary;
    @Inject
    protected TranslationService translationService;

    @PostConstruct
    public void init() {
        this.tooltip((HTMLElement)this.status);
        this.tooltip((HTMLElement)this.name);
    }

    public HTMLElement getElement() {
        return this.listGroupItem;
    }

    public CaseStageSummary getValue() {
        return (CaseStageSummary)this.caseStageSummary.getModel();
    }

    public void setValue(CaseStageSummary model) {
        this.caseStageSummary.setModel((Object)model);
        CaseStageStatus stageStatus = CaseStageStatus.fromStatus(model.getStatus());
        String statusStr = this.convertStatusToStr(stageStatus.getStatus());
        switch (stageStatus) {
            case COMPLETED: {
                this.showStageStatus(statusStr, "pficon", "pficon-ok");
                break;
            }
            case AVAILABLE: {
                this.showStageStatus(statusStr, "fa", "fa-circle-o");
                break;
            }
            case CANCELED: {
                this.showStageStatus(statusStr, "pficon", "pficon-error-circle-o");
            }
        }
    }

    public void showStageStatus(String tooltipTitle, String ... stylesClass) {
        this.name.setAttribute("data-original-title", tooltipTitle);
        this.status.setAttribute("data-original-title", tooltipTitle);
        for (String styleClass : stylesClass) {
            DOMUtil.addCSSClass((HTMLElement)this.status, (String)styleClass);
        }
    }

    public String convertStatusToStr(String modelValue) {
        if (modelValue == null) {
            return "";
        }
        return this.translationService.format(CaseStageStatus.fromStatus(modelValue).getStatus(), new Object[0]);
    }
}

