/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.actions;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.cm.client.actions.CaseActionsPresenter;
import org.jbpm.workbench.cm.client.util.AbstractCaseInstancePresenterTest;
import org.jbpm.workbench.cm.model.CaseActionSummary;
import org.jbpm.workbench.cm.model.CaseDefinitionSummary;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.model.ProcessDefinitionSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.jbpm.workbench.cm.util.Actions;
import org.jbpm.workbench.cm.util.CaseActionType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=MockitoJUnitRunner.class)
public class ActionsPresenterTest
extends AbstractCaseInstancePresenterTest {
    @Mock(name="view")
    CaseActionsPresenter.CaseActionsView caseAllActionsView;
    @Mock(name="NewActionView")
    CaseActionsPresenter.NewActionView newActionViewMock;
    @Mock
    User identity;
    @Mock
    Actions actions;
    @InjectMocks
    CaseActionsPresenter presenter;
    List<CaseActionSummary> caseActionSummaryList = Lists.newArrayList((Object[])new CaseActionSummary[]{ActionsPresenterTest.createCaseActionSummary()});
    CaseInstanceSummary cis;
    String containerId = "containerId";
    String caseDefId = "caseDefinitionId";
    String caseId = "caseId";
    String serverTemplateId = "serverTemplateId";

    private static CaseActionSummary createCaseActionSummary() {
        return CaseActionSummary.builder().id(Long.valueOf(1L)).name("actionName").build();
    }

    public CaseActionsPresenter getPresenter() {
        return this.presenter;
    }

    @Override
    @Before
    public void init() {
        this.caseService = new CallerMock((Object)this.caseManagementService);
        this.presenter.setCaseService(this.caseService);
        this.cis = CaseInstanceSummary.builder().containerId(this.containerId).caseId(this.caseId).caseDefinitionId(this.caseDefId).build();
        CaseDefinitionSummary cds = CaseDefinitionSummary.builder().id(this.caseDefId).build();
        Mockito.when((Object)this.caseManagementService.getCaseDefinition(this.serverTemplateId, this.cis.getContainerId(), this.cis.getCaseDefinitionId())).thenReturn((Object)cds);
        Mockito.when((Object)this.caseManagementService.getCaseActions(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.actions);
        Mockito.when((Object)this.actions.getAvailableActions()).thenReturn(this.caseActionSummaryList);
        Mockito.when((Object)this.actions.getInProgressAction()).thenReturn(this.caseActionSummaryList);
        Mockito.when((Object)this.actions.getCompleteActions()).thenReturn(this.caseActionSummaryList);
    }

    @Test
    public void testLoadCaseInstance() {
        String subProcessName = "Subprocess1";
        List<ProcessDefinitionSummary> pdsl = Arrays.asList(ProcessDefinitionSummary.builder().id("processId").name(subProcessName).build());
        Mockito.when((Object)this.caseManagementService.getProcessDefinitions(this.containerId)).thenReturn(pdsl);
        this.setupCaseInstance(this.cis, this.serverTemplateId);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).getCaseActions(this.serverTemplateId, this.containerId, this.caseId, this.identity.getIdentifier());
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((CaseActionsPresenter.CaseActionsView)Mockito.verify((Object)this.caseAllActionsView)).setAvailableActionsList((List)captor.capture());
        Assert.assertEquals((long)(this.caseActionSummaryList.size() + 2), (long)((List)captor.getValue()).size());
        Assert.assertEquals((Object)CaseActionType.DYNAMIC_USER_TASK, (Object)((CaseActionSummary)((List)captor.getValue()).get(0)).getActionType());
        Assert.assertEquals((Object)CaseActionType.DYNAMIC_SUBPROCESS_TASK, (Object)((CaseActionSummary)((List)captor.getValue()).get(1)).getActionType());
        ((CaseActionsPresenter.CaseActionsView)Mockito.verify((Object)this.caseAllActionsView)).setInProgressActionsList(this.caseActionSummaryList);
        ((CaseActionsPresenter.CaseActionsView)Mockito.verify((Object)this.caseAllActionsView)).setCompletedActionsList(this.caseActionSummaryList);
        ((Actions)Mockito.verify((Object)this.actions)).getAvailableActions();
        ((Actions)Mockito.verify((Object)this.actions)).getInProgressAction();
        ((Actions)Mockito.verify((Object)this.actions)).getCompleteActions();
        ((CaseActionsPresenter.NewActionView)Mockito.verify((Object)this.newActionViewMock, (VerificationMode)Mockito.times((int)2))).setCaseStagesList(this.cis.getStages());
        ArgumentCaptor captor2 = ArgumentCaptor.forClass(List.class);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).getProcessDefinitions(this.containerId);
        ((CaseActionsPresenter.NewActionView)Mockito.verify((Object)this.newActionViewMock)).setProcessDefinitions((List)captor.capture());
        Assert.assertEquals((Object)subProcessName, ((List)captor.getValue()).get(0));
    }

    @Test
    public void testAddDynamicAction() {
        String actionName = "dynAct-name";
        String actionDescription = "dynAct-name";
        String actionActors = "dynAct-actors";
        String actionGroups = "dynAct-groups";
        this.setupCaseInstance(this.cis, this.serverTemplateId);
        this.presenter.addDynamicUserTaskAction(actionName, actionDescription, actionActors, actionGroups, null);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).addDynamicUserTask((String)Matchers.eq((Object)this.containerId), (String)Matchers.eq((Object)this.caseId), (String)Matchers.eq((Object)actionName), (String)Matchers.eq((Object)actionDescription), (String)Matchers.eq((Object)actionActors), (String)Matchers.eq((Object)actionGroups), (Map)Mockito.any());
    }

    @Test
    public void testAddDynamicActionInStage() {
        String actionName = "dynAct-name";
        String actionDescription = "dynAct-name";
        String actionActors = "dynAct-actors";
        String actionGroups = "dynAct-groups";
        String stageId = "dynAct-groups";
        this.setupCaseInstance(this.cis, this.serverTemplateId);
        this.presenter.addDynamicUserTaskAction(actionName, actionDescription, actionActors, actionGroups, stageId);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).addDynamicUserTaskToStage((String)Matchers.eq((Object)this.containerId), (String)Matchers.eq((Object)this.caseId), (String)Matchers.eq((Object)stageId), (String)Matchers.eq((Object)actionName), (String)Matchers.eq((Object)actionDescription), (String)Matchers.eq((Object)actionActors), (String)Matchers.eq((Object)actionGroups), (Map)Mockito.any());
    }

    @Test
    public void testTriggerAdHocFragment() {
        String adhocFragmentName = "adhocFrag-name";
        this.setupCaseInstance(this.cis, this.serverTemplateId);
        this.presenter.triggerAdHocAction(adhocFragmentName);
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).triggerAdHocAction((String)Matchers.eq((Object)this.containerId), (String)Matchers.eq((Object)this.caseId), (String)Matchers.eq((Object)adhocFragmentName), (Map)Mockito.any());
    }
}

