/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.newcase;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.cm.client.events.CaseCreatedEvent;
import org.jbpm.workbench.cm.client.newcase.NewCaseInstancePresenter;
import org.jbpm.workbench.cm.model.CaseDefinitionSummary;
import org.jbpm.workbench.cm.model.CaseRoleAssignmentSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class NewCaseInstancePresenterTest {
    @Mock
    EventSourceMock<NotificationEvent> notificationEvent;
    @Mock
    EventSourceMock<CaseCreatedEvent> caseCreatedEvent;
    @Mock
    NewCaseInstancePresenter.NewCaseInstanceView view;
    Caller<CaseManagementService> caseService;
    @Mock
    CaseManagementService caseManagementService;
    @Mock
    TranslationService translationService;
    @Mock
    User identity;
    @InjectMocks
    NewCaseInstancePresenter presenter;

    @Before
    public void init() {
        this.caseService = new CallerMock((Object)this.caseManagementService);
        this.presenter.setCaseService(this.caseService);
        this.presenter.setNotification(this.notificationEvent);
        this.presenter.setNewCaseEvent(this.caseCreatedEvent);
    }

    @Test
    public void testCreateInvalidCaseInstance() {
        this.presenter.createCaseInstance(null, Mockito.anyString(), null);
        ArgumentCaptor captor = ArgumentCaptor.forClass(NotificationEvent.class);
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(captor.capture());
        Assert.assertEquals((long)1L, (long)captor.getAllValues().size());
        Assert.assertEquals((Object)NotificationEvent.NotificationType.ERROR, (Object)((NotificationEvent)captor.getValue()).getType());
    }

    @Test
    public void testCreateCaseInstance() {
        CaseDefinitionSummary cds = CaseDefinitionSummary.builder().id("id").name("name").containerId("containerId").build();
        Mockito.when((Object)this.caseManagementService.getCaseDefinitions()).thenReturn(Arrays.asList(cds));
        String owner = "userx";
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"userx");
        this.presenter.show();
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).clearCaseDefinitions();
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).setCaseDefinitions((List)captor.capture());
        List list = (List)captor.getValue();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)cds.getName(), list.get(0));
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).setOwner("userx");
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).show();
        this.presenter.createCaseInstance(cds.getName(), "userx", Collections.emptyList());
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).startCaseInstance(null, cds.getContainerId(), cds.getId(), "userx", Collections.emptyList());
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).hide();
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(Mockito.any(NotificationEvent.class));
        ((EventSourceMock)Mockito.verify(this.caseCreatedEvent)).fire(Mockito.any(CaseCreatedEvent.class));
    }

    @Test
    public void testValidateRolesAssignments_SingleAssignmentUser() {
        Map<String, Integer> role = Collections.singletonMap("test", 1);
        CaseDefinitionSummary cds = CaseDefinitionSummary.builder().roles(role).build();
        List<CaseRoleAssignmentSummary> roles = Collections.singletonList(CaseRoleAssignmentSummary.builder().name("test").users(Collections.singletonList("user1")).build());
        List errors = this.presenter.validateRolesAssignments(cds, roles);
        Assert.assertTrue((boolean)errors.isEmpty());
    }

    @Test
    public void testValidateRolesAssignments_SingleAssignmentGroup() {
        Map<String, Integer> role = Collections.singletonMap("test", 1);
        CaseDefinitionSummary cds = CaseDefinitionSummary.builder().roles(role).build();
        List<CaseRoleAssignmentSummary> roles = Collections.singletonList(CaseRoleAssignmentSummary.builder().name("test").groups(Collections.singletonList("group1")).build());
        List errors = this.presenter.validateRolesAssignments(cds, roles);
        Assert.assertTrue((boolean)errors.isEmpty());
    }

    @Test
    public void testValidateRolesAssignments_InvalidAssignment() {
        Map<String, Integer> role = Collections.singletonMap("test", 1);
        CaseDefinitionSummary cds = CaseDefinitionSummary.builder().roles(role).build();
        List<CaseRoleAssignmentSummary> roles = Collections.singletonList(CaseRoleAssignmentSummary.builder().name("test").users(Collections.singletonList("user1")).groups(Collections.singletonList("group1")).build());
        List errors = this.presenter.validateRolesAssignments(cds, roles);
        Assert.assertFalse((boolean)errors.isEmpty());
    }

    @Test
    public void testValidateRolesAssignments_MultipleAssignments() {
        Map<String, Integer> role = Collections.singletonMap("test", -1);
        CaseDefinitionSummary cds = CaseDefinitionSummary.builder().roles(role).build();
        List<CaseRoleAssignmentSummary> roles = Collections.singletonList(CaseRoleAssignmentSummary.builder().name("test").users(Collections.singletonList("user1")).groups(Collections.singletonList("group1")).build());
        List errors = this.presenter.validateRolesAssignments(cds, roles);
        Assert.assertTrue((boolean)errors.isEmpty());
    }
}

