/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.roles;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.jbpm.workbench.cm.client.roles.CaseRolesPresenter;
import org.jbpm.workbench.cm.client.util.AbstractCaseInstancePresenterTest;
import org.jbpm.workbench.cm.model.CaseDefinitionSummary;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.model.CaseRoleAssignmentSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class CaseRolesPresenterTest
extends AbstractCaseInstancePresenterTest {
    private static final String USER = "User";
    private static final String GROUP = "Group";
    private static final String CASE_ROLE = "Role";
    private static final String CASE_DEFINITION_ID = "org.jbpm.case";
    @Mock
    CaseRolesPresenter.CaseRolesView view;
    @Mock
    CaseRolesPresenter.NewRoleAssignmentView assignmentView;
    @InjectMocks
    CaseRolesPresenter presenter;

    public CaseRolesPresenter getPresenter() {
        return this.presenter;
    }

    @Test
    public void testClearCaseInstance() {
        this.presenter.clearCaseInstance();
        this.verifyClearCaseInstance();
    }

    private void verifyClearCaseInstance() {
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).removeAllRoles();
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).disableNewRoleAssignments();
    }

    @Test
    public void testLoadCaseInstance() {
        String serverTemplateId = "serverTemplateId";
        CaseDefinitionSummary caseDefinition = CaseDefinitionSummary.builder().roles(Collections.singletonMap(CASE_ROLE, 3)).build();
        CaseInstanceSummary caseInstance = CaseRolesPresenterTest.newCaseInstanceSummary();
        caseInstance.setRoleAssignments(Collections.singletonList(CaseRoleAssignmentSummary.builder().name(CASE_ROLE).groups(Collections.singletonList(GROUP)).users(Collections.singletonList(USER)).build()));
        this.setCaseDefinitionID(CASE_DEFINITION_ID, caseDefinition, caseInstance);
        Mockito.when((Object)this.caseManagementService.getCaseDefinition("serverTemplateId", caseInstance.getContainerId(), caseInstance.getCaseDefinitionId())).thenReturn((Object)caseDefinition);
        this.setupCaseInstance(caseInstance, "serverTemplateId");
        this.verifyClearCaseInstance();
        ArgumentCaptor captor = ArgumentCaptor.forClass(CaseRolesPresenter.CaseRoleAction.class);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).addUser((String)Matchers.eq((Object)USER), (String)Matchers.eq((Object)CASE_ROLE), new CaseRolesPresenter.CaseRoleAction[]{(CaseRolesPresenter.CaseRoleAction)captor.capture()});
        Assert.assertEquals((Object)"Remove", (Object)((CaseRolesPresenter.CaseRoleAction)captor.getValue()).label());
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).addGroup((String)Matchers.eq((Object)GROUP), (String)Matchers.eq((Object)CASE_ROLE), new CaseRolesPresenter.CaseRoleAction[]{(CaseRolesPresenter.CaseRoleAction)captor.capture()});
        Assert.assertEquals((Object)"Remove", (Object)((CaseRolesPresenter.CaseRoleAction)captor.getValue()).label());
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).enableNewRoleAssignments();
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).setUserAddCommand((Command)Matchers.any(Command.class));
    }

    @Test
    public void testSetupRoleAssignments_whenNoAssignmentsAreMade() {
        this.presenter.setupRoleAssignments(CaseRolesPresenterTest.newCaseInstanceSummary());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testSetupRoleAssignments_onlyUsersAssigned() {
        CaseInstanceSummary caseInstance = CaseRolesPresenterTest.newCaseInstanceSummary();
        caseInstance.setRoleAssignments(Collections.singletonList(CaseRoleAssignmentSummary.builder().name(CASE_ROLE).groups(Collections.emptyList()).users(Collections.singletonList(USER)).build()));
        this.presenter.setupRoleAssignments(caseInstance);
        ArgumentCaptor captor = ArgumentCaptor.forClass(CaseRolesPresenter.CaseRoleAction.class);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).addUser((String)Matchers.eq((Object)USER), (String)Matchers.eq((Object)CASE_ROLE), new CaseRolesPresenter.CaseRoleAction[]{(CaseRolesPresenter.CaseRoleAction)captor.capture()});
        Assert.assertEquals((Object)"Remove", (Object)((CaseRolesPresenter.CaseRoleAction)captor.getValue()).label());
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addGroup(Matchers.anyString(), Matchers.anyString(), (CaseRolesPresenter.CaseRoleAction[])Mockito.anyVararg());
        ((CaseRolesPresenter.CaseRoleAction)captor.getValue()).execute();
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).removeUserFromRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)CASE_ROLE), (String)Matchers.eq((Object)USER));
    }

    @Test
    public void testSetupRoleAssignments_onlyGroupsAssigned() {
        CaseInstanceSummary caseInstance = CaseRolesPresenterTest.newCaseInstanceSummary();
        caseInstance.setRoleAssignments(Collections.singletonList(CaseRoleAssignmentSummary.builder().name(CASE_ROLE).groups(Collections.singletonList(GROUP)).users(Collections.emptyList()).build()));
        this.presenter.setupRoleAssignments(caseInstance);
        ArgumentCaptor captor = ArgumentCaptor.forClass(CaseRolesPresenter.CaseRoleAction.class);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).addGroup((String)Matchers.eq((Object)GROUP), (String)Matchers.eq((Object)CASE_ROLE), new CaseRolesPresenter.CaseRoleAction[]{(CaseRolesPresenter.CaseRoleAction)captor.capture()});
        Assert.assertEquals((Object)"Remove", (Object)((CaseRolesPresenter.CaseRoleAction)captor.getValue()).label());
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addUser(Matchers.anyString(), Matchers.anyString(), (CaseRolesPresenter.CaseRoleAction[])Mockito.anyVararg());
        ((CaseRolesPresenter.CaseRoleAction)captor.getValue()).execute();
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).removeGroupFromRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)CASE_ROLE), (String)Matchers.eq((Object)GROUP));
    }

    @Test
    public void testSetupNewRoleAssignments_rolesNotDefined() {
        CaseDefinitionSummary caseDefinition = CaseDefinitionSummary.builder().build();
        CaseInstanceSummary caseInstance = CaseRolesPresenterTest.newCaseInstanceSummary();
        this.setCaseDefinitionID(CASE_DEFINITION_ID, caseDefinition, caseInstance);
        Mockito.when((Object)this.caseManagementService.getCaseDefinition(Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)CASE_DEFINITION_ID))).thenReturn((Object)caseDefinition);
        this.presenter.setupNewRoleAssignments(caseInstance);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testSetupNewRoleAssignments_noRolesAvailableForAssignment() {
        CaseDefinitionSummary caseDefinition = CaseDefinitionSummary.builder().roles(Collections.singletonMap(CASE_ROLE, 1)).build();
        CaseInstanceSummary caseInstance = CaseRolesPresenterTest.newCaseInstanceSummary();
        caseInstance.setRoleAssignments(Collections.singletonList(CaseRoleAssignmentSummary.builder().name(CASE_ROLE).groups(Collections.emptyList()).users(Collections.singletonList(USER)).build()));
        this.setCaseDefinitionID(CASE_DEFINITION_ID, caseDefinition, caseInstance);
        Mockito.when((Object)this.caseManagementService.getCaseDefinition(Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)CASE_DEFINITION_ID))).thenReturn((Object)caseDefinition);
        this.presenter.setupNewRoleAssignments(caseInstance);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.view});
    }

    @Test
    public void testSetupNewRoleAssignments_rolesAvailableForAssignment() {
        CaseDefinitionSummary caseDefinition = CaseDefinitionSummary.builder().roles(Collections.singletonMap(CASE_ROLE, 1)).build();
        CaseInstanceSummary caseInstance = CaseRolesPresenterTest.newCaseInstanceSummary();
        this.setCaseDefinitionID(CASE_DEFINITION_ID, caseDefinition, caseInstance);
        Mockito.when((Object)this.caseManagementService.getCaseDefinition(Matchers.anyString(), Matchers.anyString(), (String)Matchers.eq((Object)CASE_DEFINITION_ID))).thenReturn((Object)caseDefinition);
        this.presenter.setupNewRoleAssignments(caseInstance);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).enableNewRoleAssignments();
        ArgumentCaptor captor = ArgumentCaptor.forClass(Command.class);
        ((CaseRolesPresenter.CaseRolesView)Mockito.verify((Object)this.view)).setUserAddCommand((Command)captor.capture());
        ((Command)captor.getValue()).execute();
        ((CaseRolesPresenter.NewRoleAssignmentView)Mockito.verify((Object)this.assignmentView)).show((Set)Matchers.eq(Collections.singleton(CASE_ROLE)), (Command)captor.capture());
        Mockito.when((Object)this.assignmentView.getUserName()).thenReturn((Object)"user1");
        Mockito.when((Object)this.assignmentView.getGroupName()).thenReturn((Object)"");
        ((Command)captor.getValue()).execute();
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).assignUserToRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        Mockito.when((Object)this.assignmentView.getUserName()).thenReturn((Object)"");
        Mockito.when((Object)this.assignmentView.getGroupName()).thenReturn((Object)"groupName");
        ((Command)captor.getValue()).execute();
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).assignGroupToRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
        Mockito.when((Object)this.assignmentView.getUserName()).thenReturn((Object)"user1");
        Mockito.when((Object)this.assignmentView.getGroupName()).thenReturn((Object)"groupName");
        ((Command)captor.getValue()).execute();
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).assignGroupAndUserToRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testGetRolesAvailableForAssignment_excludeOwnerRole() {
        String ownerRole = "owner";
        HashMap<String, Integer> roles = new HashMap<String, Integer>();
        roles.put("owner", 1);
        String[] rolesNames = new String[]{"Owner", " owner ", "OWNER"};
        Integer rolesCardinality = -1;
        Arrays.stream(rolesNames).forEach(role -> roles.put((String)role, rolesCardinality));
        CaseDefinitionSummary caseDefinition = CaseDefinitionSummary.builder().roles(roles).build();
        CaseInstanceSummary caseInstance = CaseRolesPresenterTest.newCaseInstanceSummary();
        this.setCaseDefinitionID(CASE_DEFINITION_ID, caseDefinition, caseInstance);
        Set availableRoles = this.presenter.getRolesAvailableForAssignment(caseInstance, caseDefinition);
        Assertions.assertThat((Iterable)availableRoles).doesNotContain((Object[])new String[]{"owner"}).containsAll(Arrays.asList(rolesNames));
    }

    @Test
    public void testGetRolesAvailableForAssignment_rolesWithDifferentCardinality() {
        String caseRole_1 = "Role_1";
        String caseRole_2 = "Role_2";
        String caseRole_3 = "Role_3";
        HashMap<String, Integer> roles = new HashMap<String, Integer>();
        roles.put("Role_1", -1);
        roles.put("Role_2", 2);
        roles.put("Role_3", 1);
        CaseDefinitionSummary caseDefinition = CaseDefinitionSummary.builder().roles(roles).build();
        CaseInstanceSummary caseInstance = CaseRolesPresenterTest.newCaseInstanceSummary();
        caseInstance.setRoleAssignments(caseDefinition.getRoles().keySet().stream().map(role -> CaseRoleAssignmentSummary.builder().name(role).groups(Collections.emptyList()).users(Collections.emptyList()).build()).collect(Collectors.toList()));
        this.setCaseDefinitionID(CASE_DEFINITION_ID, caseDefinition, caseInstance);
        Set availableRolesFirstPass = this.presenter.getRolesAvailableForAssignment(caseInstance, caseDefinition);
        Assertions.assertThat((Iterable)availableRolesFirstPass).contains((Object[])new String[]{"Role_1", "Role_2", "Role_3"});
        caseInstance.getRoleAssignments().stream().filter(roleAssignment -> availableRolesFirstPass.contains(roleAssignment.getName())).forEach(roleAssignment -> roleAssignment.setUsers(Collections.singletonList(USER)));
        Set availableRolesSecondPass = this.presenter.getRolesAvailableForAssignment(caseInstance, caseDefinition);
        Assertions.assertThat((Iterable)availableRolesSecondPass).contains((Object[])new String[]{"Role_1", "Role_2"}).doesNotContain((Object[])new String[]{"Role_3"});
        caseInstance.getRoleAssignments().stream().filter(roleAssignment -> availableRolesSecondPass.contains(roleAssignment.getName())).forEach(roleAssignment -> roleAssignment.setGroups(Collections.singletonList(GROUP)));
        Set availableRolesThirdPass = this.presenter.getRolesAvailableForAssignment(caseInstance, caseDefinition);
        Assertions.assertThat((Iterable)availableRolesThirdPass).contains((Object[])new String[]{"Role_1"}).doesNotContain((Object[])new String[]{"Role_2", "Role_3"});
    }

    private void setCaseDefinitionID(String caseDefinitionID, CaseDefinitionSummary caseDefinition, CaseInstanceSummary caseInstance) {
        caseDefinition.setId(caseDefinitionID);
        caseInstance.setCaseDefinitionId(caseDefinitionID);
    }
}

