/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.newcase;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.cm.client.events.CaseCreatedEvent;
import org.jbpm.workbench.cm.client.newcase.NewCaseInstancePresenter;
import org.jbpm.workbench.cm.client.util.CaseRolesValidations;
import org.jbpm.workbench.cm.model.CaseDefinitionSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class NewCaseInstancePresenterTest {
    @Mock
    EventSourceMock<NotificationEvent> notificationEvent;
    @Mock
    EventSourceMock<CaseCreatedEvent> caseCreatedEvent;
    @Mock
    NewCaseInstancePresenter.NewCaseInstanceView view;
    Caller<CaseManagementService> caseService;
    @Mock
    CaseManagementService caseManagementService;
    @Mock
    TranslationService translationService;
    @Mock
    CaseRolesValidations caseRolesValidations;
    @Mock
    User identity;
    @InjectMocks
    NewCaseInstancePresenter presenter;

    @Before
    public void init() {
        this.caseService = new CallerMock((Object)this.caseManagementService);
        this.presenter.setCaseService(this.caseService);
        this.presenter.setNotification(this.notificationEvent);
        this.presenter.setNewCaseEvent(this.caseCreatedEvent);
    }

    @Test
    public void testCreateInvalidCaseInstance() {
        this.presenter.createCaseInstance(null, Mockito.anyString(), null);
        ArgumentCaptor captor = ArgumentCaptor.forClass(NotificationEvent.class);
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(captor.capture());
        Assert.assertEquals((long)1L, (long)captor.getAllValues().size());
        Assert.assertEquals((Object)NotificationEvent.NotificationType.ERROR, (Object)((NotificationEvent)captor.getValue()).getType());
    }

    @Test
    public void testCreateCaseInstance() {
        CaseDefinitionSummary cds = CaseDefinitionSummary.builder().id("id").name("name").containerId("containerId").build();
        Mockito.when((Object)this.caseManagementService.getCaseDefinitions()).thenReturn(Arrays.asList(cds));
        String owner = "userx";
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"userx");
        Mockito.when((Object)this.caseRolesValidations.validateRolesAssignments((CaseDefinitionSummary)Mockito.any(CaseDefinitionSummary.class), Mockito.anyList())).thenReturn((Object)Collections.EMPTY_LIST);
        this.presenter.show();
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).clearCaseDefinitions();
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).setCaseDefinitions((List)captor.capture());
        List list = (List)captor.getValue();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)cds, list.get(0));
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).setOwner("userx");
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).show();
        this.presenter.createCaseInstance(cds.getUniqueId(), "userx", Collections.emptyList());
        ((CaseManagementService)Mockito.verify((Object)this.caseManagementService)).startCaseInstance(null, cds.getContainerId(), cds.getId(), "userx", Collections.emptyList());
        ((NewCaseInstancePresenter.NewCaseInstanceView)Mockito.verify((Object)this.view)).hide();
        ((EventSourceMock)Mockito.verify(this.notificationEvent)).fire(Mockito.any(NotificationEvent.class));
        ((EventSourceMock)Mockito.verify(this.caseCreatedEvent)).fire(Mockito.any(CaseCreatedEvent.class));
    }
}

